/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.ORB;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.SendingContext.RunTime;
import org.openorb.CORBA.DataInputStream;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.ObjectStub;
import org.openorb.iiop.CodeSetDatabase;
import org.openorb.io.AbstractInputStream;
import org.openorb.io.BufferSource;
import org.openorb.io.HexPrintStream;
import org.openorb.io.StorageBuffer;
import org.openorb.util.ExceptionTool;
import org.openorb.util.NumberCache;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

public class CDRInputStream
extends AbstractInputStream
implements LogEnabled {
    private static final int CODEBASE = 1;
    private static final int NO_TYPE_INFORMATION = 0;
    private static final int SINGLE_TYPE_INFORMATION = 2;
    private static final int MULTIPLE_TYPE_INFORMATION = 6;
    private static final int MASK_TYPE_INFORMATION = 6;
    private static final int CHUNK = 8;
    private org.omg.CORBA.ORB m_orb;
    private Version m_version;
    private Map m_value_cache;
    private MarkState m_mark = null;
    private String m_char_enc = "ISO-8859-1";
    private String m_wchar_enc = "UnicodeBig";
    private int m_wchar_align = 2;
    private boolean m_wchar_reverse = false;
    private int m_index = 0;
    private boolean m_swap = false;
    private int m_encaps_remain = -1;
    private int m_pending_encaps_close = 0;
    private LinkedList m_encaps_stack = new LinkedList();
    private int m_value_level = 0;
    private boolean m_pending_value_reopen = false;
    private boolean m_in_chunked_value = false;
    private int m_value_indirect = -1;
    private int m_continue_level = 0;
    private Logger m_logger;
    private OctetSeqHolder m_tmp_buf = new OctetSeqHolder();
    private IntHolder m_tmp_off = new IntHolder();
    private IntHolder m_tmp_len = new IntHolder();
    static /* synthetic */ Class class$org$omg$CORBA$Object;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, boolean bl, Version version, StorageBuffer storageBuffer) {
        super(storageBuffer);
        this.m_orb = oRB;
        this.bigEndian(bl);
        this.m_version = version;
        if (this.m_version.minor == 0) {
            this.m_char_enc = "ISO-8859-1";
            this.m_wchar_enc = null;
        }
    }

    public CDRInputStream(org.omg.CORBA.ORB oRB, boolean bl, Version version, BufferSource bufferSource) {
        super(bufferSource);
        this.m_orb = oRB;
        this.bigEndian(bl);
        this.m_version = version;
        if (this.m_version.minor == 0) {
            this.m_char_enc = "ISO-8859-1";
            this.m_wchar_enc = null;
        }
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public void setCodesets(int n, int n2) {
        if (n != 0) {
            this.m_char_enc = CodeSetDatabase.getNameFromId(n);
            if (CodeSetDatabase.getAlignmentFromId(n) > 1) {
                throw new CODESET_INCOMPATIBLE(0, CompletionStatus.COMPLETED_NO);
            }
        }
        if (n2 == 0) {
            this.m_wchar_enc = null;
        } else {
            this.m_wchar_enc = CodeSetDatabase.getNameFromId(n2);
            if (this.m_wchar_enc.equals("UnicodeBigUnmarked")) {
                this.m_wchar_enc = "UnicodeBig";
            }
            this.m_wchar_align = CodeSetDatabase.getAlignmentFromId(n2);
            if (this.m_version.minor == 1 && this.m_wchar_align != 2) {
                throw new CODESET_INCOMPATIBLE(0, CompletionStatus.COMPLETED_NO);
            }
            if (this.m_swap && this.m_wchar_align > 1) {
                String string = CodeSetDatabase.getCanonicalNameFromId(n2);
                if (string.startsWith("Unicode")) {
                    if (this.m_version.minor == 1) {
                        this.m_wchar_enc = "UnicodeLittle";
                    }
                } else {
                    this.m_wchar_reverse = true;
                }
            }
        }
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug("New codesets for input stream set to [" + this.m_char_enc + "] and [" + this.m_wchar_enc + "].");
        }
    }

    public int index() {
        return this.m_index;
    }

    public void reset_index() {
        this.m_index = 0;
    }

    public Version version() {
        return this.m_version;
    }

    public boolean bigEndian() {
        return !this.m_swap;
    }

    public void bigEndian(boolean bl) {
        this.m_swap = !bl;
    }

    public void alignment(int n) {
        int n2;
        if (this.m_pending_value_reopen) {
            this.m_pending_value_reopen = false;
            n2 = this.peek_long();
            if (n2 < 0x7FFFFF00 || n2 > Integer.MAX_VALUE) {
                this.begin_value_chunk(this.read_long());
            }
        }
        if (n > 1 && (n2 = this.m_index % n) != 0) {
            this.force_skip(n - n2);
        }
    }

    public void begin_encapsulation() {
        int n = this.read_ulong();
        this.m_encaps_stack.addLast(this.m_swap ? Boolean.TRUE : Boolean.FALSE);
        this.m_encaps_stack.addLast(NumberCache.getInteger(this.m_encaps_remain));
        this.m_encaps_stack.addLast(NumberCache.getInteger(this.m_index));
        this.m_encaps_stack.addLast(Boolean.FALSE);
        this.m_encaps_remain = n;
        this.m_in_chunked_value = false;
        this.m_swap = this.read_boolean();
    }

    public void end_encapsulation() {
        if (this.m_pending_encaps_close == 0) {
            this.force_skip(this.m_encaps_remain);
        }
        --this.m_pending_encaps_close;
    }

    public long skip(long l) {
        long l2 = super.skip(l);
        this.postread((int)l2);
        return l2;
    }

    public void mark(int n) {
        super.mark(n);
        this.m_mark = new MarkState();
    }

    public void reset() throws IOException {
        super.reset();
        this.m_mark.reset();
        this.m_mark = null;
    }

    public boolean read_boolean() {
        return this.read_octet() == 1;
    }

    public char read_char() {
        this.alignment(1);
        this.m_tmp_len.value = 1;
        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        this.postread(1);
        try {
            String string = new String(this.m_tmp_buf.value, this.m_tmp_off.value, 1, this.m_char_enc);
            if (string.length() == 1) {
                return string.charAt(0);
            }
            this.cancel(new MARSHAL("Unable to decode char value", 1146056976, CompletionStatus.COMPLETED_MAYBE));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
        }
        return '\u0000';
    }

    public char read_wchar() {
        if (this.m_wchar_enc == null) {
            if (this.m_version.minor == 0) {
                this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.cancel(new MARSHAL("Missing wchar encoder.", 1146056977, CompletionStatus.COMPLETED_MAYBE));
            }
            return '\u0000';
        }
        byte[] byArray = null;
        int n = 0;
        int n2 = 0;
        switch (this.m_version.minor) {
            case 0: {
                this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                return '\u0000';
            }
            case 1: {
                this.alignment(2);
                this.m_tmp_len.value = 2;
                n2 = 2;
                this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                if (this.m_tmp_len.value != 0) {
                    byArray = new byte[2];
                    if (this.m_wchar_reverse) {
                        byArray[1] = this.m_tmp_buf.value[this.m_tmp_off.value];
                        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                        byArray[0] = this.m_tmp_buf.value[this.m_tmp_off.value];
                    } else {
                        byArray[0] = this.m_tmp_buf.value[this.m_tmp_off.value];
                        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                        byArray[1] = this.m_tmp_buf.value[this.m_tmp_off.value];
                    }
                    n = 0;
                } else if (this.m_wchar_reverse) {
                    byArray = new byte[]{this.m_tmp_buf.value[1], this.m_tmp_buf.value[0]};
                    n = 0;
                } else {
                    byArray = this.m_tmp_buf.value;
                    n = this.m_tmp_off.value;
                }
                this.postread(2);
                break;
            }
            case 2: {
                int n3;
                this.alignment(1);
                this.m_tmp_len.value = 1;
                this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                n2 = this.m_tmp_len.value = this.m_tmp_buf.value[this.m_tmp_off.value];
                this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                this.postread(n2 - this.m_tmp_len.value + 1);
                if (this.m_tmp_len.value != 0) {
                    byArray = new byte[n2];
                    n = 0;
                    System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, byArray, 0, n2 - this.m_tmp_len.value);
                    this.read_octet_array(byArray, n2 - this.m_tmp_len.value, this.m_tmp_len.value);
                    if (!this.m_wchar_reverse) break;
                    int n4 = 0;
                    while (n4 < this.m_wchar_align / 2) {
                        n3 = byArray[n4];
                        byArray[n4] = byArray[this.m_wchar_align - n4];
                        byArray[this.m_wchar_align - n4] = n3;
                        ++n4;
                    }
                    break;
                }
                if (this.m_wchar_reverse) {
                    byArray = new byte[n2];
                    n = 0;
                    n3 = 0;
                    while (n3 < this.m_wchar_align) {
                        byArray[n3] = this.m_tmp_buf.value[this.m_tmp_off.value + this.m_wchar_align - n3];
                        ++n3;
                    }
                    break;
                }
                byArray = this.m_tmp_buf.value;
                n = this.m_tmp_off.value;
            }
        }
        try {
            String string = new String(byArray, n, n2, this.m_wchar_enc);
            if (string.length() == 1) {
                return string.charAt(0);
            }
            this.cancel(new MARSHAL("Unable to decode wchar value", 1146056977, CompletionStatus.COMPLETED_MAYBE));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
        }
        return '\u0000';
    }

    public byte read_octet() {
        this.alignment(1);
        this.m_tmp_len.value = 1;
        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        byte by = this.m_tmp_buf.value[this.m_tmp_off.value];
        this.postread(1);
        return by;
    }

    public short read_short() {
        int n;
        this.alignment(2);
        this.m_tmp_len.value = 2;
        if (this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len) == 2) {
            n = (this.m_tmp_buf.value[this.m_tmp_off.value] & 0xFF) << (this.m_swap ? 0 : 8) | (this.m_tmp_buf.value[this.m_tmp_off.value + 1] & 0xFF) << (this.m_swap ? 8 : 0);
        } else {
            n = (this.m_tmp_buf.value[this.m_tmp_off.value] & 0xFF) << (this.m_swap ? 0 : 8);
            this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            n |= (this.m_tmp_buf.value[this.m_tmp_off.value] & 0xFF) << (this.m_swap ? 8 : 0);
        }
        this.postread(2);
        return (short)n;
    }

    public short read_ushort() {
        return this.read_short();
    }

    public int read_long() {
        int n;
        this.alignment(4);
        this.m_tmp_len.value = 4;
        int n2 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        if (n2 == 4) {
            n = (this.m_tmp_buf.value[this.m_tmp_off.value] & 0xFF) << (this.m_swap ? 0 : 24) | (this.m_tmp_buf.value[this.m_tmp_off.value + 1] & 0xFF) << (this.m_swap ? 8 : 16) | (this.m_tmp_buf.value[this.m_tmp_off.value + 2] & 0xFF) << (this.m_swap ? 16 : 8) | (this.m_tmp_buf.value[this.m_tmp_off.value + 3] & 0xFF) << (this.m_swap ? 24 : 0);
        } else {
            n = 0;
            int n3 = this.m_swap ? 0 : 24;
            while (true) {
                int n4 = 0;
                while (n4 < n2) {
                    n |= (this.m_tmp_buf.value[this.m_tmp_off.value + n4] & 0xFF) << n3;
                    n3 += this.m_swap ? 8 : -8;
                    ++n4;
                }
                boolean bl = this.m_swap ? n3 < 24 : n3 > 0;
                if (!bl) break;
                n2 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            }
        }
        this.postread(4);
        return n;
    }

    private int peek_long() {
        this.mark(4);
        int n = this.read_long();
        try {
            this.reset();
        }
        catch (IOException iOException) {
            this.getLogger().error("IOException during reset().", iOException);
        }
        return n;
    }

    public int read_ulong() {
        return this.read_long();
    }

    public long read_longlong() {
        long l;
        this.alignment(8);
        this.m_tmp_len.value = 8;
        int n = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        if (n == 8) {
            l = ((long)this.m_tmp_buf.value[this.m_tmp_off.value] & 0xFFL) << (this.m_swap ? 0 : 56) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 1] & 0xFFL) << (this.m_swap ? 8 : 48) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 2] & 0xFFL) << (this.m_swap ? 16 : 40) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 3] & 0xFFL) << (this.m_swap ? 24 : 32) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 4] & 0xFFL) << (this.m_swap ? 32 : 24) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 5] & 0xFFL) << (this.m_swap ? 40 : 16) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 6] & 0xFFL) << (this.m_swap ? 48 : 8) | ((long)this.m_tmp_buf.value[this.m_tmp_off.value + 7] & 0xFFL) << (this.m_swap ? 56 : 0);
        } else {
            l = 0L;
            long l2 = this.m_swap ? 0L : 56L;
            while (true) {
                int n2 = 0;
                while (n2 < n) {
                    l |= (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n2] & 0xFF) << (int)l2;
                    l2 += this.m_swap ? 8L : -8L;
                    ++n2;
                }
                boolean bl = this.m_swap ? l2 < 56L : l2 > 0L;
                if (!bl) break;
                n = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            }
        }
        this.postread(8);
        return l;
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    public String read_string() {
        int n;
        byte[] byArray;
        int n2;
        this.m_tmp_len.value = n2 = this.read_ulong();
        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        this.postread(n2 - this.m_tmp_len.value);
        if (this.m_tmp_len.value == 0) {
            byArray = this.m_tmp_buf.value;
            n = this.m_tmp_off.value;
        } else {
            byArray = new byte[n2];
            n = 0;
            System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, byArray, 0, n2 - this.m_tmp_len.value);
            this.read_octet_array(byArray, n2 - this.m_tmp_len.value, this.m_tmp_len.value);
        }
        try {
            return new String(byArray, n, n2 - 1, this.m_char_enc);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
            return null;
        }
    }

    public String read_wstring() {
        byte by;
        int n;
        int n2;
        int n3;
        byte[] byArray;
        if (this.m_version.minor == 0) {
            this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            return null;
        }
        if (this.m_wchar_enc == null) {
            this.cancel(new MARSHAL("Missing wchar encoder.", 1146056977, CompletionStatus.COMPLETED_MAYBE));
            return null;
        }
        int n4 = this.read_ulong();
        if (this.m_version.minor == 1 && this.m_wchar_align > 1) {
            n4 *= this.m_wchar_align;
        }
        this.m_tmp_len.value = n4;
        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        this.postread(n4 - this.m_tmp_len.value);
        if (this.m_tmp_len.value != 0) {
            byArray = new byte[n4];
            n3 = 0;
            System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, byArray, 0, n4 - this.m_tmp_len.value);
            this.read_octet_array(byArray, n4 - this.m_tmp_len.value, this.m_tmp_len.value);
            if (this.m_wchar_reverse) {
                n2 = 0;
                while (n2 < n4) {
                    n = 0;
                    while (n < this.m_wchar_align / 2) {
                        by = byArray[n3 + n2 + n];
                        byArray[n3 + n2 + n] = byArray[n3 + n2 + this.m_wchar_align - n - 1];
                        byArray[n3 + n2 + this.m_wchar_align - n - 1] = by;
                        ++n;
                    }
                    n2 += this.m_wchar_align;
                }
            }
        } else if (this.m_wchar_reverse) {
            byArray = new byte[n4];
            n3 = 0;
            n2 = 0;
            while (n2 < n4) {
                n = 0;
                while (n < this.m_wchar_align) {
                    byArray[n2 + n] = this.m_tmp_buf.value[this.m_tmp_off.value + n2 + this.m_wchar_align - n - 1];
                    ++n;
                }
                n2 += this.m_wchar_align;
            }
        } else {
            byArray = this.m_tmp_buf.value;
            n3 = this.m_tmp_off.value;
        }
        if (this.m_version.minor == 1) {
            n4 -= this.m_wchar_align == 0 ? 1 : this.m_wchar_align;
        }
        if (byArray[n3] == -2 && byArray[n3 + 1] == -1) {
            n3 += 2;
            n4 -= 2;
        } else if (byArray[n3] == -1 && byArray[n3 + 1] == -2) {
            n3 += 2;
            n4 -= 2;
            n2 = 0;
            while (n2 < n4) {
                n = 0;
                while (n < this.m_wchar_align / 2) {
                    by = byArray[n3 + n2 + n];
                    byArray[n3 + n2 + n] = byArray[n3 + n2 + this.m_wchar_align - n - 1];
                    byArray[n3 + n2 + this.m_wchar_align - n - 1] = by;
                    ++n;
                }
                n2 += this.m_wchar_align;
            }
        }
        if (n4 == 0) {
            return "";
        }
        try {
            return new String(byArray, n3, n4, this.m_wchar_enc);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
            return null;
        }
    }

    public void read_boolean_array(boolean[] blArray, int n, int n2) {
        this.alignment(1);
        this.m_tmp_len.value = n2;
        while (this.m_tmp_len.value > 0) {
            int n3 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            int n4 = 0;
            while (n4 < n3) {
                blArray[n + n4] = this.m_tmp_buf.value[this.m_tmp_off.value + n4] == 1;
                ++n4;
            }
            n += n3;
        }
        this.postread(n2);
    }

    public void read_char_array(char[] cArray, int n, int n2) {
        int n3;
        byte[] byArray;
        this.alignment(1);
        this.m_tmp_len.value = n2;
        this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
        this.postread(n2 - this.m_tmp_len.value);
        if (this.m_tmp_len.value == 0) {
            byArray = this.m_tmp_buf.value;
            n3 = this.m_tmp_off.value;
        } else {
            byArray = new byte[n2];
            n3 = 0;
            System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, byArray, 0, n2 - this.m_tmp_len.value);
            this.read_octet_array(byArray, n2 - this.m_tmp_len.value, this.m_tmp_len.value);
        }
        try {
            String string = new String(byArray, n3, n2, this.m_char_enc);
            if (string.length() != n2) {
                this.cancel(new MARSHAL("Unable to decode char value", 1146056976, CompletionStatus.COMPLETED_MAYBE));
            }
            string.getChars(0, n2, cArray, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
        }
    }

    public void read_wchar_array(char[] cArray, int n, int n2) {
        if (this.m_wchar_enc == null) {
            if (this.m_version.minor == 0) {
                this.cancel(new BAD_OPERATION("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.cancel(new MARSHAL("Missing wchar encoder.", 1146056977, CompletionStatus.COMPLETED_MAYBE));
            }
            return;
        }
        switch (this.m_version.minor) {
            case 0: {
                this.cancel(new MARSHAL("Wchar not supported in IIOP 1.0", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            case 1: {
                int n3;
                int n4;
                byte[] byArray;
                this.alignment(2);
                int n5 = this.m_tmp_len.value = 2 * n2;
                this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                this.postread(n5 - this.m_tmp_len.value);
                if (this.m_tmp_len.value != 0) {
                    byArray = new byte[n5];
                    n4 = 0;
                    System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, byArray, 0, n5 - this.m_tmp_len.value);
                    this.read_octet_array(byArray, n5 - this.m_tmp_len.value, this.m_tmp_len.value);
                    if (this.m_wchar_reverse) {
                        int n6 = 0;
                        while (n6 < n5) {
                            n3 = byArray[n6];
                            byArray[n6] = byArray[n6 + 1];
                            byArray[n6 + 1] = n3;
                            n6 += 2;
                        }
                    }
                } else if (this.m_wchar_reverse) {
                    byArray = new byte[n5];
                    n4 = 0;
                    n3 = 0;
                    while (n3 < n5) {
                        byArray[0] = this.m_tmp_buf.value[this.m_tmp_off.value + n3 + 1];
                        byArray[1] = this.m_tmp_buf.value[this.m_tmp_off.value + n3];
                        n3 += 2;
                    }
                } else {
                    byArray = this.m_tmp_buf.value;
                    n4 = this.m_tmp_off.value;
                }
                try {
                    String string = new String(byArray, n4, n5, this.m_wchar_enc);
                    if (string.length() != n2) {
                        this.cancel(new MARSHAL("Unable to decode char value", 1146056976, CompletionStatus.COMPLETED_MAYBE));
                    }
                    string.getChars(0, n2, cArray, n);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
                }
                return;
            }
            case 2: {
                this.alignment(1);
                int n7 = 0;
                int n8 = 0;
                while (n8 < n2) {
                    int n9;
                    byte[] byArray;
                    this.m_tmp_len.value = 1;
                    this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                    int n10 = this.m_tmp_len.value = this.m_tmp_buf.value[this.m_tmp_off.value];
                    this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                    if (this.m_tmp_len.value != 0) {
                        this.postread(n7 + n10 + 1 - this.m_tmp_len.value);
                        n7 = 0;
                        byArray = new byte[n10];
                        n9 = 0;
                        System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, byArray, 0, n10 - this.m_tmp_len.value);
                        this.read_octet_array(byArray, n10 - this.m_tmp_len.value, this.m_tmp_len.value);
                        if (this.m_wchar_reverse) {
                            int n11 = 0;
                            while (n11 < this.m_wchar_align / 2) {
                                byte by = byArray[n9 + n11];
                                byArray[n9 + n11] = byArray[n9 + this.m_wchar_align - n11];
                                byArray[n9 + this.m_wchar_align - n11] = by;
                                ++n11;
                            }
                        }
                    } else if (this.m_wchar_reverse) {
                        byArray = new byte[n10];
                        n9 = 0;
                        int n12 = 0;
                        while (n12 < this.m_wchar_align) {
                            byArray[n12] = this.m_tmp_buf.value[this.m_tmp_off.value + this.m_wchar_align - 1];
                            ++n12;
                        }
                    } else {
                        n7 += n10 + 1;
                        byArray = this.m_tmp_buf.value;
                        n9 = this.m_tmp_off.value;
                    }
                    try {
                        String string = new String(byArray, n9, n10, this.m_wchar_enc);
                        if (string.length() != 1) {
                            this.cancel(new MARSHAL("Unable to decode wchar value", 1146056977, CompletionStatus.COMPLETED_MAYBE));
                        }
                        cArray[n + n8] = string.charAt(0);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
                    }
                    ++n8;
                }
                if (n7 <= 0) break;
                this.postread(n7);
            }
        }
    }

    public void read_octet_array(byte[] byArray, int n, int n2) {
        this.alignment(1);
        this.m_tmp_len.value = n2;
        while (this.m_tmp_len.value > 0) {
            int n3 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            System.arraycopy(this.m_tmp_buf.value, this.m_tmp_off.value, byArray, n, n3);
            n += n3;
        }
        this.postread(n2);
    }

    public void read_short_array(short[] sArray, int n, int n2) {
        this.alignment(2);
        this.m_tmp_len.value = n2 * 2;
        while (this.m_tmp_len.value > 0) {
            int n3 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            int n4 = 0;
            while (n4 < n3 - 1) {
                sArray[n] = (short)((this.m_tmp_buf.value[this.m_tmp_off.value + n4] & 0xFF) << (this.m_swap ? 0 : 8) | (this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 1] & 0xFF) << (this.m_swap ? 8 : 0));
                n4 += 2;
                ++n;
            }
            if (n3 % 2 == 0) continue;
            int n5 = (this.m_tmp_buf.value[this.m_tmp_off.value + n3] & 0xFF) << (this.m_swap ? 0 : 8);
            int n6 = this.m_tmp_len.value;
            this.m_tmp_len.value = 1;
            this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            sArray[n] = (short)(n5 | (this.m_tmp_buf.value[this.m_tmp_off.value] & 0xFF) << (this.m_swap ? 8 : 0));
            ++n;
            this.m_tmp_len.value = n6 - 1;
        }
        this.postread(n2 * 2);
    }

    public void read_ushort_array(short[] sArray, int n, int n2) {
        this.read_short_array(sArray, n, n2);
    }

    public void read_long_array(int[] nArray, int n, int n2) {
        this.alignment(4);
        this.m_tmp_len.value = n2 * 4;
        while (this.m_tmp_len.value > 0) {
            int n3 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            int n4 = 0;
            while (n4 < n3 - 3) {
                nArray[n] = (this.m_tmp_buf.value[this.m_tmp_off.value + n4] & 0xFF) << (this.m_swap ? 0 : 24) | (this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 1] & 0xFF) << (this.m_swap ? 8 : 16) | (this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 2] & 0xFF) << (this.m_swap ? 16 : 8) | (this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 3] & 0xFF) << (this.m_swap ? 24 : 0);
                n4 += 4;
                ++n;
            }
            if (n3 % 4 == 0) continue;
            nArray[n] = 0;
            int n5 = n3 % 4;
            n3 -= n3 % 4;
            int n6 = 0;
            while (n6 < n5) {
                nArray[n] = nArray[n] | (this.m_tmp_buf.value[this.m_tmp_off.value + n3 + n6] & 0xFF) << (this.m_swap ? 8 * n6 : 24 - 8 * n6);
                ++n6;
            }
            int n7 = this.m_tmp_len.value - (4 - n6);
            while (n6 < 4) {
                this.m_tmp_len.value = 4 - n6;
                n3 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                int n8 = 0;
                while (n8 < n3) {
                    nArray[n] = nArray[n] | (this.m_tmp_buf.value[this.m_tmp_off.value + n8] & 0xFF) << (this.m_swap ? 8 * n6 : 24 - 8 * n6);
                    ++n8;
                    ++n6;
                }
            }
            this.m_tmp_len.value = n7;
        }
        this.postread(n2 * 4);
    }

    public void read_ulong_array(int[] nArray, int n, int n2) {
        this.read_long_array(nArray, n, n2);
    }

    public void read_longlong_array(long[] lArray, int n, int n2) {
        this.alignment(8);
        this.m_tmp_len.value = n2 * 8;
        while (this.m_tmp_len.value > 0) {
            int n3 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            int n4 = 0;
            while (n4 < n3 - 7) {
                lArray[n] = (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4] & 0xFF) << (int)(this.m_swap ? 0L : 56L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 1] & 0xFF) << (int)(this.m_swap ? 8L : 48L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 2] & 0xFF) << (int)(this.m_swap ? 16L : 40L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 3] & 0xFF) << (int)(this.m_swap ? 24L : 32L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 4] & 0xFF) << (int)(this.m_swap ? 32L : 24L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 5] & 0xFF) << (int)(this.m_swap ? 40L : 16L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 6] & 0xFF) << (int)(this.m_swap ? 48L : 8L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 7] & 0xFF) << (int)(this.m_swap ? 56L : 0L);
                n4 += 8;
                ++n;
            }
            if (n3 % 8 == 0) continue;
            lArray[n] = 0L;
            int n5 = n3 % 8;
            n3 -= n3 % 8;
            int n6 = 0;
            while (n6 < n5) {
                lArray[n] = lArray[n] | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n3 + n6] & 0xFF) << (int)(this.m_swap ? (long)(8 * n6) : (long)(56 - 8 * n6));
                ++n6;
            }
            int n7 = this.m_tmp_len.value - (8 - n6);
            while (n6 < 8) {
                this.m_tmp_len.value = 8 - n6;
                n3 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                int n8 = 0;
                while (n8 < n3) {
                    lArray[n] = lArray[n] | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n8] & 0xFF) << (int)(this.m_swap ? (long)(8 * n6) : (long)(56 - 8 * n6));
                    ++n8;
                    ++n6;
                }
            }
            this.m_tmp_len.value = n7;
        }
        this.postread(n2 * 8);
    }

    public void read_ulonglong_array(long[] lArray, int n, int n2) {
        this.read_longlong_array(lArray, n, n2);
    }

    public void read_float_array(float[] fArray, int n, int n2) {
        this.alignment(4);
        this.m_tmp_len.value = n2 * 4;
        while (this.m_tmp_len.value > 0) {
            int n3 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            int n4 = 0;
            while (n4 < n3 - 3) {
                fArray[n] = Float.intBitsToFloat((this.m_tmp_buf.value[this.m_tmp_off.value + n4] & 0xFF) << (this.m_swap ? 0 : 24) | (this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 1] & 0xFF) << (this.m_swap ? 8 : 16) | (this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 2] & 0xFF) << (this.m_swap ? 16 : 8) | (this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 3] & 0xFF) << (this.m_swap ? 24 : 0));
                n4 += 4;
                ++n;
            }
            if (n3 % 4 == 0) continue;
            int n5 = 0;
            fArray[n] = 0.0f;
            int n6 = n3 % 4;
            n3 -= n3 % 4;
            int n7 = 0;
            while (n7 < n6) {
                n5 |= (this.m_tmp_buf.value[this.m_tmp_off.value + n3 + n7] & 0xFF) << (this.m_swap ? 8 * n7 : 24 - 8 * n7);
                ++n7;
            }
            fArray[n] = Float.intBitsToFloat(n5);
            int n8 = this.m_tmp_len.value - (4 - n7);
            while (n7 < 4) {
                this.m_tmp_len.value = 4 - n7;
                n3 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                int n9 = 0;
                while (n9 < n3) {
                    n5 |= (this.m_tmp_buf.value[this.m_tmp_off.value + n9] & 0xFF) << (this.m_swap ? 8 * n7 : 24 - 8 * n7);
                    ++n9;
                    ++n7;
                }
                fArray[n] = Float.intBitsToFloat(n5);
            }
            this.m_tmp_len.value = n8;
        }
        this.postread(n2 * 4);
    }

    public void read_double_array(double[] dArray, int n, int n2) {
        this.alignment(8);
        this.m_tmp_len.value = n2 * 8;
        while (this.m_tmp_len.value > 0) {
            int n3 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
            int n4 = 0;
            while (n4 < n3 - 7) {
                dArray[n] = Double.longBitsToDouble((long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4] & 0xFF) << (int)(this.m_swap ? 0L : 56L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 1] & 0xFF) << (int)(this.m_swap ? 8L : 48L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 2] & 0xFF) << (int)(this.m_swap ? 16L : 40L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 3] & 0xFF) << (int)(this.m_swap ? 24L : 32L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 4] & 0xFF) << (int)(this.m_swap ? 32L : 24L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 5] & 0xFF) << (int)(this.m_swap ? 40L : 16L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 6] & 0xFF) << (int)(this.m_swap ? 48L : 8L) | (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n4 + 7] & 0xFF) << (int)(this.m_swap ? 56L : 0L));
                n4 += 8;
                ++n;
            }
            if (n3 % 8 == 0) continue;
            long l = 0L;
            dArray[n] = 0.0;
            int n5 = n3 % 8;
            n3 -= n3 % 8;
            int n6 = 0;
            while (n6 < n5) {
                l |= (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n3 + n6] & 0xFF) << (int)(this.m_swap ? (long)(8 * n6) : (long)(56 - 8 * n6));
                ++n6;
            }
            dArray[n] = Double.longBitsToDouble(l);
            int n7 = this.m_tmp_len.value - (8 - n6);
            while (n6 < 8) {
                this.m_tmp_len.value = 8 - n6;
                n3 = this.next(this.m_tmp_buf, this.m_tmp_off, this.m_tmp_len);
                int n8 = 0;
                while (n8 < n3) {
                    l |= (long)(this.m_tmp_buf.value[this.m_tmp_off.value + n8] & 0xFF) << (int)(this.m_swap ? (long)(8 * n6) : (long)(56 - 8 * n6));
                    ++n8;
                    ++n6;
                }
                dArray[n] = Double.longBitsToDouble(l);
            }
            this.m_tmp_len.value = n7;
        }
        this.postread(n2 * 8);
    }

    public TypeCode read_TypeCode() {
        return this.read_TypeCodeValue(new HashMap());
    }

    private TypeCode read_TypeCodeValue(HashMap hashMap) {
        TypeCode typeCode = null;
        this.alignment(4);
        Integer n = NumberCache.getInteger(this.m_index);
        int n2 = this.read_ulong();
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                typeCode = this.m_orb.get_primitive_tc(TCKind.from_int(n2));
                break;
            }
            case 14: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string2 = this.read_string();
                this.end_encapsulation();
                typeCode = this.m_orb.create_interface_tc(string, string2);
                break;
            }
            case 15: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string3 = this.read_string();
                hashMap.put(n, string);
                int n3 = this.read_ulong();
                StructMember[] structMemberArray = new StructMember[n3];
                int n4 = 0;
                while (n4 < n3) {
                    structMemberArray[n4] = new StructMember();
                    structMemberArray[n4].name = this.read_string();
                    structMemberArray[n4].type = this.read_TypeCodeValue(hashMap);
                    ++n4;
                }
                this.end_encapsulation();
                typeCode = this.m_orb.create_struct_tc(string, string3, structMemberArray);
                break;
            }
            case 16: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string4 = this.read_string();
                hashMap.put(n, string);
                TypeCode typeCode2 = this.read_TypeCodeValue(hashMap);
                int n5 = this.read_long();
                int n6 = this.read_ulong();
                UnionMember[] unionMemberArray = new UnionMember[n6];
                int n7 = 0;
                while (n7 < n6) {
                    unionMemberArray[n7] = new UnionMember();
                    unionMemberArray[n7].label = this.m_orb.create_any();
                    unionMemberArray[n7].label.read_value(this, typeCode2);
                    if (n7 == n5) {
                        unionMemberArray[n7].label.insert_octet((byte)0);
                    }
                    unionMemberArray[n7].name = this.read_string();
                    unionMemberArray[n7].type = this.read_TypeCodeValue(hashMap);
                    ++n7;
                }
                this.end_encapsulation();
                typeCode = this.m_orb.create_union_tc(string, string4, typeCode2, unionMemberArray);
                break;
            }
            case 17: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string5 = this.read_string();
                int n8 = this.read_ulong();
                String[] stringArray = new String[n8];
                int n9 = 0;
                while (n9 < n8) {
                    stringArray[n9] = this.read_string();
                    ++n9;
                }
                this.end_encapsulation();
                typeCode = this.m_orb.create_enum_tc(string, string5, stringArray);
                break;
            }
            case 18: {
                int n10 = this.read_ulong();
                typeCode = this.m_orb.create_string_tc(n10);
                break;
            }
            case 19: {
                this.begin_encapsulation();
                TypeCode typeCode3 = this.read_TypeCodeValue(hashMap);
                int n11 = this.read_ulong();
                this.end_encapsulation();
                typeCode = this.m_orb.create_sequence_tc(n11, typeCode3);
                break;
            }
            case 20: {
                this.begin_encapsulation();
                TypeCode typeCode4 = this.read_TypeCodeValue(hashMap);
                int n12 = this.read_ulong();
                this.end_encapsulation();
                typeCode = this.m_orb.create_array_tc(n12, typeCode4);
                break;
            }
            case 21: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string6 = this.read_string();
                hashMap.put(n, string);
                TypeCode typeCode5 = this.read_TypeCodeValue(hashMap);
                this.end_encapsulation();
                typeCode = this.m_orb.create_alias_tc(string, string6, typeCode5);
                break;
            }
            case 22: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string7 = this.read_string();
                hashMap.put(n, string);
                int n13 = this.read_ulong();
                StructMember[] structMemberArray = new StructMember[n13];
                int n14 = 0;
                while (n14 < n13) {
                    structMemberArray[n14] = new StructMember();
                    structMemberArray[n14].name = this.read_string();
                    structMemberArray[n14].type = this.read_TypeCodeValue(hashMap);
                    ++n14;
                }
                this.end_encapsulation();
                typeCode = this.m_orb.create_exception_tc(string, string7, structMemberArray);
                hashMap.put(n, typeCode);
                break;
            }
            case 27: {
                int n15 = this.read_ulong();
                typeCode = this.m_orb.create_wstring_tc(n15);
                break;
            }
            case 28: {
                short s = this.read_ushort();
                short s2 = this.read_ushort();
                typeCode = this.m_orb.create_fixed_tc(s, s2);
                break;
            }
            case 29: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string8 = this.read_string();
                hashMap.put(n, string);
                short s = this.read_short();
                TypeCode typeCode6 = this.read_TypeCodeValue(hashMap);
                int n16 = this.read_ulong();
                ValueMember[] valueMemberArray = new ValueMember[n16];
                int n17 = 0;
                while (n17 < n16) {
                    valueMemberArray[n17] = new ValueMember();
                    valueMemberArray[n17].name = this.read_string();
                    valueMemberArray[n17].type = this.read_TypeCodeValue(hashMap);
                    valueMemberArray[n17].access = this.read_short();
                    ++n17;
                }
                this.end_encapsulation();
                typeCode = this.m_orb.create_value_tc(string, string8, s, typeCode6, valueMemberArray);
                break;
            }
            case 30: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string9 = this.read_string();
                hashMap.put(n, string);
                TypeCode typeCode7 = this.read_TypeCodeValue(hashMap);
                this.end_encapsulation();
                typeCode = this.m_orb.create_value_box_tc(string, string9, typeCode7);
                break;
            }
            case 31: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string10 = this.read_string();
                this.end_encapsulation();
                typeCode = this.m_orb.create_native_tc(string, string10);
                break;
            }
            case 32: {
                this.begin_encapsulation();
                String string = this.read_string();
                String string11 = this.read_string();
                this.end_encapsulation();
                typeCode = this.m_orb.create_abstract_interface_tc(string, string11);
                break;
            }
            case -1: {
                int n18 = this.m_index + this.read_long();
                java.lang.Object v = hashMap.get(NumberCache.getInteger(n18));
                if (v instanceof String) {
                    typeCode = this.m_orb.create_recursive_tc((String)v);
                    break;
                }
                if (v != null) {
                    typeCode = (TypeCode)v;
                    break;
                }
                this.cancel(new MARSHAL("Invalid typecode offset", 1146056978, CompletionStatus.COMPLETED_MAYBE));
                break;
            }
            default: {
                this.cancel(new MARSHAL("Invalid typecode kind", 1146056979, CompletionStatus.COMPLETED_MAYBE));
            }
        }
        hashMap.put(n, typeCode);
        return typeCode;
    }

    public Any read_any() {
        TypeCode typeCode = this.read_TypeCode();
        Any any = this.m_orb.create_any();
        any.read_value(this, typeCode);
        return any;
    }

    public Principal read_Principal() {
        byte[] byArray = new byte[this.read_ulong()];
        this.read_octet_array(byArray, 0, byArray.length);
        return new org.openorb.CORBA.Principal(byArray);
    }

    public Object read_Object() {
        IOR iOR = IORHelper.read(this);
        if (iOR.type_id.length() == 0 && iOR.profiles.length == 0) {
            return null;
        }
        return new ObjectStub(this.m_orb, iOR);
    }

    public Object read_Object(Class clazz) {
        IOR iOR = IORHelper.read(this);
        if (iOR.type_id.length() == 0 && iOR.profiles.length == 0) {
            return null;
        }
        if (clazz == null || !(class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = CDRInputStream.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object).isAssignableFrom(clazz)) {
            return new ObjectStub(this.m_orb, iOR);
        }
        ObjectImpl objectImpl = null;
        try {
            objectImpl = (ObjectImpl)clazz.newInstance();
        }
        catch (Exception exception) {
            this.cancel(ExceptionTool.initCause(new BAD_PARAM("Unable to instantiate class", 1146056962, CompletionStatus.COMPLETED_NO), (Throwable)exception));
        }
        Delegate delegate = new Delegate(this.m_orb, iOR);
        objectImpl._set_delegate(delegate);
        return objectImpl;
    }

    public Context read_Context() {
        java.lang.Object object;
        NVList nVList = this.m_orb.create_list(0);
        int n = this.read_ulong() / 2;
        int n2 = 0;
        while (n2 < n) {
            object = this.m_orb.create_any();
            String string = this.read_string();
            ((Any)object).insert_string(this.read_string());
            nVList.add_value(string, (Any)object, 0);
            ++n2;
        }
        object = new org.openorb.CORBA.dii.Context("", null, this.m_orb);
        ((Context)object).set_values(nVList);
        return object;
    }

    public BigDecimal read_fixed() {
        return this.read_fixed((short)-1, (short)-1);
    }

    public BigDecimal read_fixed(TypeCode typeCode) {
        try {
            return this.read_fixed(typeCode.fixed_digits(), typeCode.fixed_scale());
        }
        catch (BadKind badKind) {
            this.cancel(ExceptionTool.initCause(new BAD_PARAM("Typecode is not fixed type", 1146056963, CompletionStatus.COMPLETED_NO), (Throwable)badKind));
            return null;
        }
    }

    public BigDecimal read_fixed(short s, short s2) {
        BigDecimal bigDecimal;
        StringBuffer stringBuffer = new StringBuffer("0");
        short s3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        while (true) {
            byte by = this.read_octet();
            int n = by >> 4 & 0xF;
            int n2 = by & 0xF;
            if (n > 9) {
                this.cancel(new MARSHAL("Error in fixed format", 1146056980, CompletionStatus.COMPLETED_MAYBE));
            }
            if (bl || n > 0) {
                stringBuffer.append((char)(48 + n));
                ++s3;
            }
            if (n2 < 10) {
                stringBuffer.append((char)(48 + n2));
                ++s3;
            } else {
                if (n2 == 13) {
                    bl2 = true;
                    break;
                }
                if (n2 == 12) break;
                this.cancel(new MARSHAL("Error in fixed format", 1146056980, CompletionStatus.COMPLETED_MAYBE));
            }
            bl = true;
        }
        if (s >= 0 && s3 > s) {
            this.cancel(new MARSHAL("Fixed data does not match type", 1146056980, CompletionStatus.COMPLETED_MAYBE));
        }
        try {
            bigDecimal = new BigDecimal(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.cancel(ExceptionTool.initCause(new MARSHAL("Error in fixed format", 1146056980, CompletionStatus.COMPLETED_MAYBE), (Throwable)numberFormatException));
            return null;
        }
        if (bl2) {
            bigDecimal = bigDecimal.negate();
        }
        if (s2 > 0) {
            bigDecimal = bigDecimal.movePointLeft(s2);
        }
        return bigDecimal;
    }

    public Serializable read_value() {
        return this.read_value(this.read_long(), null, null, null, null);
    }

    public Serializable read_value(String string) {
        return this.read_value(this.read_long(), string, null, null, null);
    }

    public Serializable read_value(Class clazz) {
        return this.read_value(this.read_long(), null, clazz, null, null);
    }

    public Serializable read_value(BoxedValueHelper boxedValueHelper) {
        return this.read_value(this.read_long(), null, null, boxedValueHelper, null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private Serializable read_value(int var1_1, String var2_2, Class var3_3, BoxedValueHelper var4_4, Serializable var5_5) {
        if (var1_1 == 0) {
            return null;
        }
        if (this.m_value_cache == null) {
            this.m_value_cache = new HashMap<K, V>();
        }
        if (var1_1 == -1) {
            var6_6 = this.m_index + this.read_long();
            var7_7 /* !! */  = this.m_value_cache.get(NumberCache.getInteger(var6_6));
            if (var7_7 /* !! */  instanceof MARSHAL) {
                this.cancel((MARSHAL)var7_7 /* !! */ );
            }
            if (var7_7 /* !! */  instanceof Serializable) {
                return (Serializable)var7_7 /* !! */ ;
            }
            this.cancel(new IndirectionException(var6_6));
        }
        if (var1_1 < 0x7FFFFF00 || var1_1 > 0x7FFFFFFF) {
            this.cancel(new MARSHAL("Invalid value tag: 0x" + HexPrintStream.toHex(var1_1), 1146056981, CompletionStatus.COMPLETED_MAYBE));
        }
        var6_6 = this.m_index - 4;
        var7_7 /* !! */  = null;
        if ((var1_1 & 1) == 1) {
            if (this.peek_long() == -1) {
                this.read_long();
                var8_8 = this.m_index + this.read_long();
                var9_10 = this.m_value_cache.get(NumberCache.getInteger(var8_8));
                if (var9_10 == null || !(var9_10 instanceof String)) {
                    this.cancel(new IndirectionException(var8_8));
                }
                var7_7 /* !! */  = (String)var9_10;
            } else {
                var8_8 = this.m_index;
                var7_7 /* !! */  = this.read_string();
                this.m_value_cache.put(NumberCache.getInteger(var8_8), var7_7 /* !! */ );
            }
        }
        var8_9 = this.read_typeids(var1_1);
        var9_11 = this.m_in_chunked_value;
        var10_12 = this.m_value_level;
        if ((var1_1 & 8) == 8) {
            var11_13 = this.peek_long();
            if (var11_13 < 0x7FFFFF00 || var11_13 > 0x7FFFFFFF) {
                this.begin_value_chunk(this.read_ulong());
            }
            this.m_in_chunked_value = true;
        }
        ++this.m_value_level;
        this.m_value_indirect = var6_6;
        try {
            block59: {
                block58: {
                    block57: {
                        if (var4_4 == null) break block57;
                        var11_14 = var4_4.read_value(this);
                        this.m_value_cache.put(NumberCache.getInteger(this.m_value_indirect), var11_14);
                        this.m_value_indirect = -1;
                        var12_17 = var11_14;
                        var14_21 = null;
                        if ((var1_1 & 8) != 8) {
                            this.m_value_level = var10_12;
                            return var12_17;
                        }
                        ** GOTO lbl125
                    }
                    if (var5_5 == null) break block58;
                    var11_15 = this.read_value(var5_5);
                    var14_22 = null;
                    if ((var1_1 & 8) != 8) {
                        this.m_value_level = var10_12;
                        return var11_15;
                    }
                    ** GOTO lbl158
                }
                var11_16 = null;
                if (var8_9 == null) break block59;
                var12_18 = 0;
                if (true) ** GOTO lbl165
            }
            if (var2_2 != null) {
                var11_16 = this.read_value_withtype(var2_2, (String)var7_7 /* !! */ , var3_3);
            }
lbl71:
            // 5 sources

            while (true) {
                if (var11_16 == null) {
                    var12_19 = new MARSHAL("Unable to locate value factory", 1330446337, CompletionStatus.COMPLETED_YES);
                    this.m_value_cache.put(NumberCache.getInteger(this.m_value_indirect), var12_19);
                    this.m_value_indirect = -1;
                    if (this.m_continue_level > 0) {
                        throw var12_19;
                    }
                    this.cancel(var12_19);
                }
                if (var3_3 != null && !var3_3.isInstance(var11_16)) {
                    this.cancel(new BAD_PARAM("Returned type does not match expected type", 1146056964, CompletionStatus.COMPLETED_YES));
                }
                var12_20 = var11_16;
                var14_23 = null;
                if ((var1_1 & 8) != 8) {
                    this.m_value_level = var10_12;
                    return var12_20;
                }
                ** GOTO lbl197
                break;
            }
        }
        catch (Throwable var13_45) {
            var14_24 = null;
            if ((var1_1 & 8) == 8) ** GOTO lbl230
        }
        this.m_value_level = var10_12;
        throw var13_45;
lbl-1000:
        // 1 sources

        {
            if (this.m_encaps_remain > 0) {
                this.force_skip(this.m_encaps_remain);
            }
            this.m_pending_value_reopen = false;
            var15_25 = this.read_long();
            if (var15_25 >= 0x7FFFFF00 && var15_25 <= 0x7FFFFFFF) {
                var16_29 = this.m_index - 4;
                try {
                    try {
                        ++this.m_continue_level;
                        this.read_value(var15_25, null, null, null, null);
                    }
                    catch (MARSHAL var17_33) {
                        if (var17_33.minor != 1330446337) {
                            throw ExceptionTool.initCause(new MARSHAL(var17_33.getMessage(), var17_33.minor, var17_33.completed), (Throwable)var17_33);
                        }
                        var19_37 = null;
                        --this.m_continue_level;
                    }
                    var19_37 = null;
                    --this.m_continue_level;
                }
                catch (Throwable var18_41) {
                    var19_37 = null;
                    --this.m_continue_level;
                    throw var18_41;
                }
            } else {
                if (var15_25 > 0) {
                    this.begin_value_chunk(var15_25);
                    continue;
                }
                this.m_value_level = -var15_25 - 1;
            }
lbl125:
            // 5 sources

            ** while (this.m_value_level > var10_12)
        }
lbl126:
        // 1 sources

        this.m_pending_value_reopen = this.m_in_chunked_value = var9_11;
        return var12_17;
lbl-1000:
        // 1 sources

        {
            if (this.m_encaps_remain > 0) {
                this.force_skip(this.m_encaps_remain);
            }
            this.m_pending_value_reopen = false;
            var15_26 = this.read_long();
            if (var15_26 >= 0x7FFFFF00 && var15_26 <= 0x7FFFFFFF) {
                var16_30 = this.m_index - 4;
                try {}
                catch (Throwable var18_42) {
                    var19_38 = null;
                    --this.m_continue_level;
                    throw var18_42;
                }
                try {}
                catch (MARSHAL var17_34) {
                    if (var17_34.minor != 1330446337) {
                        throw ExceptionTool.initCause(new MARSHAL(var17_34.getMessage(), var17_34.minor, var17_34.completed), (Throwable)var17_34);
                    }
                    var19_38 = null;
                    --this.m_continue_level;
                    continue;
                }
                ++this.m_continue_level;
                this.read_value(var15_26, null, null, null, null);
                var19_38 = null;
                --this.m_continue_level;
                continue;
            }
            if (var15_26 > 0) {
                this.begin_value_chunk(var15_26);
                continue;
            }
            this.m_value_level = -var15_26 - 1;
lbl158:
            // 5 sources

            ** while (this.m_value_level > var10_12)
        }
lbl159:
        // 1 sources

        this.m_pending_value_reopen = this.m_in_chunked_value = var9_11;
        return var11_15;
        {
        }
        do {
            if ((var11_16 = this.read_value_withtype(var8_9[var12_18], (String)var7_7 /* !! */ , var3_3)) != null || var2_2 != null && var8_9[var12_18].equals(var2_2)) ** GOTO lbl71
            ++var12_18;
lbl165:
            // 2 sources

        } while (var12_18 < var8_9.length);
        ** while (true)
lbl-1000:
        // 1 sources

        {
            if (this.m_encaps_remain > 0) {
                this.force_skip(this.m_encaps_remain);
            }
            this.m_pending_value_reopen = false;
            var15_27 = this.read_long();
            if (var15_27 >= 0x7FFFFF00 && var15_27 <= 0x7FFFFFFF) {
                var16_31 = this.m_index - 4;
                try {}
                catch (Throwable var18_43) {
                    var19_39 = null;
                    --this.m_continue_level;
                    throw var18_43;
                }
                try {}
                catch (MARSHAL var17_35) {
                    if (var17_35.minor != 1330446337) {
                        throw ExceptionTool.initCause(new MARSHAL(var17_35.getMessage(), var17_35.minor, var17_35.completed), (Throwable)var17_35);
                    }
                    var19_39 = null;
                    --this.m_continue_level;
                    continue;
                }
                ++this.m_continue_level;
                this.read_value(var15_27, null, null, null, null);
                var19_39 = null;
                --this.m_continue_level;
                continue;
            }
            if (var15_27 > 0) {
                this.begin_value_chunk(var15_27);
                continue;
            }
            this.m_value_level = -var15_27 - 1;
lbl197:
            // 5 sources

            ** while (this.m_value_level > var10_12)
        }
lbl198:
        // 1 sources

        this.m_pending_value_reopen = this.m_in_chunked_value = var9_11;
        return var12_20;
lbl-1000:
        // 1 sources

        {
            if (this.m_encaps_remain > 0) {
                this.force_skip(this.m_encaps_remain);
            }
            this.m_pending_value_reopen = false;
            var15_28 = this.read_long();
            if (var15_28 >= 0x7FFFFF00 && var15_28 <= 0x7FFFFFFF) {
                var16_32 = this.m_index - 4;
                try {}
                catch (Throwable var18_44) {
                    var19_40 = null;
                    --this.m_continue_level;
                    throw var18_44;
                }
                try {}
                catch (MARSHAL var17_36) {
                    if (var17_36.minor != 1330446337) {
                        throw ExceptionTool.initCause(new MARSHAL(var17_36.getMessage(), var17_36.minor, var17_36.completed), (Throwable)var17_36);
                    }
                    var19_40 = null;
                    --this.m_continue_level;
                    continue;
                }
                ++this.m_continue_level;
                this.read_value(var15_28, null, null, null, null);
                var19_40 = null;
                --this.m_continue_level;
                continue;
            }
            if (var15_28 > 0) {
                this.begin_value_chunk(var15_28);
                continue;
            }
            this.m_value_level = -var15_28 - 1;
lbl230:
            // 5 sources

            ** while (this.m_value_level > var10_12)
        }
lbl231:
        // 1 sources

        this.m_pending_value_reopen = this.m_in_chunked_value = var9_11;
        throw var13_45;
    }

    private void begin_value_chunk(int n) {
        this.m_encaps_stack.addLast(NumberCache.getInteger(this.m_encaps_remain));
        this.m_encaps_stack.addLast(NumberCache.getInteger(this.m_index));
        this.m_encaps_stack.addLast(Boolean.TRUE);
        this.m_encaps_remain = n;
    }

    public String[] read_typeids(int n) {
        String[] stringArray;
        block5: {
            int n2;
            block8: {
                block6: {
                    block7: {
                        stringArray = null;
                        if ((n & 6) == 0) break block5;
                        if ((n & 6) != 6) break block6;
                        n2 = this.read_long();
                        if (n2 != -1) break block7;
                        int n3 = this.m_index + this.read_long();
                        java.lang.Object v = this.m_value_cache.get(NumberCache.getInteger(n3));
                        if (v == null || !(v instanceof String[])) {
                            this.cancel(new IndirectionException(n3));
                        }
                        stringArray = (String[])v;
                        this.m_value_cache.put(NumberCache.getInteger(this.m_index - 4), stringArray);
                        break block5;
                    }
                    stringArray = new String[n2];
                    this.m_value_cache.put(NumberCache.getInteger(this.m_index - 4), stringArray);
                    break block8;
                }
                stringArray = new String[1];
            }
            n2 = 0;
            while (n2 < stringArray.length) {
                int n4;
                if (this.peek_long() == -1) {
                    this.read_long();
                    n4 = this.m_index + this.read_long();
                    java.lang.Object v = this.m_value_cache.get(NumberCache.getInteger(n4));
                    if (v == null || !(v instanceof String)) {
                        this.cancel(new IndirectionException(n4));
                    }
                    stringArray[n2] = (String)v;
                    this.m_value_cache.put(NumberCache.getInteger(this.m_index - 4), stringArray[n2]);
                } else {
                    this.alignment(4);
                    n4 = this.m_index;
                    stringArray[n2] = this.read_string();
                    this.m_value_cache.put(NumberCache.getInteger(n4), stringArray[n2]);
                }
                ++n2;
            }
        }
        return stringArray;
    }

    private Serializable read_value_withtype(String string, String string2, Class clazz) {
        ValueFactory valueFactory = ((ORB)this.m_orb).lookup_value_factory(string);
        if (valueFactory != null) {
            return valueFactory.read_value(this);
        }
        int n = this.m_value_indirect;
        Serializable serializable = this.value_extended_unmarshal(this.m_value_indirect, clazz, string, string2, null);
        if (serializable != null) {
            this.m_value_cache.put(NumberCache.getInteger(n), serializable);
            return serializable;
        }
        BoxedValueHelper boxedValueHelper = null;
        try {
            String string3 = RepoIDHelper.idToClass(string, 2);
            boxedValueHelper = (BoxedValueHelper)Thread.currentThread().getContextClassLoader().loadClass(string3).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (boxedValueHelper != null) {
            serializable = boxedValueHelper.read_value(this);
            this.m_value_cache.put(NumberCache.getInteger(this.m_value_indirect), serializable);
            this.m_value_indirect = -1;
            return serializable;
        }
        if (string2 != null && (valueFactory = this.loadFactoryWithID(string, string2)) != null) {
            return valueFactory.read_value(this);
        }
        return null;
    }

    public Serializable read_value(Serializable serializable) {
        if (this.m_value_indirect < 0) {
            return this.read_value(this.read_long(), null, null, null, serializable);
        }
        this.m_value_cache.put(NumberCache.getInteger(this.m_value_indirect), serializable);
        if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).unmarshal(new DataInputStream(this));
        } else if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._read(this);
        } else {
            this.cancel(new BAD_PARAM("Unable to read value into class", 1146056964, CompletionStatus.COMPLETED_YES));
        }
        return serializable;
    }

    protected Serializable value_extended_unmarshal(int n, Class clazz, String string, String string2, RunTime runTime) {
        return null;
    }

    public java.lang.Object read_abstract_interface() {
        if (this.read_boolean()) {
            return this.read_Object();
        }
        return this.read_value();
    }

    public java.lang.Object read_abstract_interface(Class clazz) {
        if (this.read_boolean()) {
            return this.read_Object(clazz);
        }
        return this.read_value();
    }

    private void postread(int n) {
        this.m_index += n;
        if (this.m_encaps_remain > 0) {
            this.m_encaps_remain -= n;
            while (this.m_encaps_remain == 0) {
                boolean bl = (Boolean)this.m_encaps_stack.removeLast();
                int n2 = this.m_index - (Integer)this.m_encaps_stack.removeLast();
                this.m_encaps_remain = (Integer)this.m_encaps_stack.removeLast() - n2;
                if (bl) {
                    this.m_pending_value_reopen = true;
                } else {
                    this.m_swap = (Boolean)this.m_encaps_stack.removeLast();
                    if (!this.m_encaps_stack.isEmpty()) {
                        this.m_in_chunked_value = (Boolean)this.m_encaps_stack.getLast();
                    }
                    ++this.m_pending_encaps_close;
                }
                if (this.m_encaps_remain >= 0) continue;
                this.m_encaps_remain = -1;
            }
        }
    }

    protected ValueFactory loadFactoryWithID(String string, String string2) {
        String string3 = RepoIDHelper.idToClass(string, 4);
        try {
            Class<java.lang.Object> clazz = this.loadClassFromURL(string3, string2);
            clazz = string2 != null ? this.loadClassFromURL(string3, string2) : Thread.currentThread().getContextClassLoader().loadClass(string3);
            if (clazz != null) {
                return (ValueFactory)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            this.getLogger().error("Unexpected exception", exception);
        }
        return null;
    }

    private Class loadClassFromURL(String string, String string2) {
        try {
            java.lang.Object object;
            if (string2 == null) {
                return Thread.currentThread().getContextClassLoader().loadClass(string);
            }
            ClassLoader classLoader = (ClassLoader)this.m_value_cache.get(string2);
            if (classLoader == null) {
                object = new StringTokenizer(string2, " ");
                URL[] uRLArray = new URL[((StringTokenizer)object).countTokens()];
                int n = 0;
                int n2 = 0;
                while (n2 < uRLArray.length) {
                    try {
                        uRLArray[n] = new URL(((StringTokenizer)object).nextToken());
                        ++n;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    ++n2;
                }
                if (n != uRLArray.length) {
                    URL[] uRLArray2 = uRLArray;
                    uRLArray = new URL[n];
                    System.arraycopy(uRLArray2, 0, uRLArray, 0, n);
                }
                classLoader = new URLClassLoader(uRLArray);
                this.m_value_cache.put(string2, classLoader);
            }
            object = classLoader.loadClass(string);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.getLogger().error("Unable to find class from an URL : " + string, new Error());
            return null;
        }
    }

    protected Map getValueCache() {
        return this.m_value_cache;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MarkState {
        private int m_index;
        private boolean m_swap;
        private int m_encaps_remain = -1;
        private int m_pending_encaps_close;
        private LinkedList m_encaps_stack;
        private int m_value_level;
        private boolean m_pending_value_reopen;
        private boolean m_in_chunked_value;
        private int m_value_indirect;

        MarkState() {
            this.m_index = CDRInputStream.this.m_index;
            this.m_swap = CDRInputStream.this.m_swap;
            this.m_encaps_remain = CDRInputStream.this.m_encaps_remain;
            this.m_pending_encaps_close = CDRInputStream.this.m_pending_encaps_close;
            this.m_encaps_stack = new LinkedList(CDRInputStream.this.m_encaps_stack);
            this.m_value_level = CDRInputStream.this.m_value_level;
            this.m_pending_value_reopen = CDRInputStream.this.m_pending_value_reopen;
            this.m_in_chunked_value = CDRInputStream.this.m_in_chunked_value;
            this.m_value_indirect = CDRInputStream.this.m_value_indirect;
        }

        void reset() {
            CDRInputStream.this.m_index = this.m_index;
            CDRInputStream.this.m_swap = this.m_swap;
            CDRInputStream.this.m_encaps_remain = this.m_encaps_remain;
            CDRInputStream.this.m_pending_encaps_close = this.m_pending_encaps_close;
            CDRInputStream.this.m_encaps_stack = this.m_encaps_stack;
            CDRInputStream.this.m_value_level = this.m_value_level;
            CDRInputStream.this.m_pending_value_reopen = this.m_pending_value_reopen;
            CDRInputStream.this.m_in_chunked_value = this.m_in_chunked_value;
            CDRInputStream.this.m_value_indirect = this.m_value_indirect;
        }
    }
}

