/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.PI;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.Object;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.CORBA.LoggableLocalObject;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.PI.ClientManager;
import org.openorb.PI.CodecFactoryManager;
import org.openorb.PI.CodecFactoryManagerImpl;
import org.openorb.PI.CurrentImpl;
import org.openorb.PI.FeatureInitInfo;
import org.openorb.PI.FeatureInitializer;
import org.openorb.PI.IORManager;
import org.openorb.PI.ORBInitInfo;
import org.openorb.PI.ServerManager;
import org.openorb.policy.PolicyFactoryManager;
import org.openorb.util.ExceptionTool;

public class OpenORBInitInfo
extends LoggableLocalObject
implements org.omg.PortableInterceptor.ORBInitInfo,
FeatureInitInfo,
ORBInitInfo,
Disposable {
    private ORB m_orb;
    private Logger m_logger;
    private String[] m_args;
    private ORBInitializer[] m_orb_inits;
    private FeatureInitializer[] m_feature_inits;
    private ORBLoader m_loader;
    private int m_slots = 0;
    private ArrayList m_client_interceptors = new ArrayList();
    private ArrayList m_server_interceptors = new ArrayList();
    private ArrayList m_ior_interceptors = new ArrayList();
    private CodecFactoryManager m_codec_manager;
    private int m_phase = 0;
    private static final int PHASE_CREATED = 0;
    private static final int PHASE_PRE_INIT = 1;
    private static final int PHASE_POST_INIT = 3;
    private static final int PHASE_COMPLETE = 4;

    public OpenORBInitInfo(String[] stringArray, ORB oRB, ORBInitializer[] oRBInitializerArray, FeatureInitializer[] featureInitializerArray) {
        this.m_args = stringArray;
        this.m_orb = oRB;
        this.m_orb_inits = oRBInitializerArray;
        this.m_feature_inits = featureInitializerArray;
        this.m_logger = this.m_orb.getLogger();
        try {
            this.m_loader = (ORBLoader)this.m_orb.getFeature("ORBLoader");
        }
        catch (Exception exception) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Couldn't get ORBLoader feature.", exception);
            }
            throw new CascadingRuntimeException("Could not resolve ORBLoader.", exception);
        }
    }

    public void pre_init() {
        if (this.m_phase != 0) {
            throw new INITIALIZE("Call to pre_init not allowed at this time");
        }
        this.m_phase = 1;
        this.m_codec_manager = new CodecFactoryManagerImpl();
        this.m_orb.addInitialReference("CodecFactory", (Object)((java.lang.Object)this.m_codec_manager));
        this.m_orb.setFeature("CodecFactoryManager", this.m_codec_manager);
        if (this.m_orb_inits != null) {
            int n = 0;
            while (n < this.m_orb_inits.length) {
                this.m_orb_inits[n].pre_init(this);
                ++n;
            }
        }
    }

    public void post_init() {
        if (this.m_phase != 1) {
            throw new INITIALIZE("Call to post_init not allowed at this time");
        }
        this.m_phase = 3;
        if (this.m_feature_inits != null) {
            int n = 0;
            while (n < this.m_feature_inits.length) {
                this.m_feature_inits[n].init(this, this);
                ++n;
            }
        }
        CurrentImpl currentImpl = new CurrentImpl(this.m_orb);
        this.m_orb.addInitialReference("PICurrent", currentImpl);
        this.m_orb.setFeature("PICurrent", currentImpl);
        if (this.m_orb_inits != null) {
            int n = 0;
            while (n < this.m_orb_inits.length) {
                this.m_orb_inits[n].post_init(this);
                ++n;
            }
        }
        currentImpl.set_slots(this.m_slots);
        this.create_client_interceptor_manager(currentImpl);
        this.create_server_interceptor_manager(currentImpl);
        this.create_ior_interceptor_manager();
        this.m_phase = 4;
    }

    private void create_client_interceptor_manager(CurrentImpl currentImpl) {
        if (!this.m_loader.getBooleanProperty("openorb.client.enable", true)) {
            return;
        }
        if (this.m_client_interceptors.isEmpty()) {
            return;
        }
        ClientRequestInterceptor[] clientRequestInterceptorArray = new ClientRequestInterceptor[this.m_client_interceptors.size()];
        this.m_client_interceptors.toArray(clientRequestInterceptorArray);
        ClientManager clientManager = null;
        java.lang.Object[] objectArray = new java.lang.Object[]{clientRequestInterceptorArray, currentImpl};
        try {
            clientManager = (ClientManager)this.m_loader.constructClass("openorb.pi.ClientManagerClass", "org.openorb.PI.SimpleClientManager", objectArray);
        }
        catch (Exception exception) {
            this.getLogger().error("Error constructing class openorb.pi.ClientManagerClass.", exception);
            throw ExceptionTool.initCause(new INITIALIZE("Error constructing class openorb.pi.ClientManagerClass (" + exception + ")"), (Throwable)exception);
        }
        if (clientManager != null) {
            this.m_orb.setFeature("ClientInterceptorManager", clientManager);
        }
    }

    private void create_server_interceptor_manager(CurrentImpl currentImpl) {
        if (!this.m_loader.getBooleanProperty("openorb.server.enable", true)) {
            return;
        }
        if (this.m_server_interceptors.isEmpty()) {
            return;
        }
        ServerRequestInterceptor[] serverRequestInterceptorArray = new ServerRequestInterceptor[this.m_server_interceptors.size()];
        this.m_server_interceptors.toArray(serverRequestInterceptorArray);
        ServerManager serverManager = null;
        java.lang.Object[] objectArray = new java.lang.Object[]{serverRequestInterceptorArray, currentImpl};
        try {
            serverManager = (ServerManager)this.m_loader.constructClass("openorb.pi.ServerManagerClass", "org.openorb.PI.SimpleServerManager", objectArray);
        }
        catch (Exception exception) {
            this.getLogger().error("Error constructing class openorb.pi.ServerManagerClass.", exception);
            throw ExceptionTool.initCause(new INITIALIZE("Error constructing class openorb.pi.ServerManagerClass (" + exception + ")"), (Throwable)exception);
        }
        if (serverManager != null) {
            this.m_orb.setFeature("ServerInterceptorManager", serverManager);
        }
    }

    private void create_ior_interceptor_manager() {
        if (!this.m_loader.getBooleanProperty("openorb.server.enable", true)) {
            return;
        }
        IORInterceptor[] iORInterceptorArray = new IORInterceptor[this.m_ior_interceptors.size()];
        this.m_ior_interceptors.toArray(iORInterceptorArray);
        IORManager iORManager = null;
        java.lang.Object[] objectArray = new java.lang.Object[]{iORInterceptorArray};
        try {
            iORManager = (IORManager)this.m_loader.constructClass("org.openorb.PI.IORManagerClass", "org.openorb.PI.SimpleIORManager", objectArray);
        }
        catch (Exception exception) {
            this.getLogger().error("Error constructing class org.openorb.PI.IORManagerClass.", exception);
            throw ExceptionTool.initCause(new INITIALIZE("Error constructing class org.openorb.PI.IORManagerClass (" + exception + ")"), (Throwable)exception);
        }
        if (iORManager != null) {
            this.m_orb.setFeature("IORInterceptorManager", iORManager);
        }
    }

    public ORB orb() {
        return this.m_orb;
    }

    public ORBLoader getLoader() {
        return this.m_orb.getLoader();
    }

    public void setFeature(String string, java.lang.Object object) {
        this.m_orb.setFeature(string, object);
    }

    public java.lang.Object getFeature(String string) {
        return this.m_orb.getFeature(string);
    }

    public String[] arguments() {
        return this.m_args;
    }

    public String orb_id() {
        return "OpenORB";
    }

    public CodecFactory codec_factory() {
        return (CodecFactory)((java.lang.Object)this.m_codec_manager);
    }

    public void register_initial_reference(String string, Object object) throws InvalidName {
        try {
            Object object2 = this.resolve_initial_references(string);
        }
        catch (InvalidName invalidName) {
            this.m_orb.addInitialReference(string, object);
            return;
        }
        throw new InvalidName();
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        try {
            return this.m_orb.resolve_initial_references(string);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName invalidName) {
            throw (InvalidName)ExceptionTool.initCause(new InvalidName(), (Throwable)invalidName);
        }
    }

    public void add_client_request_interceptor(ClientRequestInterceptor clientRequestInterceptor) throws DuplicateName {
        this.check_duplicate(this.m_client_interceptors, clientRequestInterceptor.name());
        this.m_client_interceptors.add(clientRequestInterceptor);
    }

    public void add_server_request_interceptor(ServerRequestInterceptor serverRequestInterceptor) throws DuplicateName {
        this.check_duplicate(this.m_server_interceptors, serverRequestInterceptor.name());
        this.m_server_interceptors.add(serverRequestInterceptor);
    }

    public void add_ior_interceptor(IORInterceptor iORInterceptor) throws DuplicateName {
        this.check_duplicate(this.m_ior_interceptors, iORInterceptor.name());
        this.m_ior_interceptors.add(iORInterceptor);
    }

    public int allocate_slot_id() {
        return this.m_slots++;
    }

    public void register_policy_factory(int n, PolicyFactory policyFactory) {
        PolicyFactoryManager policyFactoryManager = (PolicyFactoryManager)this.m_orb.getFeature("PolicyFactoryManager");
        policyFactoryManager.add_policy_factory(n, policyFactory);
    }

    private void check_duplicate(ArrayList arrayList, String string) throws DuplicateName {
        if (string.length() == 0) {
            return;
        }
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            if (!string.equals(((Interceptor)iterator.next()).name())) continue;
            throw new DuplicateName();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        HashSet<java.lang.Object> hashSet = new HashSet<java.lang.Object>();
        int n = 0;
        while (n < this.m_orb_inits.length) {
            block12: {
                ORBInitializer oRBInitializer = this.m_orb_inits[n];
                if (!hashSet.contains(oRBInitializer) && oRBInitializer instanceof Disposable) {
                    java.lang.Object var7_7;
                    try {
                        try {
                            ((Disposable)((java.lang.Object)oRBInitializer)).dispose();
                        }
                        catch (Throwable throwable) {
                            this.getLogger().warn("Ignoring error during initializer disposal.", throwable);
                            var7_7 = null;
                            hashSet.add(oRBInitializer);
                            break block12;
                        }
                        var7_7 = null;
                        hashSet.add(oRBInitializer);
                    }
                    catch (Throwable throwable) {
                        var7_7 = null;
                        hashSet.add(oRBInitializer);
                        throw throwable;
                    }
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.m_feature_inits.length) {
            block13: {
                FeatureInitializer featureInitializer = this.m_feature_inits[n2];
                if (!hashSet.contains(featureInitializer) && featureInitializer instanceof Disposable) {
                    java.lang.Object var9_10;
                    try {
                        try {
                            ((Disposable)((java.lang.Object)featureInitializer)).dispose();
                        }
                        catch (Throwable throwable) {
                            this.getLogger().warn("Ignoring error during feature disposal.", throwable);
                            var9_10 = null;
                            hashSet.add(featureInitializer);
                            break block13;
                        }
                        var9_10 = null;
                        hashSet.add(featureInitializer);
                    }
                    catch (Throwable throwable) {
                        var9_10 = null;
                        hashSet.add(featureInitializer);
                        throw throwable;
                    }
                }
            }
            ++n2;
        }
    }
}

