/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.typecode;

import java.util.HashMap;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodeFactory;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.openorb.CORBA.typecode.TypeCodeAlias;
import org.openorb.CORBA.typecode.TypeCodeArray;
import org.openorb.CORBA.typecode.TypeCodeBase;
import org.openorb.CORBA.typecode.TypeCodeEnum;
import org.openorb.CORBA.typecode.TypeCodeFixed;
import org.openorb.CORBA.typecode.TypeCodeObject;
import org.openorb.CORBA.typecode.TypeCodePrimitive;
import org.openorb.CORBA.typecode.TypeCodeRecursive;
import org.openorb.CORBA.typecode.TypeCodeString;
import org.openorb.CORBA.typecode.TypeCodeStruct;
import org.openorb.CORBA.typecode.TypeCodeUnion;
import org.openorb.CORBA.typecode.TypeCodeValue;
import org.openorb.util.ExceptionTool;
import org.openorb.util.RepoIDHelper;

public class TypeCodeFactoryImpl
extends LocalObject
implements TypeCodeFactory {
    private static TypeCodeFactoryImpl s_instance = null;

    private TypeCodeFactoryImpl() {
    }

    public static TypeCodeFactoryImpl getInstance() {
        if (s_instance == null) {
            s_instance = new TypeCodeFactoryImpl();
        }
        return s_instance;
    }

    private TypeCode fix_recursive(TypeCodeBase typeCodeBase) {
        typeCodeBase._fix_recursive(new HashMap());
        return typeCodeBase;
    }

    public TypeCode create_struct_tc(String string, String string2, StructMember[] structMemberArray) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.fix_recursive(new TypeCodeStruct(TCKind.tk_struct, string, string2, structMemberArray));
    }

    public TypeCode create_union_tc(String string, String string2, TypeCode typeCode, UnionMember[] unionMemberArray) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCode typeCode2 = typeCode;
        try {
            while (typeCode2.kind() == TCKind.tk_alias) {
                typeCode2 = typeCode2.content_type();
            }
        }
        catch (BadKind badKind) {
            throw ExceptionTool.initCause(new BAD_PARAM("Unexpected BadKind exception", 1330446356, CompletionStatus.COMPLETED_MAYBE), (Throwable)badKind);
        }
        switch (typeCode2.kind().value()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 17: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            default: {
                throw new BAD_PARAM(1330446356, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        boolean bl = false;
        int n = 0;
        while (n < unionMemberArray.length) {
            if (!unionMemberArray[n].label.type().equivalent(typeCode)) {
                if (!bl && unionMemberArray[n].label.type().equal(TypeCodePrimitive.TC_OCTET) && unionMemberArray[n].label.extract_octet() == 0) {
                    bl = true;
                } else {
                    throw new BAD_PARAM(1330446355, CompletionStatus.COMPLETED_MAYBE);
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < unionMemberArray.length) {
            int n3 = n2 + 1;
            while (n3 < unionMemberArray.length) {
                if (unionMemberArray[n2].label.equal(unionMemberArray[n3].label)) {
                    throw new BAD_PARAM(1330446354, CompletionStatus.COMPLETED_MAYBE);
                }
                ++n3;
            }
            ++n2;
        }
        return this.fix_recursive(new TypeCodeUnion(string, string2, typeCode, unionMemberArray));
    }

    public TypeCode create_enum_tc(String string, String string2, String[] stringArray) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return new TypeCodeEnum(string, string2, stringArray);
    }

    public TypeCode create_alias_tc(String string, String string2, TypeCode typeCode) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.fix_recursive(new TypeCodeAlias(TCKind.tk_alias, string, string2, typeCode));
    }

    public TypeCode create_exception_tc(String string, String string2, StructMember[] structMemberArray) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.fix_recursive(new TypeCodeStruct(TCKind.tk_except, string, string2, structMemberArray));
    }

    public TypeCode create_interface_tc(String string, String string2) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return new TypeCodeObject(TCKind.tk_objref, string, string2);
    }

    public TypeCode create_native_tc(String string, String string2) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return new TypeCodeObject(TCKind.tk_native, string, string2);
    }

    public TypeCode create_string_tc(int n) {
        if (n == 0) {
            return TypeCodeString.TC_STRING_0;
        }
        return new TypeCodeString(TCKind.tk_string, n);
    }

    public TypeCode create_wstring_tc(int n) {
        if (n == 0) {
            return TypeCodeString.TC_WSTRING_0;
        }
        return new TypeCodeString(TCKind.tk_wstring, n);
    }

    public TypeCode create_sequence_tc(int n, TypeCode typeCode) {
        return this.fix_recursive(new TypeCodeArray(TCKind.tk_sequence, n, typeCode));
    }

    public TypeCode create_recursive_sequence_tc(int n, int n2) {
        throw new NO_IMPLEMENT();
    }

    public TypeCode create_recursive_tc(String string) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        return new TypeCodeRecursive(string);
    }

    public TypeCode create_array_tc(int n, TypeCode typeCode) {
        return this.fix_recursive(new TypeCodeArray(TCKind.tk_array, n, typeCode));
    }

    public TypeCode create_fixed_tc(short s, short s2) {
        return new TypeCodeFixed(s, s2);
    }

    public TypeCode create_value_tc(String string, String string2, short s, TypeCode typeCode, ValueMember[] valueMemberArray) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        if (typeCode == null) {
            typeCode = TypeCodePrimitive.TC_NULL;
        }
        return this.fix_recursive(new TypeCodeValue(string, string2, s, typeCode, valueMemberArray));
    }

    public TypeCode create_value_box_tc(String string, String string2, TypeCode typeCode) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.fix_recursive(new TypeCodeAlias(TCKind.tk_value_box, string, string2, typeCode));
    }

    public TypeCode create_abstract_interface_tc(String string, String string2) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return new TypeCodeObject(TCKind.tk_abstract_interface, string, string2);
    }

    public TypeCode create_local_interface_tc(String string, String string2) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        return new TypeCodeObject(TCKind.tk_objref, string, string2);
    }

    public TypeCode create_home_tc(String string, String string2) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        throw new NO_IMPLEMENT();
    }

    public TypeCode create_component_tc(String string, String string2) {
        if (!RepoIDHelper.checkID(string)) {
            throw new BAD_PARAM(1330446352, CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.startsWith("IDL:") && string2.length() != 0 && !RepoIDHelper.checkIdentifier(string2)) {
            throw new BAD_PARAM(1330446351, CompletionStatus.COMPLETED_MAYBE);
        }
        throw new NO_IMPLEMENT();
    }

    public TypeCode get_primitive_tc(TCKind tCKind) {
        switch (tCKind.value()) {
            case 0: {
                return TypeCodePrimitive.TC_NULL;
            }
            case 1: {
                return TypeCodePrimitive.TC_VOID;
            }
            case 2: {
                return TypeCodePrimitive.TC_SHORT;
            }
            case 3: {
                return TypeCodePrimitive.TC_LONG;
            }
            case 4: {
                return TypeCodePrimitive.TC_USHORT;
            }
            case 5: {
                return TypeCodePrimitive.TC_ULONG;
            }
            case 6: {
                return TypeCodePrimitive.TC_FLOAT;
            }
            case 7: {
                return TypeCodePrimitive.TC_DOUBLE;
            }
            case 8: {
                return TypeCodePrimitive.TC_BOOLEAN;
            }
            case 9: {
                return TypeCodePrimitive.TC_CHAR;
            }
            case 10: {
                return TypeCodePrimitive.TC_OCTET;
            }
            case 11: {
                return TypeCodePrimitive.TC_ANY;
            }
            case 12: {
                return TypeCodePrimitive.TC_TYPECODE;
            }
            case 13: {
                return TypeCodePrimitive.TC_PRINCIPAL;
            }
            case 23: {
                return TypeCodePrimitive.TC_LONGLONG;
            }
            case 24: {
                return TypeCodePrimitive.TC_ULONGLONG;
            }
            case 25: {
                return TypeCodePrimitive.TC_LONGDOUBLE;
            }
            case 26: {
                return TypeCodePrimitive.TC_WCHAR;
            }
            case 18: {
                return TypeCodeString.TC_STRING_0;
            }
            case 27: {
                return TypeCodeString.TC_WSTRING_0;
            }
            case 14: {
                return TypeCodeObject.TC_OBJECT;
            }
            case 32: {
                return TypeCodeObject.TC_ABSTRACT_INTERFACE;
            }
            case 29: {
                return TypeCodeValue.TC_VALUEBASE;
            }
        }
        throw new BAD_PARAM("Illegal kind for primative typecode", 1146056717, CompletionStatus.COMPLETED_MAYBE);
    }
}

