/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UNKNOWNHelper;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.UnknownException;
import org.openorb.CORBA.Any;
import org.openorb.util.Trace;

public abstract class SystemExceptionHelper {
    private static final String[] SYSTEM_EXCEPTIONS = new String[]{"UNKNOWN", "BAD_PARAM", "NO_MEMORY", "IMP_LIMIT", "COMM_FAILURE", "INV_OBJREF", "NO_PERMISSION", "INTERNAL", "MARSHAL", "INITIALIZE", "NO_IMPLEMENT", "BAD_TYPECODE", "BAD_OPERATION", "NO_RESOURCES", "NO_RESPONSE", "PERSIST_STORE", "BAD_INV_ORDER", "TRANSIENT", "FREE_MEM", "INV_IDENT", "INV_FLAG", "INTF_REPOS", "BAD_CONTEXT", "OBJ_ADAPTER", "DATA_CONVERSION", "OBJECT_NOT_EXIST", "TRANSACTION_REQUIRED", "TRANSACTION_ROLLEDBACK", "INVALID_TRANSACTION", "INV_POLICY", "CODESET_INCOMPATIBLE", "REBIND", "TIMEOUT", "TRANSACTION_UNAVAILABLE", "TRANSACTION_MODE", "BAD_QOS"};
    private static final Map FINDER = new HashMap(SYSTEM_EXCEPTIONS.length * 2);
    private static final MapEntry UNKNOWN;
    static /* synthetic */ Class class$org$omg$CORBA$UNKNOWN;
    static /* synthetic */ Class class$org$omg$CORBA$UNKNOWNHelper;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$omg$CORBA$Any;

    public static TypeCode type(String string) {
        MapEntry mapEntry = (MapEntry)FINDER.get(string);
        if (mapEntry == null) {
            mapEntry = UNKNOWN;
        }
        return mapEntry.fType;
    }

    public static TypeCode type(SystemException systemException) {
        MapEntry mapEntry = (MapEntry)FINDER.get(systemException.getClass());
        if (mapEntry == null) {
            mapEntry = UNKNOWN;
        }
        return mapEntry.fType;
    }

    public static String id(SystemException systemException) {
        MapEntry mapEntry = (MapEntry)FINDER.get(systemException.getClass());
        if (mapEntry == null) {
            mapEntry = UNKNOWN;
        }
        return mapEntry.fId;
    }

    public static void insert(org.omg.CORBA.Any any, SystemException systemException) {
        block9: {
            MapEntry mapEntry = (MapEntry)FINDER.get(systemException.getClass());
            Logger logger = ((Any)any).getLogger();
            if (mapEntry == null) {
                if (systemException instanceof UnknownException && any instanceof Any) {
                    ((Any)any).setUnknownException(systemException);
                }
                systemException = new UNKNOWN(systemException.minor, systemException.completed);
                mapEntry = UNKNOWN;
            }
            Class[] classArray = new Class[2];
            Object[] objectArray = new Object[2];
            classArray[0] = class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = SystemExceptionHelper.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any;
            objectArray[0] = any;
            classArray[1] = systemException.getClass();
            objectArray[1] = systemException;
            try {
                mapEntry.fHClz.getMethod("insert", classArray).invoke(null, objectArray);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable;
                if (logger.isErrorEnabled()) {
                    logger.error("Invalid insert operation", invocationTargetException);
                }
                if ((throwable = invocationTargetException.getTargetException()) instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                if (!logger.isErrorEnabled()) break block9;
                logger.error("Unexpected exception", exception);
            }
        }
    }

    public static SystemException extract(org.omg.CORBA.Any any) {
        block12: {
            Logger logger;
            MapEntry mapEntry;
            block11: {
                mapEntry = null;
                logger = ((Any)any).getLogger();
                try {
                    mapEntry = (MapEntry)FINDER.get(any.type().id());
                }
                catch (BadKind badKind) {
                    if (!logger.isErrorEnabled()) break block11;
                    logger.error("Unknown TCKind", badKind);
                }
            }
            if (mapEntry == null) {
                throw new BAD_OPERATION("Wrong type for extraction", 1146056710, CompletionStatus.COMPLETED_MAYBE);
            }
            Class[] classArray = new Class[1];
            Object[] objectArray = new Object[1];
            classArray[0] = class$org$omg$CORBA$Any == null ? (class$org$omg$CORBA$Any = SystemExceptionHelper.class$("org.omg.CORBA.Any")) : class$org$omg$CORBA$Any;
            objectArray[0] = any;
            try {
                SystemException systemException = (SystemException)mapEntry.fHClz.getMethod("extract", classArray).invoke(null, objectArray);
                if (systemException instanceof UNKNOWN && any instanceof Any) {
                    UnknownException unknownException = new UnknownException(((Any)any).getUnknownException());
                    unknownException.minor = systemException.minor;
                    unknownException.completed = systemException.completed;
                    systemException = unknownException;
                }
                return systemException;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable;
                if (logger.isErrorEnabled()) {
                    logger.error("Invalid extract operation", invocationTargetException);
                }
                if ((throwable = invocationTargetException.getTargetException()) instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                if (!logger.isErrorEnabled()) break block12;
                logger.error("Unexpected exception", exception);
            }
        }
        throw new BAD_OPERATION("Wrong type for extraction", 1146056710, CompletionStatus.COMPLETED_MAYBE);
    }

    public static SystemException read(InputStream inputStream) {
        return SystemExceptionHelper.create(inputStream.read_string(), null, inputStream.read_ulong(), CompletionStatus.from_int(inputStream.read_ulong()));
    }

    public static SystemException read(String string, InputStream inputStream) {
        return SystemExceptionHelper.create(inputStream.read_string(), string, inputStream.read_ulong(), CompletionStatus.from_int(inputStream.read_ulong()));
    }

    public static SystemException create(String string, int n, CompletionStatus completionStatus) {
        return SystemExceptionHelper.create(string, null, n, completionStatus);
    }

    public static SystemException create(String string, String string2, int n, CompletionStatus completionStatus) {
        MapEntry mapEntry = (MapEntry)FINDER.get(string);
        if (mapEntry == null) {
            mapEntry = UNKNOWN;
        }
        string2 = string2 == null ? SystemExceptionHelper.getReasonString(mapEntry, n) : string2 + ": " + SystemExceptionHelper.getReasonString(mapEntry, n);
        try {
            SystemException systemException = (SystemException)mapEntry.fStrCons.newInstance(string2);
            systemException.minor = n;
            systemException.completed = completionStatus;
            return systemException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void write(OutputStream outputStream, SystemException systemException) {
        outputStream.write_string(SystemExceptionHelper.id(systemException));
        outputStream.write_ulong(systemException.minor);
        outputStream.write_ulong(systemException.completed.value());
    }

    private static String getReasonString(MapEntry mapEntry, int n) {
        switch (n & 0xFFFFF000) {
            case 1330446336: {
                return "OMG Standard Exception #" + (n & 0xFFF);
            }
            case 1146056704: {
                return "OpenORB exception #" + (n & 0xFFF);
            }
            case 0: {
                return "Unregistered vendor exception #" + (n & 0xFFF);
            }
        }
        return "Unknown vendor exception #" + (n & 0xFFF);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            UNKNOWN = new MapEntry(UNKNOWNHelper.id(), UNKNOWNHelper.type(), class$org$omg$CORBA$UNKNOWN == null ? (class$org$omg$CORBA$UNKNOWN = SystemExceptionHelper.class$("org.omg.CORBA.UNKNOWN")) : class$org$omg$CORBA$UNKNOWN, class$org$omg$CORBA$UNKNOWNHelper == null ? (class$org$omg$CORBA$UNKNOWNHelper = SystemExceptionHelper.class$("org.omg.CORBA.UNKNOWNHelper")) : class$org$omg$CORBA$UNKNOWNHelper, (class$org$omg$CORBA$UNKNOWN == null ? (class$org$omg$CORBA$UNKNOWN = SystemExceptionHelper.class$("org.omg.CORBA.UNKNOWN")) : class$org$omg$CORBA$UNKNOWN).getConstructor(class$java$lang$String == null ? (class$java$lang$String = SystemExceptionHelper.class$("java.lang.String")) : class$java$lang$String));
            FINDER.put(SystemExceptionHelper.UNKNOWN.fId, UNKNOWN);
            FINDER.put(SystemExceptionHelper.UNKNOWN.fClz, UNKNOWN);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw Trace.signalIllegalCondition(null, "Unable to find String constructor of org.omg.CORBA.UNKNOWN class (" + noSuchMethodException + ")");
        }
        int n = 1;
        while (n < SYSTEM_EXCEPTIONS.length) {
            block8: {
                try {
                    Class<?> clazz;
                    Class<?> clazz2;
                    try {
                        clazz2 = Thread.currentThread().getContextClassLoader().loadClass("org.omg.CORBA." + SYSTEM_EXCEPTIONS[n]);
                        clazz = Thread.currentThread().getContextClassLoader().loadClass("org.omg.CORBA." + SYSTEM_EXCEPTIONS[n] + "Helper");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("Warning: missing system exception class " + SYSTEM_EXCEPTIONS[n]);
                        break block8;
                    }
                    String string = (String)clazz.getMethod("id", new Class[0]).invoke(null, new Object[0]);
                    TypeCode typeCode = (TypeCode)clazz.getMethod("type", new Class[0]).invoke(null, new Object[0]);
                    Constructor<?> constructor = clazz2.getConstructor(class$java$lang$String == null ? SystemExceptionHelper.class$("java.lang.String") : class$java$lang$String);
                    MapEntry mapEntry = new MapEntry(string, typeCode, clazz2, clazz, constructor);
                    FINDER.put(mapEntry.fId, mapEntry);
                    FINDER.put(mapEntry.fClz, mapEntry);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
    }

    private static class MapEntry {
        public final String fId;
        public final TypeCode fType;
        public final Class fClz;
        public final Class fHClz;
        public final Constructor fStrCons;

        public MapEntry(String string, TypeCode typeCode, Class clazz, Class clazz2, Constructor constructor) {
            this.fId = string;
            this.fType = typeCode;
            this.fClz = clazz;
            this.fHClz = clazz2;
            this.fStrCons = constructor;
        }
    }
}

