/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.examples.messaging;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.TIMEOUT;
import org.omg.TimeBase.TimeTHelper;
import org.openorb.orb.examples.messaging.ITimeoutHelper;

public class Client {
    public static void main(String[] stringArray) {
        java.lang.Object object;
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("org.openorb.PI.FeatureInitializerClass.org.openorb.messaging.MessagingInitializer", "");
        ((Hashtable)properties).put("org.omg.CORBA.ORBClass", "org.openorb.CORBA.ORB");
        ((Hashtable)properties).put("org.omg.CORBA.ORBSingletonClass", "org.openorb.CORBA.ORBSingleton");
        ORB oRB = ORB.init(stringArray, properties);
        Object object2 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream("ObjectId");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            object = bufferedReader.readLine();
            object2 = oRB.string_to_object((String)object);
        }
        catch (IOException iOException) {
            System.out.println("File error");
            System.exit(1);
        }
        int n = 6000;
        int n2 = 2000;
        try {
            object = (PolicyManager)oRB.resolve_initial_references("ORBPolicyManager");
            Any any = oRB.create_any();
            TimeTHelper.insert(any, n * 1000 * 10);
            Policy[] policyArray = new Policy[]{oRB.create_policy(32, any)};
            object.set_policy_overrides(policyArray, SetOverrideType.ADD_OVERRIDE);
        }
        catch (InvalidName invalidName) {
            System.err.println("ORBPolicyManager wasn't found! (" + invalidName + ")");
            System.exit(1);
        }
        catch (PolicyError policyError) {
            System.err.println("A policy error occured: " + policyError);
            System.exit(1);
        }
        catch (InvalidPolicies invalidPolicies) {
            System.err.println("An invalid policy has been specified: " + invalidPolicies);
            System.exit(1);
        }
        object = ITimeoutHelper.narrow(object2);
        try {
            System.out.println("1) Calling server...");
            object.waitForTimeout(n - n2);
            System.out.println("1) Returned from server!");
        }
        catch (TIMEOUT tIMEOUT) {
            System.out.println("The TIMEOUT exception should not occur here!");
        }
        try {
            System.out.println("2) Calling server...");
            object.waitForTimeout(n + n2);
            System.out.println("2) Returned from server!");
        }
        catch (TIMEOUT tIMEOUT) {
            System.out.println("The TIMEOUT exception occured as expected!");
        }
    }
}

