/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.test.adapter.fwd;

import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.openorb.corbaloc.CorbalocService;
import org.openorb.corbaloc.CorbalocServiceHelper;
import org.openorb.test.ORBTestCase;
import org.openorb.test.adapter.poa.Hello;
import org.openorb.test.adapter.poa.HelloHelper;
import org.openorb.test.adapter.poa.HelloPOA;

public class FWDTest
extends ORBTestCase {
    private static final String PORT = "23412";
    static /* synthetic */ Class class$org$openorb$test$adapter$fwd$FWDTest;

    public FWDTest(String string) {
        super(string);
    }

    protected void setUp() {
        Properties properties = new Properties();
        properties.setProperty("ImportModule.Corbaloc", "${openorb.home}config/default.xml#CorbalocService");
        properties.setProperty("iiop.port", PORT);
        this.setUp(properties);
    }

    public void testResolve() throws UserException {
        ORB oRB = this.getORB();
        CorbalocService corbalocService = CorbalocServiceHelper.narrow(oRB.resolve_initial_references("CorbalocService"));
        Hello hello = new HelloImpl()._this(this.getORB());
        corbalocService.put("Test", hello);
        Assert.assertTrue("Get object is not equivalent", hello._is_equivalent(corbalocService.get("Test")));
        Object object = oRB.string_to_object("corbaloc::localhost:23412/Test");
        Hello hello2 = HelloHelper.narrow(object);
        hello2.hello("Mouse");
    }

    public void testLocalCorbaloc() throws UserException {
        ORB oRB = this.getORB();
        CorbalocService corbalocService = CorbalocServiceHelper.narrow(oRB.string_to_object("corbaloc::localhost:23412/CorbalocService"));
        Hello hello = new HelloImpl()._this(this.getORB());
        corbalocService.put("Test", hello);
        Assert.assertTrue("Get object is not equivalent", hello._is_equivalent(corbalocService.get("Test")));
        Object object = oRB.string_to_object("corbaloc::localhost:23412/Test");
        Hello hello2 = HelloHelper.narrow(object);
        hello2.hello("Mouse");
    }

    public void testRemoteCorbaloc() throws UserException {
        ORB oRB = ORB.init((String[])null, null);
        Thread.currentThread().interrupt();
        oRB.run();
        Thread.interrupted();
        CorbalocService corbalocService = CorbalocServiceHelper.narrow(oRB.string_to_object("corbaloc::localhost:23412/CorbalocService"));
        HelloImpl helloImpl = new HelloImpl();
        Hello hello = helloImpl._this(this.getORB());
        helloImpl._default_POA().the_POAManager().activate();
        corbalocService.put("Test", hello);
        Assert.assertTrue("Get object is not equivalent", hello._is_equivalent(corbalocService.get("Test")));
        Object object = oRB.string_to_object("corbaloc::localhost:23412/Test");
        Hello hello2 = HelloHelper.narrow(object);
        hello2.hello("Mouse");
        oRB.shutdown(true);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(new TestSuite(class$org$openorb$test$adapter$fwd$FWDTest == null ? (class$org$openorb$test$adapter$fwd$FWDTest = FWDTest.class$("org.openorb.test.adapter.fwd.FWDTest")) : class$org$openorb$test$adapter$fwd$FWDTest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class HelloImpl
    extends HelloPOA {
        HelloImpl() {
        }

        public void hello(String string) {
            System.out.println(string);
        }
    }
}

