/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.test;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.SetOverrideType;
import org.openorb.io.HexPrintStream;

public abstract class ORBTestCase
extends TestCase {
    private Policy m_forcePolicy;
    private ORB m_serverORB;
    private Thread m_serverThread;
    private Properties m_props;

    public ORBTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.setUp(null);
    }

    protected void setUp(Properties properties) {
        this.m_props = properties == null ? new Properties() : properties;
        this.m_props.setProperty("openorb.useStaticThreadGroup", "true");
        String[] stringArray = new String[]{};
        this.m_serverORB = ORB.init(stringArray, this.m_props);
        final Vector vector = new Vector();
        this.m_serverThread = new Thread(new Runnable(){

            public void run() {
                try {
                    vector.add(new java.lang.Object());
                    ORBTestCase.this.m_serverORB.run();
                }
                catch (Exception exception) {
                    System.out.println("THIS IS REALLY STRANGE!!!");
                    exception.printStackTrace();
                }
            }
        });
        this.m_serverThread.start();
        try {
            while (vector.size() == 0) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void tearDown() {
        this.m_serverORB.shutdown(true);
        this.m_serverORB = null;
        try {
            this.m_serverThread.join(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue("ORBTestCase.postExecute: Unable to stop server orb", !this.m_serverThread.isAlive());
        this.m_props = null;
    }

    protected ORB restartORB() {
        this.m_serverORB.shutdown(true);
        try {
            this.m_serverThread.join(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue("ORBTestCase.restartORB: Unable to stop server orb", !this.m_serverThread.isAlive());
        String[] stringArray = new String[]{};
        this.m_serverORB = ORB.init(stringArray, this.m_props);
        this.m_serverThread = new Thread(new Runnable(){

            public void run() {
                ORBTestCase.this.m_serverORB.run();
            }
        });
        this.m_serverThread.start();
        return this.m_serverORB;
    }

    public ORB getORB() {
        return this.m_serverORB;
    }

    public Object forceMarshal(Object object) throws PolicyError {
        if (this.m_forcePolicy == null) {
            this.m_forcePolicy = this.m_serverORB.create_policy(1146057218, this.m_serverORB.create_any());
        }
        return object._set_policy_override(new Policy[]{this.m_forcePolicy}, SetOverrideType.ADD_OVERRIDE);
    }

    public static void writeVerboseHex(OutputStream outputStream, byte[] byArray) throws IOException {
        HexPrintStream hexPrintStream = new HexPrintStream(outputStream, 2);
        hexPrintStream.write(byArray);
        hexPrintStream.flush();
    }
}

