/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.util.AbstractSequentialList;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.openorb.util.Trace;

public class MergeStack
extends AbstractSequentialList {
    private static final int DEFAULT_ALLOC_INC = 10;
    private static final Object LIST_EMPTY_OBJ = new Object();
    private int m_allocInc;
    private int m_size = 0;
    private PartialList m_head = null;
    private PartialList m_tail = null;
    private int m_modCount = 0;

    public MergeStack() {
        this(10);
    }

    public MergeStack(int n) {
        this.m_allocInc = n;
        this.m_head = this.m_tail = new PartialList(this.m_allocInc);
    }

    public void clear() {
        this.m_head = this.m_tail = new PartialList(this.m_allocInc);
        this.m_size = 0;
    }

    public ListIterator listIterator(int n) {
        if (n > this.m_size || n < 0) {
            throw new IndexOutOfBoundsException();
        }
        return new MSListIterator(n);
    }

    public int size() {
        return this.m_size;
    }

    public boolean add(Object object) {
        this.addLast(object);
        return true;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.m_size == 0) {
            throw new NoSuchElementException();
        }
        Object object = this.m_head.getFirst();
        if (object == LIST_EMPTY_OBJ) {
            throw Trace.signalIllegalCondition(null, "Illegal condition detected in MergerStack(" + System.identityHashCode(this) + ").getFirst() : [ret == LIST_EMPTY_OBJ]");
        }
        return object;
    }

    public void addFirst(Object object) {
        if (!this.m_head.addFirst(object)) {
            PartialList partialList = this.m_head.setPrev(new PartialList(this.m_allocInc));
            partialList.setNext(this.m_head);
            this.m_head = partialList;
            this.m_head.addFirst(object);
        }
        ++this.m_size;
        ++this.m_modCount;
    }

    /*
     * Unable to fully structure code
     */
    public Object removeFirst() throws NoSuchElementException {
        if (this.m_size != 0) ** GOTO lbl6
        throw new NoSuchElementException();
lbl-1000:
        // 1 sources

        {
            this.m_head = this.m_head.getNext();
            this.m_head.setPrev(null);
lbl6:
            // 2 sources

            ** while ((var1_1 = this.m_head.removeFirst()) == MergeStack.LIST_EMPTY_OBJ)
        }
lbl7:
        // 1 sources

        --this.m_size;
        ++this.m_modCount;
        return var1_1;
    }

    public Object getLast() throws NoSuchElementException {
        if (this.m_size == 0) {
            throw new NoSuchElementException();
        }
        Object object = this.m_tail.getLast();
        if (object == LIST_EMPTY_OBJ) {
            throw Trace.signalIllegalCondition(null, "Illegal condition detected in MergerStack(" + System.identityHashCode(this) + ").getLast() : [ret == LIST_EMPTY_OBJ]");
        }
        return object;
    }

    public void addLast(Object object) {
        if (!this.m_tail.addLast(object)) {
            PartialList partialList = this.m_tail.setNext(new PartialList(this.m_allocInc));
            partialList.setPrev(this.m_tail);
            this.m_tail = partialList;
            this.m_tail.addLast(object);
        }
        ++this.m_size;
        ++this.m_modCount;
    }

    /*
     * Unable to fully structure code
     */
    public Object removeLast() throws NoSuchElementException {
        if (this.m_size != 0) ** GOTO lbl6
        throw new NoSuchElementException();
lbl-1000:
        // 1 sources

        {
            this.m_tail = this.m_tail.getPrev();
            this.m_tail.setNext(null);
lbl6:
            // 2 sources

            ** while ((var1_1 = this.m_tail.removeLast()) == MergeStack.LIST_EMPTY_OBJ)
        }
lbl7:
        // 1 sources

        --this.m_size;
        ++this.m_modCount;
        return var1_1;
    }

    public void append(MergeStack mergeStack) {
        if (mergeStack.m_size == 0) {
            return;
        }
        this.m_size += mergeStack.m_size;
        ++this.m_modCount;
        this.m_tail.append(mergeStack.m_head);
        if (this.m_tail.getNext() != null) {
            this.m_tail = mergeStack.m_tail;
        }
        mergeStack.clear();
    }

    private static void testList(MergeStack mergeStack, int n) {
        ListIterator listIterator = mergeStack.listIterator(0);
        int n2 = 0;
        while (n2 < n) {
            if (listIterator.nextIndex() != n2) {
                throw Trace.signalIllegalCondition(null, "itt.nextIndex() != i");
            }
            if ((Integer)listIterator.next() != n2) {
                throw Trace.signalIllegalCondition(null, "((Integer)itt.next()).intValue() != i");
            }
            ++n2;
        }
        if (listIterator.hasNext()) {
            throw Trace.signalIllegalCondition(null, "itt.hasNext()");
        }
        int n3 = 0;
        while (n3 < n) {
            if ((Integer)mergeStack.removeFirst() != n3) {
                throw Trace.signalIllegalCondition(null, "((Integer)s.removeFirst()).intValue() != i");
            }
            ++n3;
        }
        if (!mergeStack.isEmpty()) {
            throw Trace.signalIllegalCondition(null, "!s.isEmpty()");
        }
    }

    private class MSListIterator
    implements ListIterator {
        private int m_mod;
        private int m_index;
        private PartialList m_curr;
        private int m_currIdx;
        private int m_repl = 1;

        MSListIterator(int n) {
            this.m_mod = MergeStack.this.m_modCount;
            this.m_index = n;
            if (n < MergeStack.this.m_size / 2) {
                this.m_curr = MergeStack.this.m_head;
                this.m_currIdx = 0;
                while (n > this.m_curr.size()) {
                    n -= this.m_curr.size();
                    this.m_curr = this.m_curr.getNext();
                }
                this.m_currIdx = n;
            } else {
                this.m_curr = MergeStack.this.m_tail;
                n = MergeStack.this.m_size - n;
                while (n > this.m_curr.size()) {
                    n -= this.m_curr.size();
                    this.m_curr = this.m_curr.getPrev();
                }
                this.m_currIdx = this.m_curr.size() - n;
            }
        }

        public int previousIndex() {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            return this.m_index - 1;
        }

        public boolean hasNext() {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            return this.m_index < MergeStack.this.m_size;
        }

        public void set(Object object) {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.m_repl > 0) {
                throw new IllegalStateException();
            }
            this.m_curr.set(this.m_currIdx + this.m_repl, object);
        }

        public Object next() {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.m_index == MergeStack.this.m_size) {
                throw new NoSuchElementException();
            }
            Object object = this.m_curr.get(this.m_currIdx);
            if (++this.m_currIdx >= this.m_curr.size()) {
                this.m_curr = this.m_curr.getNext();
                this.m_currIdx = 0;
            }
            ++this.m_index;
            this.m_repl = 0;
            return object;
        }

        public int nextIndex() {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            return this.m_index;
        }

        public void remove() {
            if (this.m_index == 0) {
                MergeStack.this.removeFirst();
                this.m_curr = MergeStack.this.m_head;
                this.m_mod = MergeStack.this.m_modCount;
            } else if (this.m_index == MergeStack.this.m_size) {
                MergeStack.this.removeLast();
                this.m_curr = MergeStack.this.m_tail;
                this.m_mod = MergeStack.this.m_modCount;
            } else {
                throw new UnsupportedOperationException();
            }
        }

        public boolean hasPrevious() {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            return this.m_index > 0;
        }

        public void add(Object object) {
            if (this.m_index == 0) {
                MergeStack.this.addFirst(object);
                this.m_curr = MergeStack.this.m_head;
                this.m_mod = MergeStack.this.m_modCount;
            } else if (this.m_index == MergeStack.this.m_size) {
                MergeStack.this.addLast(object);
                this.m_curr = MergeStack.this.m_tail;
                this.m_mod = MergeStack.this.m_modCount;
            } else {
                throw new UnsupportedOperationException();
            }
        }

        public Object previous() {
            if (this.m_mod != MergeStack.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.m_index == 0) {
                throw new NoSuchElementException();
            }
            if (--this.m_currIdx < 0) {
                this.m_curr = this.m_curr.getPrev();
                this.m_currIdx = this.m_curr.size() - 1;
            }
            --this.m_index;
            this.m_repl = -1;
            return this.m_curr.get(this.m_currIdx);
        }
    }

    private static final class PartialList {
        private final Object[] m_objects;
        private final int m_capacity;
        private int m_start = 0;
        private int m_end = 0;
        private PartialList m_prev = null;
        private PartialList m_next = null;

        PartialList(int n) {
            this.m_capacity = n;
            this.m_objects = new Object[this.m_capacity];
        }

        public PartialList getPrev() {
            return this.m_prev;
        }

        public PartialList setPrev(PartialList partialList) {
            this.m_prev = partialList;
            return this.m_prev;
        }

        public PartialList getNext() {
            return this.m_next;
        }

        public PartialList setNext(PartialList partialList) {
            this.m_next = partialList;
            return this.m_next;
        }

        boolean full() {
            return this.m_end == this.m_start + this.m_capacity;
        }

        boolean empty() {
            return this.m_end == this.m_start;
        }

        int size() {
            return this.m_end - this.m_start;
        }

        Object getLast() {
            if (this.empty()) {
                return LIST_EMPTY_OBJ;
            }
            return this.m_objects[(this.m_end - 1) % this.m_capacity];
        }

        boolean addLast(Object object) {
            if (this.full()) {
                return false;
            }
            this.m_objects[this.m_end % this.m_capacity] = object;
            ++this.m_end;
            return true;
        }

        Object removeLast() {
            if (this.empty()) {
                return LIST_EMPTY_OBJ;
            }
            int n = --this.m_end % this.m_capacity;
            Object object = this.m_objects[n];
            this.m_objects[n] = null;
            return object;
        }

        Object getFirst() {
            if (this.empty()) {
                return LIST_EMPTY_OBJ;
            }
            return this.m_objects[this.m_start];
        }

        boolean addFirst(Object object) {
            if (this.full()) {
                return false;
            }
            if (--this.m_start < 0) {
                this.m_start = this.m_capacity - 1;
                this.m_end += this.m_capacity;
            }
            this.m_objects[this.m_start] = object;
            return true;
        }

        Object removeFirst() {
            if (this.empty()) {
                return LIST_EMPTY_OBJ;
            }
            Object object = this.m_objects[this.m_start];
            this.m_objects[this.m_start] = null;
            if (++this.m_start == this.m_capacity) {
                this.m_start = 0;
                this.m_end -= this.m_capacity;
            }
            return object;
        }

        Object get(int n) {
            if (n >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return this.m_objects[(this.m_start + n) % this.m_capacity];
        }

        Object set(int n, Object object) {
            if (n >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            Object object2 = this.m_objects[(this.m_start + n) % this.m_capacity];
            this.m_objects[(this.m_start + n) % this.m_capacity] = object;
            return object2;
        }

        void append(PartialList partialList) {
            int n = partialList.size();
            if (this.m_capacity - this.size() >= n) {
                int n2 = 0;
                while (n2 < n) {
                    this.m_objects[(this.m_end + n2) % this.m_capacity] = partialList.m_objects[(partialList.m_start + n2) % partialList.m_capacity];
                    ++n2;
                }
                this.m_end += n;
                this.m_next = partialList.m_next;
            } else {
                this.m_next = partialList;
            }
            this.m_next.m_prev = this;
        }
    }
}

