/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.util.EventListener;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.SystemException;
import org.openorb.io.Scrap;
import org.openorb.io.StorageBuffer;

public class MarshalBuffer {
    private SystemException m_cancel_exception = null;
    private Scrap m_head = this.m_tail = new Scrap();
    private Scrap m_tail;
    private OctetSeqHolder m_last_buffer = null;
    private boolean m_allow_fragment = false;
    private boolean m_in_fragment = false;
    private boolean m_header_fragment = true;
    private HeaderData m_last_header = null;
    private boolean m_block_fragment = true;
    private BlockData m_last_block = null;
    private Listener m_listener = null;
    private Object m_listener_cookie = null;
    private boolean m_in_listener = false;
    private byte[] m_ignore_buffer = null;

    public MarshalBuffer() {
        this.m_tail.fBuffer = new byte[2048];
        this.m_tail.fOffset = 0;
        this.m_tail.fLength = 0;
        this.m_tail.fMode = 0;
        this.m_tail.fPosition = 0;
    }

    public MarshalBuffer(Listener listener, Object object) {
        this();
        this.m_listener = listener;
        this.m_listener_cookie = object;
    }

    public boolean isStandalone() {
        return this.m_listener == null;
    }

    public int size() {
        if (!this.prealloc()) {
            return -1;
        }
        return this.m_tail.fPosition;
    }

    public int available() {
        if (!this.prealloc()) {
            return -1;
        }
        return this.m_tail.fPosition - this.m_head.fPosition + this.m_head.fLength;
    }

    public void setAllowFragment(boolean bl) {
        this.m_allow_fragment = bl;
    }

    public boolean getAllowFragment() {
        return this.m_allow_fragment && this.m_header_fragment && this.m_block_fragment && !this.m_in_fragment;
    }

    public void alloc(OctetSeqHolder octetSeqHolder, IntHolder intHolder, int n) {
        if (!this.prealloc()) {
            if (this.m_ignore_buffer == null || this.m_ignore_buffer.length < n) {
                this.m_ignore_buffer = new byte[n];
            }
            octetSeqHolder.value = this.m_ignore_buffer;
            intHolder.value = 0;
            return;
        }
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (this.m_tail.fBuffer.length - this.m_tail.fLength - this.m_tail.fOffset >= n) {
            octetSeqHolder.value = this.m_tail.fBuffer;
            intHolder.value = this.m_tail.fOffset + this.m_tail.fLength;
            this.m_tail.fLength += n;
            this.m_tail.fPosition += n;
        } else {
            Scrap scrap = new Scrap();
            scrap.fBuffer = n > 2048 ? new byte[n] : new byte[2048];
            scrap.fOffset = 0;
            scrap.fLength = n;
            scrap.fMode = 0;
            scrap.fPosition = this.m_tail.fPosition + n;
            octetSeqHolder.value = scrap.fBuffer;
            intHolder.value = 0;
            this.m_tail.fNext = scrap;
            this.m_tail = scrap;
        }
        this.m_last_buffer = octetSeqHolder;
    }

    public void append(byte[] byArray, int n, int n2) {
        if (!this.prealloc()) {
            return;
        }
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (n2 == 0) {
            return;
        }
        if (n2 < 2048) {
            if (this.m_tail.fBuffer.length - this.m_tail.fLength - this.m_tail.fOffset >= n2) {
                System.arraycopy(byArray, n, this.m_tail.fBuffer, this.m_tail.fOffset + this.m_tail.fLength, n2);
                this.m_tail.fLength += n2;
                this.m_tail.fPosition += n2;
            } else {
                int n3 = this.m_tail.fBuffer.length - this.m_tail.fLength - this.m_tail.fOffset;
                System.arraycopy(byArray, n, this.m_tail.fBuffer, this.m_tail.fOffset + this.m_tail.fLength, n3);
                this.m_tail.fLength += n3;
                this.m_tail.fPosition += n3;
                Scrap scrap = new Scrap();
                scrap.fBuffer = new byte[2048];
                scrap.fOffset = 0;
                scrap.fLength = n2 - n3;
                scrap.fMode = 0;
                scrap.fPosition = this.m_tail.fPosition + n2 - n3;
                System.arraycopy(byArray, n + n3, scrap.fBuffer, 0, n2 - n3);
                this.m_tail.fNext = scrap;
                this.m_tail = scrap;
            }
            return;
        }
        if (this.m_tail.fLength == 0) {
            Scrap scrap = new Scrap();
            scrap.fBuffer = this.m_tail.fBuffer;
            scrap.fOffset = this.m_tail.fOffset;
            scrap.fLength = 0;
            scrap.fMode = 0;
            scrap.fPosition = this.m_tail.fPosition + n2;
            this.m_tail.fBuffer = byArray;
            this.m_tail.fOffset = n;
            this.m_tail.fLength = n2;
            this.m_tail.fMode = 3;
            this.m_tail.fPosition = scrap.fPosition;
            this.m_tail.fNext = scrap;
            this.m_tail = scrap;
        } else {
            this.m_tail.fMode = 1;
            Scrap scrap = new Scrap();
            scrap.fBuffer = byArray;
            scrap.fOffset = n;
            scrap.fLength = n2;
            scrap.fMode = 3;
            scrap.fPosition = this.m_tail.fPosition + n2;
            Scrap scrap2 = new Scrap();
            scrap2.fBuffer = this.m_tail.fBuffer;
            scrap2.fOffset = this.m_tail.fOffset + this.m_tail.fLength;
            scrap2.fLength = 0;
            scrap2.fPosition = scrap.fPosition;
            scrap2.fMode = 0;
            this.m_tail.fNext = scrap;
            scrap.fNext = scrap2;
            this.m_tail = scrap2;
        }
        this.postalloc();
    }

    public void pad(int n) {
        if (!this.prealloc()) {
            return;
        }
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (n == 0) {
            return;
        }
        int n2 = this.m_tail.fBuffer.length - this.m_tail.fLength - this.m_tail.fOffset;
        if (n2 >= n) {
            this.m_tail.fLength += n;
            this.m_tail.fPosition += n;
        } else {
            this.m_tail.fLength += n2;
            this.m_tail.fPosition += n2;
            Scrap scrap = new Scrap();
            scrap.fBuffer = new byte[2048];
            scrap.fOffset = 0;
            scrap.fLength = n - n2;
            scrap.fMode = 0;
            scrap.fPosition = this.m_tail.fPosition + scrap.fLength;
            this.m_tail.fNext = scrap;
            this.m_tail = scrap;
        }
        this.postalloc();
    }

    public void addHeader(HeaderGenerator headerGenerator, int n, boolean bl, Object object) {
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (headerGenerator == null) {
            throw new NullPointerException();
        }
        if (!this.prealloc()) {
            return;
        }
        HeaderData headerData = new HeaderData();
        headerData.fPrevious = this.m_last_header;
        this.m_last_header = headerData;
        headerData.fLastHeaderFragment = this.m_header_fragment;
        headerData.fPosition = this.size();
        headerData.fGenerator = headerGenerator;
        headerData.fCookie = object;
        if (n != 0) {
            this.m_header_fragment = false;
            OctetSeqHolder octetSeqHolder = new OctetSeqHolder();
            IntHolder intHolder = new IntHolder();
            this.alloc(octetSeqHolder, intHolder, n);
            headerData.fBuffer = octetSeqHolder.value;
            headerData.fOffset = intHolder.value;
            headerData.fLength = n;
        }
        this.m_header_fragment = headerData.fLastHeaderFragment && bl;
    }

    public void beginBlock(BlockGenerator blockGenerator, int n, boolean bl, Object object) {
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (blockGenerator == null) {
            throw new NullPointerException();
        }
        if (!this.prealloc()) {
            return;
        }
        BlockData blockData = new BlockData();
        blockData.fPrevious = this.m_last_block;
        blockData.fIsFragment = this.m_last_block == null ? bl : false;
        this.m_last_block = blockData;
        blockData.fPosition = this.size();
        blockData.fGenerator = blockGenerator;
        blockData.fCookie = object;
        if (n != 0) {
            this.m_block_fragment = false;
            OctetSeqHolder octetSeqHolder = new OctetSeqHolder();
            IntHolder intHolder = new IntHolder();
            this.alloc(octetSeqHolder, intHolder, n);
            blockData.fBuffer = octetSeqHolder.value;
            blockData.fOffset = intHolder.value;
            blockData.fLength = n;
        }
        this.m_block_fragment = blockData.fIsFragment;
    }

    public void endBlock() {
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (this.m_last_block == null) {
            throw new IllegalStateException("End block without begin block");
        }
        this.m_last_block.fGenerator.endBlock(this.m_last_block.fBuffer, this.m_last_block.fOffset, this.m_last_block.fLength, this.size() - this.m_last_block.fPosition, this.m_last_block.fCookie);
        this.m_last_block = this.m_last_block.fPrevious;
        this.m_block_fragment = this.m_last_block == null ? true : this.m_last_block.fIsFragment;
    }

    public void close() {
        if (this.m_in_listener) {
            throw new IllegalStateException("Cannot close buffer while calling listener.");
        }
        if (this.m_last_block != null) {
            throw new IllegalStateException("All blocks must be closed before closing buffer");
        }
        if (!this.prealloc()) {
            return;
        }
        if (this.m_listener != null) {
            this.m_in_listener = true;
            this.m_listener.bufferClosed(this, this.m_tail.fPosition, this.m_listener_cookie);
            this.m_in_listener = false;
        }
        this.m_tail = null;
        this.m_head = null;
        this.m_last_header = null;
    }

    public void cancel(SystemException systemException) {
        if (!this.prealloc()) {
            return;
        }
        if (this.m_listener != null) {
            this.m_in_listener = true;
            try {
                this.m_listener.bufferCanceled(this, systemException, this.m_listener_cookie);
            }
            catch (SystemException systemException2) {
                this.m_cancel_exception = systemException2;
            }
            this.m_in_listener = false;
        } else {
            this.m_cancel_exception = systemException;
        }
        this.m_tail = null;
        this.m_head = null;
        this.m_last_header = null;
        this.m_last_block = null;
        if (this.m_cancel_exception != null) {
            throw this.m_cancel_exception;
        }
    }

    public StorageBuffer fragment(int n) {
        Scrap scrap;
        Scrap scrap2;
        if (!this.prealloc()) {
            return null;
        }
        if (this.m_listener != null && !this.m_in_listener) {
            throw new IllegalStateException("Operation disallowed, must be called from listener");
        }
        if (!this.getAllowFragment()) {
            throw new IllegalStateException("Buffer cannot currently be fragmented");
        }
        if (n > this.m_tail.fPosition - this.m_head.fPosition + this.m_head.fLength) {
            throw new IndexOutOfBoundsException();
        }
        this.m_in_fragment = true;
        if (this.m_last_block != null) {
            BlockData blockData = this.m_last_block;
            this.m_last_block = null;
            blockData.fGenerator.fragmentBlock(blockData.fBuffer, blockData.fOffset, blockData.fLength, this.size() - blockData.fPosition, this, blockData.fCookie);
        }
        int n2 = n + this.m_head.fPosition - this.m_head.fLength;
        HeaderData headerData = null;
        while (this.m_last_header != null) {
            this.m_last_header.fGenerator.endMessage(this.m_last_header.fBuffer, this.m_last_header.fOffset, this.m_last_header.fLength, true, n2 - this.m_last_header.fPosition, this.m_last_header.fCookie);
            HeaderData headerData2 = this.m_last_header.fPrevious;
            this.m_last_header.fPrevious = headerData;
            headerData = this.m_last_header;
            this.m_last_header = headerData2;
        }
        if (this.m_tail.fPosition - this.m_tail.fLength < n2) {
            scrap2 = this.m_tail;
        } else {
            scrap2 = this.m_head;
            while (scrap2.fPosition < n2) {
                scrap2 = scrap2.fNext;
            }
        }
        if (scrap2.fPosition == n2) {
            scrap = scrap2.fNext;
            scrap2.fNext = null;
        } else {
            int n3 = scrap2.fPosition - n2;
            scrap = new Scrap();
            scrap.fMode = 1 | scrap2.fMode;
            scrap.fBuffer = scrap2.fBuffer;
            scrap.fPosition = scrap2.fPosition;
            scrap.fOffset = scrap2.fOffset + scrap2.fLength - n3;
            scrap.fLength = n3;
            scrap.fNext = scrap2.fNext;
            scrap2.fLength -= n3;
            scrap2.fPosition = n2;
            scrap2.fNext = null;
            scrap2.fMode = 1 | scrap2.fMode;
        }
        scrap2 = null;
        StorageBuffer storageBuffer = new StorageBuffer(this.m_head, n);
        this.m_head = this.m_tail = new Scrap();
        this.m_tail.fBuffer = new byte[2048];
        this.m_tail.fOffset = 0;
        this.m_tail.fLength = 0;
        this.m_tail.fMode = 0;
        this.m_tail.fPosition = n2;
        while (headerData != null) {
            headerData.fGenerator.beginMessage(this, headerData.fCookie);
            headerData = headerData.fPrevious;
        }
        this.prealloc();
        int n4 = 0;
        if (scrap != null) {
            n4 = this.m_tail.fPosition + scrap.fLength - scrap.fPosition;
            if (this.m_tail.fLength == 0) {
                this.m_tail.fBuffer = scrap.fBuffer;
                this.m_tail.fLength = scrap.fLength;
                this.m_tail.fOffset = scrap.fOffset;
                this.m_tail.fMode = scrap.fMode;
                this.m_tail.fNext = scrap.fNext;
                this.m_tail.fPosition += scrap.fLength;
                scrap = scrap.fNext;
            } else {
                this.m_tail.fNext = scrap;
            }
            while (scrap != null) {
                scrap.fPosition += n4;
                this.m_tail = scrap;
                scrap = scrap.fNext;
            }
        }
        BlockData blockData = this.m_last_block;
        while (blockData != null) {
            blockData.fPosition += n4;
            blockData = blockData.fPrevious;
        }
        this.m_in_fragment = false;
        return storageBuffer;
    }

    /*
     * Unable to fully structure code
     */
    public StorageBuffer lastFragment() {
        if (!this.prealloc()) {
            return null;
        }
        if (this.m_listener != null && !this.m_in_listener) {
            throw new IllegalStateException("Operation disallowed, must be called from listener. Call close operation");
        }
        if (this.m_last_block == null) ** GOTO lbl9
        throw new IllegalStateException("Attempt to close buffer without closing all blocks");
lbl-1000:
        // 1 sources

        {
            this.m_last_header.fGenerator.endMessage(this.m_last_header.fBuffer, this.m_last_header.fOffset, this.m_last_header.fLength, false, this.m_tail.fPosition - this.m_last_header.fPosition, this.m_last_header.fCookie);
            this.m_last_header = this.m_last_header.fPrevious;
lbl9:
            // 2 sources

            ** while (this.m_last_header != null)
        }
lbl10:
        // 1 sources

        var1_1 = this.m_head;
        var2_2 = this.m_tail.fPosition;
        this.m_tail = null;
        this.m_head = null;
        return new StorageBuffer(var1_1, var2_2);
    }

    private boolean prealloc() {
        if (this.m_cancel_exception != null) {
            throw this.m_cancel_exception;
        }
        if (this.m_head == null) {
            return false;
        }
        if (this.m_last_buffer != null) {
            this.m_last_buffer.value = null;
            this.m_last_buffer = null;
            this.postalloc();
        }
        return true;
    }

    private void postalloc() {
        if (this.m_listener != null && this.m_allow_fragment && this.m_header_fragment && this.m_block_fragment && !this.m_in_fragment) {
            this.m_in_listener = true;
            this.m_listener.availIncreaced(this, this.m_tail.fPosition - this.m_head.fPosition + this.m_head.fLength, this.m_listener_cookie);
            this.m_in_listener = false;
        }
    }

    public static void main(String[] stringArray) {
        MarshalBuffer marshalBuffer = new MarshalBuffer();
        OctetSeqHolder octetSeqHolder = new OctetSeqHolder();
        IntHolder intHolder = new IntHolder();
        int n = 1;
        int n2 = 0;
        while (n2 < 3000) {
            marshalBuffer.alloc(octetSeqHolder, intHolder, n);
            int n3 = 0;
            while (n3 < n) {
                octetSeqHolder.value[intHolder.value + n3] = (byte)((n2 + n3) % 121);
                ++n3;
            }
            n2 += n;
        }
        StorageBuffer storageBuffer = marshalBuffer.lastFragment();
        System.out.println("available = " + storageBuffer.available());
        System.out.println("available = " + storageBuffer.available());
        byte[] byArray = storageBuffer.linearize();
        int n4 = 0;
        while (n4 < byArray.length) {
            if (byArray[n4] != (byte)(n4 % 121)) {
                System.out.println("Error at index " + n4);
            }
            ++n4;
        }
    }

    private static class BlockData {
        public BlockData fPrevious;
        public boolean fIsFragment;
        public int fPosition;
        public BlockGenerator fGenerator;
        public Object fCookie;
        public byte[] fBuffer;
        public int fOffset;
        public int fLength;

        private BlockData() {
        }
    }

    private static class HeaderData {
        public HeaderData fPrevious;
        public boolean fLastHeaderFragment;
        public int fPosition;
        public HeaderGenerator fGenerator;
        public Object fCookie;
        public byte[] fBuffer;
        public int fOffset;
        public int fLength;

        private HeaderData() {
        }
    }

    public static interface Listener
    extends EventListener {
        public void availIncreaced(MarshalBuffer var1, int var2, Object var3);

        public void bufferClosed(MarshalBuffer var1, int var2, Object var3);

        public void bufferCanceled(MarshalBuffer var1, SystemException var2, Object var3);
    }

    public static interface BlockGenerator {
        public void endBlock(byte[] var1, int var2, int var3, int var4, Object var5);

        public void fragmentBlock(byte[] var1, int var2, int var3, int var4, MarshalBuffer var5, Object var6);
    }

    public static interface HeaderGenerator {
        public void endMessage(byte[] var1, int var2, int var3, boolean var4, int var5, Object var6);

        public void beginMessage(MarshalBuffer var1, Object var2);
    }
}

