/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.SystemException;
import org.omg.IIOP.ListenPoint;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.TaggedProfile;
import org.openorb.CORBA.ORB;
import org.openorb.PI.ComponentSet;
import org.openorb.iiop.CDRCodecFactory;
import org.openorb.iiop.IIOPClientProtocol;
import org.openorb.iiop.IIOPServerChannel;
import org.openorb.iiop.IIOPTransportServerInitializer;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerProtocol;
import org.openorb.net.Transport;
import org.openorb.util.Trace;

public class IIOPServerProtocol
implements ServerProtocol {
    private ServerManager m_server_manager;
    private ListenPoint m_primary_endpoint;
    private Codec m_codec;
    private org.omg.CORBA.ORB m_orb;
    private IIOPClientProtocol m_client_protocol;
    private Object m_sync_state;
    private int m_state;
    private IIOPTransportServerInitializer m_server_transport_init;
    private Logger m_logger;

    public IIOPServerProtocol(ServerManager serverManager, CDRCodecFactory cDRCodecFactory, IIOPTransportServerInitializer iIOPTransportServerInitializer) {
        block3: {
            this.m_client_protocol = null;
            this.m_sync_state = new Object();
            this.m_state = 2;
            this.m_logger = null;
            this.m_server_manager = serverManager;
            this.m_orb = this.m_server_manager.orb();
            this.m_logger = ((ORB)this.orb()).getLogger();
            try {
                this.m_codec = cDRCodecFactory.create_codec(new Encoding(0, 1, 2));
            }
            catch (UnknownEncoding unknownEncoding) {
                if (!this.getLogger().isErrorEnabled()) break block3;
                this.getLogger().error("Could not find codec.", unknownEncoding);
            }
        }
        this.m_server_transport_init = iIOPTransportServerInitializer;
        this.m_state = 2;
        this.m_primary_endpoint = this.m_server_transport_init.getPrimaryEndpoint();
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " created");
        }
    }

    public String toString() {
        return "ServerProtocol: " + this.m_server_transport_init.toString();
    }

    public void setClientProtocol(IIOPClientProtocol iIOPClientProtocol) {
        this.m_client_protocol = iIOPClientProtocol;
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public ServerManager getServerManager() {
        return this.m_server_manager;
    }

    public boolean servesAddress(String string, int n) {
        if ((this.m_primary_endpoint.port & 0xFFFF) == n && string.equals(this.m_primary_endpoint.host)) {
            return true;
        }
        ListenPoint[] listenPointArray = this.m_server_transport_init.getBiDirEndpoints();
        if (listenPointArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < listenPointArray.length) {
            if ((listenPointArray[n2].port & 0xFFFF) == n && string.equals(listenPointArray[n2].host)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int state() {
        return this.m_state;
    }

    public boolean open() {
        Object object = this.m_sync_state;
        synchronized (object) {
            switch (this.m_state) {
                case 1: {
                    this.m_state = 0;
                    this.m_sync_state.notifyAll();
                    break;
                }
                case 2: {
                    try {
                        this.m_server_transport_init.open();
                    }
                    catch (SystemException systemException) {
                        boolean bl = false;
                        return bl;
                    }
                    this.m_primary_endpoint = this.m_server_transport_init.getPrimaryEndpoint();
                    this.m_state = 0;
                    this.m_server_manager.protocol_listening(this);
                }
            }
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug(this + " listening");
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean pause() {
        Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state != 2) {
                this.m_server_manager.protocol_not_listening(this, true);
                this.m_state = 1;
                if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug(this + " paused");
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public void close() {
        Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 2) {
                return;
            }
            this.m_state = 2;
            this.m_server_transport_init.close();
            this.m_server_manager.protocol_not_listening(this, false);
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug(this + " closed");
            }
        }
    }

    public void listen(int n) {
        Transport transport = null;
        if (this.m_state != 0) {
            return;
        }
        try {
            transport = this.m_server_transport_init.accept(n);
        }
        catch (SystemException systemException) {
            Trace.signalIllegalCondition(this.getLogger(), "Fatal error while accepting connection: " + systemException);
        }
        if (transport != null) {
            new IIOPServerChannel(this.m_server_manager, transport, this.m_client_protocol, this.m_codec);
        }
    }

    public void run_listen() {
        Thread thread = Thread.currentThread();
        while (!thread.isInterrupted() && this.m_state == 0) {
            this.listen(0);
        }
    }

    public TaggedProfile create_profile(int n, ComponentSet componentSet, byte[] byArray) {
        if (n != 0) {
            return null;
        }
        ProfileBody_1_1 profileBody_1_1 = new ProfileBody_1_1();
        profileBody_1_1.iiop_version = new Version(1, 2);
        profileBody_1_1.host = this.m_primary_endpoint.host;
        profileBody_1_1.port = this.m_primary_endpoint.port;
        profileBody_1_1.object_key = byArray;
        profileBody_1_1.components = componentSet.getComponents(n);
        Any any = this.m_orb.create_any();
        ProfileBody_1_1Helper.insert(any, profileBody_1_1);
        try {
            byte[] byArray2 = this.m_codec.encode_value(any);
            if (byArray2 != null) {
                return new TaggedProfile(n, byArray2);
            }
            return null;
        }
        catch (InvalidTypeForEncoding invalidTypeForEncoding) {
            Trace.signalIllegalCondition(this.getLogger(), "Invalid type for encoding.");
            return null;
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

