/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.BiDirPolicy.BidirectionalPolicyHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.GIOP.Version;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.openorb.CORBA.ORB;
import org.openorb.iiop.CDRInputStream;
import org.openorb.iiop.CDROutputStream;
import org.openorb.iiop.HeaderBlock;
import org.openorb.iiop.IIOPClientChannel;
import org.openorb.iiop.IIOPClientProtocol;
import org.openorb.iiop.IIOPServerRequest;
import org.openorb.iiop.SocketQueue;
import org.openorb.io.BufferSource;
import org.openorb.io.MarshalBuffer;
import org.openorb.io.StorageBuffer;
import org.openorb.net.ClientRequest;
import org.openorb.net.RequestIDAllocator;
import org.openorb.net.ServerChannel;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerRequest;
import org.openorb.net.Transport;
import org.openorb.util.ExceptionTool;
import org.openorb.util.NumberCache;
import org.openorb.util.Trace;

public class IIOPServerChannel
implements ServerChannel {
    public static final int CONN_SC_TOTAL = 2;
    public static final int CONN_SC_CODESETS = 0;
    public static final int CONN_SC_BIDIR = 1;
    private org.omg.CORBA.ORB m_orb;
    private ServerManager m_server_manager;
    private SocketQueue m_socket_queue;
    private Object m_sync_state;
    private int m_state = 0;
    private boolean m_pending_close = false;
    private boolean m_codesets = false;
    private int m_tcsc = 0;
    private int m_tcsw = 0;
    private IIOPClientProtocol m_client_protocol = null;
    private IIOPClientChannel m_client_peer = null;
    private boolean m_delegated = false;
    private Map m_active_requests = new HashMap();
    private int m_channel_age;
    private Object m_sync_recv = new Object();
    private boolean m_in_recv = false;
    private Version m_version = new Version(1, 2);
    private Constructor m_os_ctor;
    private Codec m_codec;
    private ListenPoint[] m_pending_bidir_endpoints;
    private Logger m_logger = null;
    private boolean[] m_recv_connection_service_contexts = new boolean[2];
    private MarshalBuffer.Listener m_marshal_listener = new MarshalListener();
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$org$omg$GIOP$Version;
    static /* synthetic */ Class class$org$openorb$io$MarshalBuffer;

    public IIOPServerChannel(ServerManager serverManager, Transport transport, IIOPClientProtocol iIOPClientProtocol, Codec codec) {
        this.m_server_manager = serverManager;
        this.m_orb = this.m_server_manager.orb();
        this.m_logger = ((ORB)this.orb()).getLogger();
        try {
            Class[] classArray = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = IIOPServerChannel.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = IIOPServerChannel.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$io$MarshalBuffer == null ? (class$org$openorb$io$MarshalBuffer = IIOPServerChannel.class$("org.openorb.io.MarshalBuffer")) : class$org$openorb$io$MarshalBuffer};
            this.m_os_ctor = ((ORB)this.m_orb).getLoader().classConstructor("iiop.CDROutputStreamClass", "org.openorb.iiop.CDROutputStream", classArray);
        }
        catch (Exception exception) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Unable to initialize output stream constructor.", exception);
            }
            throw ExceptionTool.initCause(new INITIALIZE("Unable to initialize output stream constructor (" + exception + ")"), (Throwable)exception);
        }
        this.m_socket_queue = new SocketQueue(transport);
        this.m_socket_queue.setServerChannel(this);
        this.m_client_protocol = iIOPClientProtocol;
        this.m_codec = codec;
        this.m_sync_state = new Object();
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " created");
        }
        this.m_server_manager.register_channel(this);
    }

    public IIOPServerChannel(ServerManager serverManager, IIOPClientChannel iIOPClientChannel, Codec codec) {
        this.m_server_manager = serverManager;
        this.m_orb = this.m_server_manager.orb();
        this.m_logger = ((ORB)this.orb()).getLogger();
        try {
            Class[] classArray = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = IIOPServerChannel.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = IIOPServerChannel.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$io$MarshalBuffer == null ? (class$org$openorb$io$MarshalBuffer = IIOPServerChannel.class$("org.openorb.io.MarshalBuffer")) : class$org$openorb$io$MarshalBuffer};
            this.m_os_ctor = ((ORB)this.m_orb).getLoader().classConstructor("iiop.CDROutputStreamClass", "org.openorb.iiop.CDROutputStream", classArray);
        }
        catch (Exception exception) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Unable to initialize output stream constructor.", exception);
            }
            throw ExceptionTool.initCause(new INITIALIZE("Unable to initialize output stream constructor (" + exception + ")"), (Throwable)exception);
        }
        this.m_client_peer = iIOPClientChannel;
        this.m_socket_queue = this.m_client_peer.getSocketQueue();
        this.m_socket_queue.setServerChannel(this);
        this.m_delegated = true;
        this.m_codec = codec;
        this.m_sync_state = this.m_client_peer.getSyncState();
        this.m_codesets = true;
        this.m_tcsc = this.m_client_peer.getTCSC();
        this.m_tcsw = this.m_client_peer.getTCSW();
    }

    public Map getActiveRequestMap() {
        return this.m_active_requests;
    }

    public SocketQueue getSocketQueue() {
        return this.m_socket_queue;
    }

    public ServerManager getServerManager() {
        return this.m_server_manager;
    }

    public Object getSyncState() {
        return this.m_sync_state;
    }

    public int getChannelAge() {
        return this.m_channel_age;
    }

    public void setClientPeer(IIOPClientChannel iIOPClientChannel) {
        this.m_client_peer = iIOPClientChannel;
    }

    public int getTCSC() {
        return this.m_tcsc;
    }

    public void setTCSC(int n) {
        this.m_tcsc = n;
    }

    public int getTCSW() {
        return this.m_tcsw;
    }

    public void setTCSW(int n) {
        this.m_tcsw = n;
    }

    public void setPendingClose() {
        this.m_pending_close = true;
    }

    public String toString() {
        return "ServerChannel: " + this.m_socket_queue.toString();
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public int state() {
        if (this.m_delegated) {
            Object object = this.m_sync_state;
            synchronized (object) {
                if (this.m_client_peer != null) {
                    int n = 0;
                    return n;
                }
                int n = 1;
                return n;
            }
        }
        return this.m_state;
    }

    public void setState(int n) {
        this.m_state = n;
    }

    public int active_requests() {
        Object object = this.m_sync_state;
        synchronized (object) {
            int n = this.m_active_requests.size() + (this.m_client_peer != null ? this.m_client_peer.getActiveRequestMap().size() : 0);
            return n;
        }
    }

    public int channel_age() {
        Object object = this.m_sync_state;
        synchronized (object) {
            if (!this.m_active_requests.isEmpty() || this.m_client_peer != null && !this.m_client_peer.getActiveRequestMap().isEmpty()) {
                int n = RequestIDAllocator.peek_request_id();
                return n;
            }
            if (this.m_client_peer != null && this.m_channel_age < this.m_client_peer.getChannelAge()) {
                int n = this.m_client_peer.getChannelAge();
                return n;
            }
            int n = this.m_channel_age;
            return n;
        }
    }

    public void close() {
        ClientRequest[] clientRequestArray;
        ServerRequest[] serverRequestArray;
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " disorderly shutdown");
        }
        if (this.m_delegated) {
            this.m_client_peer.close(true, new BAD_INV_ORDER(0, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 1) {
                return;
            }
            this.m_state = 1;
            this.m_pending_close = false;
            serverRequestArray = new ServerRequest[this.m_active_requests.values().size()];
            this.m_active_requests.values().toArray(serverRequestArray);
            this.m_active_requests.clear();
            if (this.m_client_peer != null) {
                Map map = this.m_client_peer.getActiveRequestMap();
                clientRequestArray = new ClientRequest[map.values().size()];
                map.values().toArray(clientRequestArray);
                map.clear();
                this.m_client_peer.setState(0x13000000);
                this.m_client_peer.setCloseException(new BAD_INV_ORDER(0, CompletionStatus.COMPLETED_MAYBE));
                this.m_client_peer.setServerPeer(null);
                this.m_client_peer = null;
            } else {
                clientRequestArray = null;
            }
        }
        this.m_server_manager.unregister_channel(this);
        this.m_socket_queue.close();
        int n = 0;
        while (n < serverRequestArray.length) {
            serverRequestArray[n].client_cancel();
            ++n;
        }
        if (clientRequestArray != null) {
            int n2 = 0;
            while (n2 < clientRequestArray.length) {
                clientRequestArray[n2].cancel(new BAD_INV_ORDER("ORB shutdown", 1330446340, CompletionStatus.COMPLETED_MAYBE));
                ++n2;
            }
        }
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " closed");
        }
    }

    public void soft_close(boolean bl) {
        if (Trace.isHigh() && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(this + " soft close [" + bl + "]");
        }
        if (this.m_delegated) {
            if (!bl) {
                this.m_client_peer.pause();
            } else {
                this.m_client_peer.close(false, new BAD_INV_ORDER(1330446340, CompletionStatus.COMPLETED_NO));
            }
            return;
        }
        Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 1) {
                return;
            }
            if (this.active_requests() > 0) {
                if (bl) {
                    this.m_pending_close = true;
                    if (this.m_client_peer != null) {
                        this.m_client_peer.setPendingClose();
                    }
                }
                return;
            }
            this.m_state = 1;
            this.m_pending_close = false;
            if (this.m_client_peer != null) {
                this.m_client_peer.setState(0x12000000);
                this.m_client_peer.setServerPeer(null);
                this.m_client_peer = null;
            }
        }
        this.m_server_manager.unregister_channel(this);
        this.m_socket_queue.close();
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " closed");
        }
    }

    public boolean recv(int n) {
        boolean bl;
        Object object;
        boolean bl2;
        if (this.m_delegated) {
            return false;
        }
        Object object2 = this.m_sync_recv;
        synchronized (object2) {
            if (this.m_in_recv) {
                boolean bl3 = true;
                return bl3;
            }
            this.m_in_recv = true;
        }
        try {
            if (!this.m_socket_queue.receive(n)) break block14;
            bl2 = true;
            Object var6_7 = null;
            object = this.m_sync_recv;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Object object3 = this.m_sync_recv;
            synchronized (object3) {
                this.m_in_recv = false;
            }
            throw throwable;
        }
        synchronized (object) {
            this.m_in_recv = false;
        }
        {
            block14: {
                return bl2;
            }
            this.close();
            bl = false;
        }
        Object var6_8 = null;
        Object object4 = this.m_sync_recv;
        synchronized (object4) {
            this.m_in_recv = false;
        }
        return bl;
    }

    public void run_recv() {
        Object object;
        if (this.m_delegated) {
            return;
        }
        Object object2 = this.m_sync_recv;
        synchronized (object2) {
            if (this.m_in_recv) {
                return;
            }
            this.m_in_recv = true;
        }
        try {
            Thread thread = Thread.currentThread();
            while (!Thread.interrupted()) {
                if (this.m_socket_queue.receive(1000)) continue;
                this.close();
                break;
            }
            Object var4_4 = null;
            object = this.m_sync_recv;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Object object3 = this.m_sync_recv;
            synchronized (object3) {
                this.m_in_recv = false;
            }
            throw throwable;
        }
        synchronized (object) {
            this.m_in_recv = false;
        }
    }

    int process_request(byte by, CDRInputStream cDRInputStream, byte by2, BufferSource bufferSource, Object object) {
        IIOPServerRequest iIOPServerRequest = null;
        int n = 0;
        byte[] byArray = null;
        switch (by2) {
            case 0: {
                switch (by) {
                    case 0: 
                    case 1: {
                        ServiceContext[] serviceContextArray = ServiceContextListHelper.read(cDRInputStream);
                        n = cDRInputStream.read_ulong();
                        byte by3 = cDRInputStream.read_boolean() ? (byte)3 : 2;
                        byArray = OctetSeqHelper.read(cDRInputStream);
                        String string = cDRInputStream.read_string();
                        OctetSeqHelper.read(cDRInputStream);
                        iIOPServerRequest = new IIOPServerRequest(this.m_server_manager, this, object, n, cDRInputStream, byArray, string, by3, serviceContextArray, new Version(1, by));
                        this.checkConnectionSCs(serviceContextArray);
                        if (this.m_recv_connection_service_contexts == null || this.m_recv_connection_service_contexts[0]) {
                            cDRInputStream.setCodesets(this.m_tcsc, this.m_tcsw);
                        }
                        if (this.addRequest(iIOPServerRequest)) break;
                        return 0;
                    }
                    case 2: {
                        n = cDRInputStream.read_ulong();
                        iIOPServerRequest = new IIOPServerRequest(this.m_server_manager, this, object, n, cDRInputStream, new Version(1, by));
                        iIOPServerRequest.setRequestSource(bufferSource);
                        if (!this.addRequest(iIOPServerRequest)) {
                            return 0;
                        }
                        byte by4 = cDRInputStream.read_octet();
                        cDRInputStream.skip(3L);
                        byArray = this.read_target_address(cDRInputStream.read_short(), cDRInputStream);
                        String string = cDRInputStream.read_string();
                        ServiceContext[] serviceContextArray = ServiceContextListHelper.read(cDRInputStream);
                        try {
                            cDRInputStream.alignment(8);
                        }
                        catch (SystemException systemException) {
                            // empty catch block
                        }
                        if (!this.m_delegated) {
                            this.checkConnectionSCs(serviceContextArray);
                        }
                        if (this.m_recv_connection_service_contexts == null || this.m_recv_connection_service_contexts[0]) {
                            cDRInputStream.setCodesets(this.m_tcsc, this.m_tcsw);
                        }
                        iIOPServerRequest.init(byArray, string, by4, serviceContextArray);
                    }
                }
                bufferSource.removeWaitingForBufferListener(null);
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug(this + " incoming request #" + n);
                }
                this.m_server_manager.enqueue_request(iIOPServerRequest);
                break;
            }
            case 3: {
                switch (by) {
                    case 0: 
                    case 1: {
                        n = cDRInputStream.read_ulong();
                        byArray = OctetSeqHelper.read(cDRInputStream);
                        iIOPServerRequest = new IIOPServerRequest(this.m_server_manager, this, object, n, byArray, new Version(1, by));
                        if (this.addRequest(iIOPServerRequest)) break;
                        return 0;
                    }
                    case 2: {
                        n = cDRInputStream.read_ulong();
                        iIOPServerRequest = new IIOPServerRequest(this.m_server_manager, this, object, n, new Version(1, by));
                        iIOPServerRequest.setRequestSource(bufferSource);
                        if (!this.addRequest(iIOPServerRequest)) {
                            return 0;
                        }
                        byArray = this.read_target_address(cDRInputStream.read_short(), cDRInputStream);
                        iIOPServerRequest.init(byArray);
                    }
                }
                bufferSource.removeWaitingForBufferListener(null);
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug(this + " incoming locate request #" + n);
                }
                this.m_server_manager.enqueue_request(iIOPServerRequest);
                break;
            }
            case 2: {
                n = cDRInputStream.read_ulong();
                Object object2 = this.m_sync_state;
                synchronized (object2) {
                    iIOPServerRequest = (IIOPServerRequest)this.m_active_requests.remove(NumberCache.getInteger(n));
                }
                if (iIOPServerRequest == null) break;
                if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug(this + " request #" + n + " canceled by client");
                }
                iIOPServerRequest.client_cancel();
            }
        }
        return n;
    }

    void process_fragment(int n, StorageBuffer storageBuffer, boolean bl, Object object) {
        IIOPServerRequest iIOPServerRequest;
        Object object2 = this.m_sync_state;
        synchronized (object2) {
            iIOPServerRequest = (IIOPServerRequest)this.m_active_requests.get(NumberCache.getInteger(n));
        }
        if (iIOPServerRequest != null && iIOPServerRequest.checkRequestTransportAssoc(object)) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                if (bl) {
                    this.getLogger().debug(this + " request #" + n + " request fragment");
                } else {
                    this.getLogger().debug(this + " request #" + n + " last request fragment");
                }
            }
            iIOPServerRequest.getRequestSource().addLast(storageBuffer, !bl);
        }
    }

    protected void checkConnectionSCs(ServiceContext[] serviceContextArray) {
        if (this.m_recv_connection_service_contexts == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        while (n2 < serviceContextArray.length) {
            if (serviceContextArray[n2].context_id == 1) {
                bl2 = true;
                n = n2;
                break;
            }
            ++n2;
        }
        while (n < serviceContextArray.length) {
            switch (serviceContextArray[n].context_id) {
                case 1: {
                    if (this.m_recv_connection_service_contexts[0]) break;
                    byte[] byArray = serviceContextArray[n].context_data;
                    if (byArray[0] == 0) {
                        this.m_tcsc = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
                        this.m_tcsw = (byArray[8] & 0xFF) << 24 | (byArray[9] & 0xFF) << 16 | (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
                    } else {
                        this.m_tcsc = (byArray[7] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[5] & 0xFF) << 8 | byArray[4] & 0xFF;
                        this.m_tcsw = (byArray[11] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[9] & 0xFF) << 8 | byArray[8] & 0xFF;
                    }
                    if (this.m_client_peer != null) {
                        this.m_client_peer.setTCSC(this.m_tcsc);
                        this.m_client_peer.setTCSW(this.m_tcsw);
                    }
                    this.m_recv_connection_service_contexts[0] = true;
                    bl = true;
                    break;
                }
                case 5: {
                    if (this.m_recv_connection_service_contexts[1]) break;
                    try {
                        if (this.m_client_protocol != null) {
                            Any any = this.m_codec.decode_value(serviceContextArray[n].context_data, BiDirIIOPServiceContextHelper.type());
                            this.m_pending_bidir_endpoints = BiDirIIOPServiceContextHelper.extract((Any)any).listen_points;
                        }
                        this.m_recv_connection_service_contexts[1] = true;
                        bl = true;
                        break;
                    }
                    catch (UserException userException) {
                        if (!this.getLogger().isErrorEnabled()) break;
                        this.getLogger().error("Unexpected UserException.", userException);
                    }
                }
            }
            if (bl2) {
                n = -1;
                bl2 = false;
            }
            ++n;
        }
        if (bl) {
            int n3 = 0;
            while (n3 < this.m_recv_connection_service_contexts.length) {
                bl = bl && this.m_recv_connection_service_contexts[n3];
                ++n3;
            }
            if (bl) {
                this.m_recv_connection_service_contexts = null;
            }
        }
    }

    public void checkBiDirActivation(IIOPServerRequest iIOPServerRequest) {
        if (this.m_pending_bidir_endpoints != null && this.m_client_peer == null) {
            BidirectionalPolicy bidirectionalPolicy = null;
            try {
                bidirectionalPolicy = BidirectionalPolicyHelper.narrow(iIOPServerRequest.get_server_policy(37));
            }
            catch (INV_POLICY iNV_POLICY) {
                // empty catch block
            }
            if (bidirectionalPolicy != null && bidirectionalPolicy.value() == 1) {
                Object object = this.m_sync_state;
                synchronized (object) {
                    if (this.m_state == 0 && this.m_client_peer == null) {
                        this.m_client_peer = this.m_client_protocol.createBidirDelegate(this, this.m_pending_bidir_endpoints);
                        this.m_pending_bidir_endpoints = null;
                        if (this.m_client_peer != null && this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                            this.getLogger().debug(this + " became bidirectional with peer " + this.m_client_peer.toString());
                        }
                    }
                }
            }
        }
    }

    private boolean addRequest(IIOPServerRequest iIOPServerRequest) {
        Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 1 || this.m_pending_close) {
                boolean bl = false;
                return bl;
            }
            this.m_active_requests.put(NumberCache.getInteger(iIOPServerRequest.request_id()), iIOPServerRequest);
        }
        return true;
    }

    private byte[] read_target_address(short s, CDRInputStream cDRInputStream) {
        byte[] byArray = null;
        switch (s) {
            case 0: {
                byArray = OctetSeqHelper.read(cDRInputStream);
                break;
            }
            case 1: {
                if (cDRInputStream.read_ulong() != 0) {
                    return null;
                }
                cDRInputStream.begin_encapsulation();
                cDRInputStream.skip(2L);
                cDRInputStream.skip(cDRInputStream.read_long());
                cDRInputStream.skip(2L);
                byArray = OctetSeqHelper.read(cDRInputStream);
                cDRInputStream.end_encapsulation();
                break;
            }
            case 2: {
                int n = cDRInputStream.read_ulong();
                int n2 = cDRInputStream.read_ulong();
                int n3 = 0;
                while (n3 < n2) {
                    if (n3 == n) {
                        byArray = this.read_target_address((short)1, cDRInputStream);
                    } else {
                        cDRInputStream.skip(4L);
                        cDRInputStream.skip(cDRInputStream.read_ulong());
                    }
                    ++n3;
                }
                break;
            }
        }
        return byArray;
    }

    CDROutputStream create_reply_stream(IIOPServerRequest iIOPServerRequest, int n) {
        CDROutputStream cDROutputStream;
        if (!this.m_socket_queue.isOpen()) {
            throw new COMM_FAILURE("Client has shutdown", 1146056968, CompletionStatus.COMPLETED_YES);
        }
        Version version = iIOPServerRequest.version();
        int n2 = iIOPServerRequest.request_id();
        ServiceContext[] serviceContextArray = iIOPServerRequest.get_reply_service_contexts();
        MarshalBuffer marshalBuffer = new MarshalBuffer(this.m_marshal_listener, iIOPServerRequest);
        try {
            cDROutputStream = (CDROutputStream)this.m_os_ctor.newInstance(this.m_orb, version, marshalBuffer);
        }
        catch (Exception exception) {
            this.getLogger().error("Unable to create CDROutputStream class.", exception);
            throw ExceptionTool.initCause(new INITIALIZE("Unable to create CDROutputStream class (" + exception + ")"), (Throwable)exception);
        }
        if (this.m_recv_connection_service_contexts == null || this.m_recv_connection_service_contexts[0]) {
            cDROutputStream.setCodesets(this.m_tcsc, this.m_tcsw);
        }
        new HeaderBlock(1, n2, cDROutputStream);
        switch (version.minor) {
            case 0: 
            case 1: {
                ServiceContextListHelper.write(cDROutputStream, serviceContextArray);
                cDROutputStream.write_ulong(n2);
                cDROutputStream.write_ulong(n);
                break;
            }
            case 2: {
                cDROutputStream.write_ulong(n2);
                cDROutputStream.allowFragment();
                cDROutputStream.write_ulong(n);
                ServiceContextListHelper.write(cDROutputStream, serviceContextArray);
                cDROutputStream.pending_alignment(8);
            }
        }
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug(this + " request #" + n2 + " reply stream created. Reply status: " + n);
        }
        return cDROutputStream;
    }

    CDROutputStream create_locate_reply_stream(IIOPServerRequest iIOPServerRequest, int n) {
        CDROutputStream cDROutputStream;
        if (!this.m_socket_queue.isOpen()) {
            throw new COMM_FAILURE("Client has shutdown", 1146056968, CompletionStatus.COMPLETED_YES);
        }
        Version version = iIOPServerRequest.version();
        int n2 = iIOPServerRequest.request_id();
        MarshalBuffer marshalBuffer = new MarshalBuffer(this.m_marshal_listener, iIOPServerRequest);
        try {
            cDROutputStream = (CDROutputStream)this.m_os_ctor.newInstance(this.m_orb, version, marshalBuffer);
        }
        catch (Exception exception) {
            this.getLogger().error("Unable to create CDROutputStream class.", exception);
            throw ExceptionTool.initCause(new INITIALIZE("Unable to create CDROutputStream class (" + exception + ")"), (Throwable)exception);
        }
        new HeaderBlock(4, n2, cDROutputStream);
        cDROutputStream.write_ulong(n2);
        if (version.minor == 2) {
            cDROutputStream.allowFragment();
        }
        cDROutputStream.write_ulong(n);
        if (version.minor == 2) {
            cDROutputStream.pending_alignment(8);
        }
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug(this + " request #" + n2 + " locate reply stream created. Reply status: " + n);
        }
        return cDROutputStream;
    }

    void release_request(IIOPServerRequest iIOPServerRequest) {
        Object object = this.m_sync_state;
        synchronized (object) {
            int n = iIOPServerRequest.request_id();
            this.m_active_requests.remove(NumberCache.getInteger(n));
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug(this + " request #" + n + " completed");
            }
            if (!this.m_active_requests.isEmpty()) {
                return;
            }
            this.m_channel_age = RequestIDAllocator.peek_request_id();
        }
        if (this.m_pending_close) {
            this.soft_close(true);
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MarshalListener
    implements MarshalBuffer.Listener {
        private MarshalListener() {
        }

        public void availIncreaced(MarshalBuffer marshalBuffer, int n, Object object) {
            if (n > 120000) {
                IIOPServerRequest iIOPServerRequest = (IIOPServerRequest)object;
                if (!IIOPServerChannel.this.m_socket_queue.send(marshalBuffer.fragment(120000), iIOPServerRequest.get_transport_association())) {
                    throw new COMM_FAILURE("Client has shutdown", 1146056968, CompletionStatus.COMPLETED_YES);
                }
                if (IIOPServerChannel.this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    IIOPServerChannel.this.getLogger().debug(IIOPServerChannel.this + "request #" + iIOPServerRequest.request_id() + " last fragment sent");
                }
            }
        }

        public void bufferClosed(MarshalBuffer marshalBuffer, int n, Object object) {
            StorageBuffer storageBuffer = marshalBuffer.lastFragment();
            IIOPServerRequest iIOPServerRequest = (IIOPServerRequest)object;
            if (!IIOPServerChannel.this.m_socket_queue.send(storageBuffer, iIOPServerRequest.get_transport_association())) {
                throw new COMM_FAILURE("Client has shutdown", 1146056968, CompletionStatus.COMPLETED_YES);
            }
            if (IIOPServerChannel.this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                IIOPServerChannel.this.getLogger().debug(IIOPServerChannel.this + " request #" + iIOPServerRequest.request_id() + " last fragment sent");
            }
        }

        public void bufferCanceled(MarshalBuffer marshalBuffer, SystemException systemException, Object object) {
            systemException.completed = CompletionStatus.COMPLETED_YES;
            throw systemException;
        }
    }
}

