/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;
import org.openorb.CORBA.Any;
import org.openorb.CORBA.DataOutputStream;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.typecode.TypeCodeBase;
import org.openorb.iiop.CodeSetDatabase;
import org.openorb.io.ExtendedOutputStream;
import org.openorb.io.MarshalBuffer;
import org.openorb.util.ExceptionTool;
import org.openorb.util.IdentityKey;
import org.openorb.util.NumberCache;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

public class CDROutputStream
extends OutputStream
implements ExtendedOutputStream,
LogEnabled {
    private static final int NO_CODEBASE = 0;
    private static final int CODEBASE = 1;
    private static final int NO_TYPE_INFORMATION = 0;
    private static final int SINGLE_TYPE_INFORMATION = 2;
    private static final int MULTIPLE_TYPE_INFORMATION = 6;
    private static final int CHUNK = 8;
    private static final int NO_CHUNK = 0;
    private static final int CUSTOM_MARSHAL = 1;
    private static final int STREAM_MARSHAL = 2;
    private static final int VALBOX_MARSHAL = 3;
    private static final int EXTENDED_MARSHAL = 4;
    private org.omg.CORBA.ORB m_orb;
    private Version m_version;
    private MarshalBuffer m_buf;
    private String m_char_enc = "ISO-8859-1";
    private String m_wchar_enc = "UnicodeBigUnmarked";
    private int m_wchar_align = 2;
    private int m_index = 0;
    private int m_pending_align = 0;
    private int m_realign = 0;
    private LinkedList m_old_realign;
    private int m_value_level = 0;
    private boolean m_in_chunked_value = false;
    private boolean m_value_init = false;
    private Map m_value_idx;
    private Map m_url_idx;
    private Map m_typecode_list_idx;
    private Map m_typecode_idx;
    private int m_pending_value_closes = 0;
    private boolean m_pending_value_open = false;
    private OctetSeqHolder m_tmp_buf = new OctetSeqHolder();
    private IntHolder m_tmp_off = new IntHolder();
    private String m_system_urls = null;
    private Logger m_logger;
    private static final MarshalBuffer.BlockGenerator ENCAPS_GEN = new MarshalBuffer.BlockGenerator(){

        public void endBlock(byte[] byArray, int n, int n2, int n3, java.lang.Object object) {
            byArray[n] = (byte)((n3 -= 4) >>> 24);
            byArray[n + 1] = (byte)(n3 >>> 16);
            byArray[n + 2] = (byte)(n3 >>> 8);
            byArray[n + 3] = (byte)n3;
        }

        public void fragmentBlock(byte[] byArray, int n, int n2, int n3, MarshalBuffer marshalBuffer, java.lang.Object object) {
            Trace.signalIllegalCondition(null, "Unable to fragment encapsulation.");
        }
    };
    private static final MarshalBuffer.BlockGenerator CHUNK_GEN = new MarshalBuffer.BlockGenerator(){

        public void endBlock(byte[] byArray, int n, int n2, int n3, java.lang.Object object) {
            if ((n3 -= 4) <= 0) {
                Trace.signalIllegalCondition(null, "No bytes left in block.");
            }
            byArray[n] = (byte)(n3 >>> 24);
            byArray[n + 1] = (byte)(n3 >>> 16);
            byArray[n + 2] = (byte)(n3 >>> 8);
            byArray[n + 3] = (byte)n3;
        }

        public void fragmentBlock(byte[] byArray, int n, int n2, int n3, MarshalBuffer marshalBuffer, java.lang.Object object) {
            if ((n3 -= 4) <= 0) {
                Trace.signalIllegalCondition(null, "No bytes left in block.");
            }
            byArray[n] = (byte)(n3 >>> 24);
            byArray[n + 1] = (byte)(n3 >>> 16);
            byArray[n + 2] = (byte)(n3 >>> 8);
            byArray[n + 3] = (byte)n3;
            ((CDROutputStream)object).m_pending_value_open = true;
        }
    };
    private static final IOR NULL_IOR = new IOR("", new TaggedProfile[0]);

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }

    public CDROutputStream(org.omg.CORBA.ORB oRB, Version version, MarshalBuffer marshalBuffer) {
        this.m_orb = oRB;
        this.m_version = version;
        this.m_buf = marshalBuffer;
        if (this.m_version.minor == 0) {
            this.m_char_enc = "ISO-8859-1";
            this.m_wchar_enc = null;
        }
    }

    public void setCodesets(int n, int n2) {
        if (n != 0) {
            this.m_char_enc = CodeSetDatabase.getNameFromId(n);
            if (this.m_char_enc == null || CodeSetDatabase.getAlignmentFromId(n) > 1) {
                this.m_buf.cancel(new CODESET_INCOMPATIBLE());
                return;
            }
        }
        if (n2 == 0) {
            this.m_wchar_enc = null;
        } else {
            this.m_wchar_enc = CodeSetDatabase.getNameFromId(n2);
            this.m_wchar_align = CodeSetDatabase.getAlignmentFromId(n2);
            if (this.m_wchar_enc == null || this.m_version.minor == 1 && this.m_wchar_align != 2) {
                this.m_buf.cancel(new CODESET_INCOMPATIBLE());
                return;
            }
        }
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug("New encodings for output stream set to [" + this.m_char_enc + "] and [" + this.m_wchar_enc + "].");
        }
    }

    void addHeader(MarshalBuffer.HeaderGenerator headerGenerator, int n, boolean bl, java.lang.Object object) {
        this.m_buf.addHeader(headerGenerator, n, bl, object);
        this.m_index += n;
    }

    void allowFragment() {
        this.m_buf.setAllowFragment(true);
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public Version version() {
        return this.m_version;
    }

    public void alignment(int n) {
        if (this.m_pending_value_closes > 0) {
            this.value_end_block();
            if (this.m_in_chunked_value) {
                this.m_pending_value_open = true;
            }
        }
        if (this.m_pending_value_open) {
            this.m_pending_value_open = false;
            this.value_begin_block();
        }
        if (n > 1 || this.m_pending_align > 0) {
            int n2;
            if (n < this.m_pending_align) {
                n = this.m_pending_align;
                this.m_pending_align = 0;
            }
            if ((n2 = (this.m_index - this.m_realign) % n) != 0) {
                int n3 = n - n2;
                this.m_buf.pad(n3);
                this.m_index += n3;
            }
        }
    }

    public void pending_alignment(int n) {
        this.m_pending_align = n;
    }

    public int index() {
        return this.m_index;
    }

    public void begin_encapsulation() {
        this.alignment(4);
        this.m_buf.beginBlock(ENCAPS_GEN, 4, false, null);
        this.m_index += 4;
        if (this.m_old_realign == null) {
            this.m_old_realign = new LinkedList();
        }
        this.m_old_realign.addLast(NumberCache.getInteger(this.m_realign));
        this.m_realign = (this.m_index - this.m_realign) % 8;
        this.write_boolean(false);
    }

    public void end_encapsulation() {
        if (this.m_old_realign == null || this.m_old_realign.isEmpty()) {
            throw new IllegalStateException("No current encapsulation");
        }
        this.m_buf.endBlock();
        this.m_realign = (Integer)this.m_old_realign.removeLast();
    }

    public void write(int n) {
        this.write_octet((byte)n);
    }

    public void write(byte[] byArray) {
        this.write_octet_array(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.write_octet_array(byArray, n, n2);
    }

    public void close() {
        if (this.m_old_realign != null && !this.m_old_realign.isEmpty()) {
            this.m_buf.cancel(new MARSHAL("closed stream without closing all encapsulation layers", 1146056982, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        if (this.m_value_level - this.m_pending_value_closes > 0) {
            this.m_buf.cancel(new MARSHAL("closed stream before value completley marshalled", 1146056981, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        if (this.m_pending_value_closes > 0) {
            this.value_end_block();
        }
        this.m_buf.close();
    }

    public void flush() {
    }

    public InputStream create_input_stream() {
        this.m_buf.cancel(new NO_IMPLEMENT());
        throw new NO_IMPLEMENT();
    }

    void cancel(SystemException systemException) {
        this.m_buf.cancel(systemException);
    }

    public void write_boolean(boolean bl) {
        this.alignment(1);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, 1);
        ++this.m_index;
        this.m_tmp_buf.value[this.m_tmp_off.value] = bl ? (byte)1 : 0;
    }

    public void write_octet(byte by) {
        this.alignment(1);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, 1);
        ++this.m_index;
        this.m_tmp_buf.value[this.m_tmp_off.value] = by;
    }

    public void write_char(char c) {
        try {
            byte[] byArray = String.valueOf(c).getBytes(this.m_char_enc);
            if (byArray.length != 1) {
                this.m_buf.cancel(new DATA_CONVERSION("Bad char type", 1330446337, CompletionStatus.COMPLETED_MAYBE));
            }
            this.alignment(1);
            this.m_buf.append(byArray, 0, 1);
            ++this.m_index;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
        }
    }

    public void write_wchar(char c) {
        if (this.m_wchar_enc == null) {
            if (this.m_version.minor == 0) {
                this.m_buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.m_buf.cancel(new INV_OBJREF("Missing wchar encoder.", 1146056975, CompletionStatus.COMPLETED_MAYBE));
            }
            return;
        }
        try {
            switch (this.m_version.minor) {
                case 0: {
                    this.m_buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                    break;
                }
                case 1: {
                    this.alignment(2);
                    byte[] byArray = String.valueOf(c).getBytes(this.m_wchar_enc);
                    if (byArray.length != 2) {
                        this.m_buf.cancel(new DATA_CONVERSION("Bad wchar type", 1146056977, CompletionStatus.COMPLETED_MAYBE));
                    }
                    this.m_buf.append(byArray, 0, 2);
                    this.m_index += 2;
                    break;
                }
                case 2: {
                    this.alignment(1);
                    byte[] byArray = String.valueOf(c).getBytes(this.m_wchar_enc);
                    this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, byArray.length + 1);
                    this.m_index += byArray.length + 1;
                    this.m_tmp_buf.value[this.m_tmp_off.value] = (byte)byArray.length;
                    System.arraycopy(byArray, 0, this.m_tmp_buf.value, this.m_tmp_off.value + 1, byArray.length);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
        }
    }

    public void write_short(short s) {
        this.alignment(2);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, 2);
        this.m_index += 2;
        this.m_tmp_buf.value[this.m_tmp_off.value] = (byte)(s >>> 8);
        this.m_tmp_buf.value[this.m_tmp_off.value + 1] = (byte)s;
    }

    public void write_ushort(short s) {
        this.write_short(s);
    }

    public void write_long(int n) {
        this.alignment(4);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, 4);
        this.m_index += 4;
        this.m_tmp_buf.value[this.m_tmp_off.value] = (byte)(n >>> 24);
        this.m_tmp_buf.value[this.m_tmp_off.value + 1] = (byte)(n >>> 16);
        this.m_tmp_buf.value[this.m_tmp_off.value + 2] = (byte)(n >>> 8);
        this.m_tmp_buf.value[this.m_tmp_off.value + 3] = (byte)n;
    }

    public void write_ulong(int n) {
        this.write_long(n);
    }

    public void write_longlong(long l) {
        this.alignment(8);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, 8);
        this.m_index += 8;
        this.m_tmp_buf.value[this.m_tmp_off.value] = (byte)(l >>> 56);
        this.m_tmp_buf.value[this.m_tmp_off.value + 1] = (byte)(l >>> 48);
        this.m_tmp_buf.value[this.m_tmp_off.value + 2] = (byte)(l >>> 40);
        this.m_tmp_buf.value[this.m_tmp_off.value + 3] = (byte)(l >>> 32);
        this.m_tmp_buf.value[this.m_tmp_off.value + 4] = (byte)(l >>> 24);
        this.m_tmp_buf.value[this.m_tmp_off.value + 5] = (byte)(l >>> 16);
        this.m_tmp_buf.value[this.m_tmp_off.value + 6] = (byte)(l >>> 8);
        this.m_tmp_buf.value[this.m_tmp_off.value + 7] = (byte)l;
    }

    public void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public void write_string(String string) {
        if (string == null) {
            this.m_buf.cancel(new BAD_PARAM("Cannot marshal null string", 1146056965, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        if (string.length() == 0) {
            this.write_ulong(1);
            this.write_octet((byte)0);
            return;
        }
        try {
            byte[] byArray = (string + '\u0000').getBytes(this.m_char_enc);
            this.write_ulong(byArray.length);
            this.m_buf.append(byArray, 0, byArray.length);
            this.m_index += byArray.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
        }
    }

    public void write_wstring(String string) {
        if (string == null) {
            this.m_buf.cancel(new BAD_PARAM("Cannot marshal null wstring", 1146056965, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        if (this.m_wchar_enc == null) {
            if (this.m_version.minor == 0) {
                this.m_buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.m_buf.cancel(new INV_OBJREF("Missing wchar encoder.", 1146056975, CompletionStatus.COMPLETED_MAYBE));
            }
            return;
        }
        try {
            byte[] byArray = null;
            switch (this.m_version.minor) {
                case 0: {
                    this.m_buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
                case 1: {
                    byArray = (string + '\u0000').getBytes(this.m_wchar_enc);
                    this.write_ulong(byArray.length / 2);
                    break;
                }
                case 2: {
                    byArray = string.getBytes(this.m_wchar_enc);
                    this.write_ulong(byArray.length);
                }
            }
            this.m_buf.append(byArray, 0, byArray.length);
            this.m_index += byArray.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
        }
    }

    public void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (n + n2 > blArray.length || n2 < 0 || n < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(1);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, n2);
        this.m_index += n2;
        int n3 = 0;
        while (n3 < n2) {
            this.m_tmp_buf.value[this.m_tmp_off.value + n3] = blArray[n + n3] ? (byte)1 : 0;
            ++n3;
        }
    }

    public void write_char_array(char[] cArray, int n, int n2) {
        if (n + n2 > cArray.length || n2 < 0 || n < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(1);
        try {
            byte[] byArray = new String(cArray, n, n2).getBytes(this.m_char_enc);
            if (byArray.length != n2) {
                this.m_buf.cancel(new DATA_CONVERSION("Bad char type", 1330446337, CompletionStatus.COMPLETED_MAYBE));
            }
            this.m_buf.append(byArray, 0, n2);
            this.m_index += n2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
        }
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        if (n + n2 > cArray.length || n2 < 0 || n < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        if (this.m_wchar_enc == null) {
            if (this.m_version.minor == 0) {
                this.m_buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.m_buf.cancel(new INV_OBJREF("Missing wchar encoder.", 1146056975, CompletionStatus.COMPLETED_MAYBE));
            }
            return;
        }
        try {
            switch (this.m_version.minor) {
                case 0: {
                    this.m_buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
                case 1: {
                    this.alignment(2);
                    byte[] byArray = new String(cArray, n, n2).getBytes(this.m_wchar_enc);
                    if (byArray.length != 2 * n2) {
                        this.m_buf.cancel(new DATA_CONVERSION("Bad whar type", 1146056977, CompletionStatus.COMPLETED_MAYBE));
                    }
                    this.m_buf.append(byArray, 0, byArray.length);
                    this.m_index += byArray.length;
                    break;
                }
                case 2: {
                    this.alignment(1);
                    if (this.m_wchar_align == 0) {
                        int n3 = n;
                        while (n3 < n + n2) {
                            byte[] byArray = String.valueOf(cArray[n3]).getBytes(this.m_wchar_enc);
                            this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, byArray.length + 1);
                            this.m_index += byArray.length + 1;
                            if (this.m_tmp_buf != null) {
                                this.m_tmp_buf.value[this.m_tmp_off.value] = (byte)byArray.length;
                                System.arraycopy(byArray, 0, this.m_tmp_buf.value, this.m_tmp_off.value + 1, byArray.length);
                            }
                            ++n3;
                        }
                        break;
                    }
                    this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, n2 + n2 * this.m_wchar_align);
                    int n4 = this.m_tmp_off.value;
                    int n5 = n;
                    while (n5 < n + n2) {
                        byte[] byArray = String.valueOf(cArray[n5]).getBytes(this.m_wchar_enc);
                        if (this.m_tmp_buf != null) {
                            this.m_tmp_buf.value[n4] = (byte)this.m_wchar_align;
                            System.arraycopy(byArray, 0, this.m_tmp_buf.value, n4 + 1, byArray.length);
                        }
                        n4 += this.m_wchar_align + 1;
                        ++n5;
                    }
                    this.m_index += n2 + n2 * this.m_wchar_align;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.getLogger().error("Unsupported encoding should be impossible.", unsupportedEncodingException);
        }
    }

    public void write_octet_array(byte[] byArray, int n, int n2) {
        if (n + n2 > byArray.length || n2 < 0 || n < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(1);
        this.m_buf.append(byArray, n, n2);
        this.m_index += n2;
    }

    public void write_short_array(short[] sArray, int n, int n2) {
        if (n + n2 > sArray.length || n2 < 0 || n < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(2);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, n2 * 2);
        this.m_index += n2 * 2;
        int n3 = 0;
        while (n3 < n2) {
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 2] = (byte)(sArray[n + n3] >>> 8);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 2 + 1] = (byte)sArray[n + n3];
            ++n3;
        }
    }

    public void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public void write_long_array(int[] nArray, int n, int n2) {
        if (n + n2 > nArray.length || n2 < 0 || n < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(4);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, n2 * 4);
        this.m_index += n2 * 4;
        int n3 = 0;
        while (n3 < n2) {
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 4] = (byte)(nArray[n + n3] >>> 24);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 4 + 1] = (byte)(nArray[n + n3] >>> 16);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 4 + 2] = (byte)(nArray[n + n3] >>> 8);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 4 + 3] = (byte)nArray[n + n3];
            ++n3;
        }
    }

    public void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public void write_longlong_array(long[] lArray, int n, int n2) {
        if (n + n2 > lArray.length || n2 < 0 || n < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(8);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, n2 * 8);
        this.m_index += n2 * 8;
        int n3 = 0;
        while (n3 < n2) {
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8] = (byte)(lArray[n + n3] >>> 56);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 1] = (byte)(lArray[n + n3] >>> 48);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 2] = (byte)(lArray[n + n3] >>> 40);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 3] = (byte)(lArray[n + n3] >>> 32);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 4] = (byte)(lArray[n + n3] >>> 24);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 5] = (byte)(lArray[n + n3] >>> 16);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 6] = (byte)(lArray[n + n3] >>> 8);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 7] = (byte)lArray[n + n3];
            ++n3;
        }
    }

    public void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public void write_float_array(float[] fArray, int n, int n2) {
        if (n + n2 > fArray.length || n2 < 0 || n < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(4);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, n2 * 4);
        this.m_index += n2 * 4;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Float.floatToIntBits(fArray[n + n3]);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 4] = (byte)(n4 >>> 24);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 4 + 1] = (byte)(n4 >>> 16);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 4 + 2] = (byte)(n4 >>> 8);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 4 + 3] = (byte)n4;
            ++n3;
        }
    }

    public void write_double_array(double[] dArray, int n, int n2) {
        if (n + n2 > dArray.length || n2 < 0 || n < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(8);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, n2 * 8);
        this.m_index += n2 * 8;
        int n3 = 0;
        while (n3 < n2) {
            long l = Double.doubleToLongBits(dArray[n + n3]);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8] = (byte)(l >>> 56);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 1] = (byte)(l >>> 48);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 2] = (byte)(l >>> 40);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 3] = (byte)(l >>> 32);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 4] = (byte)(l >>> 24);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 5] = (byte)(l >>> 16);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 6] = (byte)(l >>> 8);
            this.m_tmp_buf.value[this.m_tmp_off.value + n3 * 8 + 7] = (byte)l;
            ++n3;
        }
    }

    public void write_Object(Object object) {
        IOR iOR;
        if (object == null) {
            iOR = NULL_IOR;
        } else {
            try {
                iOR = ((Delegate)((ObjectImpl)object)._get_delegate()).ior();
            }
            catch (SystemException systemException) {
                this.m_buf.cancel(systemException);
                return;
            }
        }
        IORHelper.write(this, iOR);
    }

    public void write_TypeCode(TypeCode typeCode) {
        this.write_TypeCodeValue(typeCode, new HashMap());
    }

    private void write_TypeCodeValue(TypeCode typeCode, Map map) {
        int n = typeCode.kind().value();
        try {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    this.write_long(n);
                    return;
                }
                case 18: 
                case 27: {
                    this.write_long(n);
                    this.write_ulong(typeCode.length());
                    return;
                }
                case 28: {
                    this.write_long(n);
                    this.write_ushort(typeCode.fixed_digits());
                    this.write_ushort(typeCode.fixed_scale());
                    return;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    break;
                }
                default: {
                    throw new MARSHAL("Unknown type kind", 0, CompletionStatus.COMPLETED_NO);
                }
            }
            Integer n2 = (Integer)map.get(typeCode);
            if (n2 != null) {
                this.write_long(-1);
                this.write_long(n2 - this.m_index);
                return;
            }
            this.alignment(4);
            n2 = NumberCache.getInteger(this.m_index);
            map.put(typeCode, n2);
            this.write_long(n);
            this.begin_encapsulation();
            switch (n) {
                case 19: 
                case 20: {
                    this.write_TypeCodeValue(typeCode.content_type(), map);
                    this.write_ulong(typeCode.length());
                    break;
                }
                case 14: 
                case 31: 
                case 32: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    break;
                }
                case 15: 
                case 22: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_ulong(typeCode.member_count());
                    int n3 = 0;
                    while (n3 < typeCode.member_count()) {
                        this.write_string(typeCode.member_name(n3));
                        this.write_TypeCodeValue(typeCode.member_type(n3), map);
                        ++n3;
                    }
                    break;
                }
                case 16: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_TypeCodeValue(typeCode.discriminator_type(), map);
                    this.write_long(typeCode.default_index());
                    this.write_ulong(typeCode.member_count());
                    int n4 = 0;
                    while (n4 < typeCode.member_count()) {
                        if (n4 != typeCode.default_index()) {
                            ((Any)typeCode.member_label(n4)).write_value(this);
                        } else {
                            TypeCode typeCode2 = TypeCodeBase._base_type(typeCode.discriminator_type());
                            switch (typeCode2.kind().value()) {
                                case 2: {
                                    this.write_short((short)0);
                                    break;
                                }
                                case 4: {
                                    this.write_ushort((short)0);
                                    break;
                                }
                                case 3: {
                                    this.write_long(0);
                                    break;
                                }
                                case 5: {
                                    this.write_ulong(0);
                                    break;
                                }
                                case 8: {
                                    this.write_boolean(false);
                                    break;
                                }
                                case 9: {
                                    this.write_char('\u0000');
                                    break;
                                }
                                case 17: {
                                    this.write_ulong(0);
                                    break;
                                }
                                default: {
                                    throw new MARSHAL("Unknown type kind");
                                }
                            }
                        }
                        this.write_string(typeCode.member_name(n4));
                        this.write_TypeCodeValue(typeCode.member_type(n4), map);
                        ++n4;
                    }
                    break;
                }
                case 17: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_ulong(typeCode.member_count());
                    int n5 = 0;
                    while (n5 < typeCode.member_count()) {
                        this.write_string(typeCode.member_name(n5));
                        ++n5;
                    }
                    break;
                }
                case 21: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_TypeCodeValue(typeCode.content_type(), map);
                    break;
                }
                case 29: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_short(typeCode.type_modifier());
                    this.write_TypeCodeValue(typeCode.concrete_base_type(), map);
                    this.write_ulong(typeCode.member_count());
                    int n6 = 0;
                    while (n6 < typeCode.member_count()) {
                        this.write_string(typeCode.member_name(n6));
                        this.write_TypeCodeValue(typeCode.member_type(n6), map);
                        this.write_short(typeCode.member_visibility(n6));
                        ++n6;
                    }
                    break;
                }
                case 30: {
                    this.write_string(typeCode.id());
                    this.write_string(typeCode.name());
                    this.write_TypeCodeValue(typeCode.content_type(), map);
                }
            }
            this.end_encapsulation();
        }
        catch (BadKind badKind) {
            this.getLogger().error("BadKind during marshal.", badKind);
            throw ExceptionTool.initCause(new MARSHAL("BadKind during marshal (" + badKind + ")", 0, CompletionStatus.COMPLETED_NO), (Throwable)badKind);
        }
        catch (Bounds bounds) {
            this.getLogger().error("Bounds during marshal.", bounds);
            throw ExceptionTool.initCause(new MARSHAL("Bounds during marshal (" + bounds + ")", 0, CompletionStatus.COMPLETED_NO), (Throwable)bounds);
        }
    }

    public void write_any(org.omg.CORBA.Any any) {
        this.write_TypeCode(any.type());
        any.write_value(this);
    }

    public void write_Principal(Principal principal) {
        byte[] byArray = principal.name();
        this.write_ulong(byArray.length);
        this.write_octet_array(byArray, 0, byArray.length);
    }

    public void write_fixed(BigDecimal bigDecimal) {
        this.write_fixed(bigDecimal, (short)-1, (short)-1);
    }

    public void write_fixed(BigDecimal bigDecimal, TypeCode typeCode) {
        try {
            this.write_fixed(bigDecimal, typeCode.fixed_digits(), typeCode.fixed_scale());
        }
        catch (BadKind badKind) {
            this.m_buf.cancel(ExceptionTool.initCause(new BAD_PARAM("Typecode is not a fixed typecode", 1146056963, CompletionStatus.COMPLETED_NO), (Throwable)badKind));
        }
    }

    public void write_fixed(BigDecimal bigDecimal, short s, short s2) {
        String string = bigDecimal.abs().movePointRight(bigDecimal.scale()).toString();
        if (s2 >= 0) {
            int n = s2 - bigDecimal.scale();
            if (n < 0) {
                string = string.substring(0, string.length() + n);
                n = 0;
            } else if (n > 0) {
                StringBuffer stringBuffer = new StringBuffer(string);
                while (n-- > 0) {
                    stringBuffer.append('0');
                }
                string = stringBuffer.toString();
            }
        }
        if (s >= 0 && string.length() > s) {
            this.m_buf.cancel(new MARSHAL("value too large for type", 1146056980, CompletionStatus.COMPLETED_NO));
            return;
        }
        byte[] byArray = new byte[string.length() / 2 + 1];
        int n = 0;
        int n2 = 0;
        if (string.length() % 2 == 0) {
            byArray[n++] = (byte)(string.charAt(n2++) - 48);
        }
        while (n < byArray.length - 1) {
            byArray[n++] = (byte)(string.charAt(n2++) - 48 << 4 | string.charAt(n2++) - 48);
        }
        byArray[n] = (byte)(string.charAt(n2) - 48 << 4 | (bigDecimal.signum() < 0 ? 13 : 12));
        this.write_octet_array(byArray, 0, byArray.length);
    }

    public void write_Context(Context context, ContextList contextList) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < contextList.count()) {
            try {
                NVList nVList = context.get_values("", 0, contextList.item(n));
                int n2 = 0;
                while (n2 < nVList.count()) {
                    vector.addElement(nVList.item(n2).name());
                    vector.addElement(nVList.item(n2).value().extract_string());
                    ++n2;
                }
            }
            catch (org.omg.CORBA.Bounds bounds) {
                // empty catch block
            }
            ++n;
        }
        if (vector.size() != 0) {
            this.write_ulong(vector.size());
            int n3 = 0;
            while (n3 < vector.size()) {
                this.write_string((String)vector.elementAt(n3));
                ++n3;
            }
        } else if (contextList.count() != 0) {
            this.write_ulong(0);
        }
    }

    public void write_value(Serializable serializable) {
        this.write_value(serializable, null, null);
    }

    public void write_value(Serializable serializable, String string) {
        this.write_value(serializable, string, null);
    }

    public void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable, null, null);
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        this.write_value(serializable, null, boxedValueHelper);
    }

    private void value_begin_block() {
        this.alignment(4);
        this.m_buf.beginBlock(CHUNK_GEN, 4, true, this);
        this.m_index += 4;
    }

    private void value_end_block() {
        if (!this.m_pending_value_open) {
            this.m_buf.endBlock();
        }
        this.m_value_level -= this.m_pending_value_closes;
        this.m_pending_value_closes = 0;
        this.write_long(-(this.m_value_level + 1));
    }

    /*
     * Unable to fully structure code
     */
    private void write_value(Serializable var1_1, String var2_2, BoxedValueHelper var3_3) {
        block49: {
            if (this.m_pending_value_closes > 0) {
                this.value_end_block();
                if (this.m_in_chunked_value) {
                    this.m_pending_value_open = true;
                }
            }
            if (var1_1 == null) {
                this.write_long(0);
                return;
            }
            if (!this.m_value_init) {
                this.m_value_init = true;
                this.m_value_idx = new HashMap<K, V>();
                this.m_url_idx = new HashMap<K, V>();
                this.m_typecode_list_idx = new HashMap<K, V>();
                this.m_typecode_idx = new HashMap<K, V>();
            }
            var4_4 = null;
            var5_5 = this.value_extended_replace(var1_1);
            if (var5_5 != var1_1) {
                var4_4 = var1_1;
                var1_1 = var5_5;
            }
            if ((var6_6 = (Integer)this.m_value_idx.get(new IdentityKey(var1_1))) != null) {
                this.write_long(-1);
                this.write_long(var6_6 - this.m_index);
                return;
            }
            this.m_pending_value_open = false;
            var6_7 = 0x7FFFFF00;
            var7_8 = null;
            var8_9 = 0;
            if (var3_3 != null) {
                var8_9 = 3;
                var7_8 = new String[]{var3_3.get_id()};
            } else if (var1_1 instanceof StreamableValue) {
                var8_9 = 2;
                var7_8 = ((ValueBase)var1_1)._truncatable_ids();
            } else if (var1_1 instanceof CustomValue) {
                var8_9 = 1;
                var7_8 = ((ValueBase)var1_1)._truncatable_ids();
            } else if (var1_1 instanceof ValueBase) {
                var8_9 = 3;
                var7_8 = ((ValueBase)var1_1)._truncatable_ids();
                var9_10 = RepoIDHelper.idToClass(var7_8[0], 2);
                try {
                    var3_3 = (BoxedValueHelper)Thread.currentThread().getContextClassLoader().loadClass(var9_10).newInstance();
                }
                catch (Exception var10_12) {
                    this.m_buf.cancel(ExceptionTool.initCause(new MARSHAL("Unable to load boxed value helper", 1146056981, CompletionStatus.COMPLETED_MAYBE), (Throwable)var10_12));
                    return;
                }
            } else if (var1_1.getClass().isArray() && var2_2 != null && var2_2.startsWith("IDL:")) {
                var8_9 = 3;
                var9_10 = RepoIDHelper.idToClass(var2_2, 2);
                try {
                    var3_3 = (BoxedValueHelper)Thread.currentThread().getContextClassLoader().loadClass(var9_10).newInstance();
                }
                catch (Exception var10_13) {
                    this.m_buf.cancel(ExceptionTool.initCause(new MARSHAL("Unable to load boxed value helper", 1146056981, CompletionStatus.COMPLETED_MAYBE), (Throwable)var10_13));
                }
            } else {
                var8_9 = 4;
                var7_8 = this.value_extended_get_IDs(var1_1);
                if (var7_8 == null) {
                    this.m_buf.cancel(new BAD_PARAM("Unable to find IDs for valuetype: " + var1_1, 1146056964, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
            }
            var9_11 = var7_8.length;
            if (var2_2 != null) {
                if (var7_8.length == 1 && var7_8[0].equals(var2_2)) {
                    var9_11 = 0;
                } else {
                    var9_11 = 0;
                    while (var9_11 < var7_8.length) {
                        if (var2_2.equals(var7_8[var9_11])) {
                            ++var9_11;
                            break;
                        }
                        ++var9_11;
                    }
                }
            }
            var6_7 = var9_11 == 0 ? (var6_7 |= 0) : (var9_11 == 1 ? (var6_7 |= 2) : (var6_7 |= 6));
            var10_14 = this.getURLCodeBase(var1_1);
            var6_7 = var10_14 != null ? (var6_7 |= 1) : (var6_7 |= 0);
            var11_15 = var8_9 == 1 || var9_11 > 1 || this.m_in_chunked_value != false;
            var12_16 = this.m_in_chunked_value;
            if (var11_15) {
                this.m_in_chunked_value = true;
                var6_7 |= 8;
            } else {
                var6_7 |= 0;
            }
            this.alignment(4);
            this.m_value_idx.put(new IdentityKey(var1_1), NumberCache.getInteger(this.m_index));
            if (var4_4 != null) {
                this.m_value_idx.put(new IdentityKey(var4_4), NumberCache.getInteger(this.m_index));
            }
            this.write_long(var6_7);
            if (var10_14 != null) {
                var13_17 = (Integer)this.m_url_idx.get(var10_14);
                if (var13_17 != null) {
                    this.write_ulong(-1);
                    this.write_long(var13_17 - this.m_index);
                } else {
                    this.alignment(4);
                    this.m_url_idx.put(var10_14, NumberCache.getInteger(this.m_index));
                    this.write_string(var10_14);
                }
            }
            if (var9_11 <= 0) break block49;
            if (var9_11 <= 1) ** GOTO lbl114
            if (var9_11 < var7_8.length) ** GOTO lbl113
            var13_17 = (Integer)this.m_typecode_list_idx.get(var1_1.getClass());
            if (var13_17 != null) {
                this.write_ulong(-1);
                this.write_long(var13_17 - this.m_index);
            } else {
                this.alignment(4);
                this.m_typecode_list_idx.put(var1_1.getClass(), NumberCache.getInteger(this.m_index));
lbl113:
                // 2 sources

                this.write_long(var9_11);
lbl114:
                // 2 sources

                var13_18 = 0;
                while (var13_18 < var9_11) {
                    var14_20 = (Integer)this.m_typecode_idx.get(var7_8[var13_18]);
                    if (var14_20 != null) {
                        this.write_ulong(-1);
                        this.write_long(var14_20 - this.m_index);
                    } else {
                        this.alignment(4);
                        this.m_typecode_idx.put(var7_8[var13_18], NumberCache.getInteger(this.m_index));
                        this.write_string(var7_8[var13_18]);
                    }
                    ++var13_18;
                }
            }
        }
        ++this.m_value_level;
        if (var11_15) {
            this.m_pending_value_open = true;
        }
        switch (var8_9) {
            case 2: {
                ((StreamableValue)var1_1)._write(this);
                break;
            }
            case 3: {
                var3_3.write_value(this, var1_1);
                break;
            }
            case 1: {
                var13_19 = new DataOutputStream(this);
                ((CustomValue)var1_1).marshal(var13_19);
                break;
            }
            case 4: {
                try {
                    this.value_extended_marshal(var1_1);
                    break;
                }
                catch (SystemException var14_21) {
                    this.m_buf.cancel(var14_21);
                    return;
                }
                catch (Throwable var15_22) {
                    this.getLogger().error("Exception during extended marshal.", var15_22);
                    this.m_buf.cancel(ExceptionTool.initCause(new MARSHAL("Exception during extended marshal (" + var15_22 + ")", 1146056981, CompletionStatus.COMPLETED_MAYBE), var15_22));
                    return;
                }
            }
        }
        if (var11_15) {
            ++this.m_pending_value_closes;
            this.m_in_chunked_value = var12_16;
        } else {
            --this.m_value_level;
        }
    }

    protected Serializable value_extended_replace(Serializable serializable) {
        return serializable;
    }

    protected String[] value_extended_get_IDs(Serializable serializable) {
        return null;
    }

    protected boolean value_extended_custom(Serializable serializable) {
        return true;
    }

    protected void value_extended_marshal(Serializable serializable) {
        this.m_buf.cancel(new BAD_PARAM("Unable to marshal valuetype", 1146056964, CompletionStatus.COMPLETED_MAYBE));
    }

    public void write_abstract_interface(java.lang.Object object) {
        if (object != null && object instanceof Object) {
            this.write_boolean(true);
            this.write_Object((Object)object);
        } else if (object == null || object instanceof Serializable) {
            this.write_boolean(false);
            this.write_value((Serializable)object);
        } else {
            this.m_buf.cancel(new BAD_PARAM("Attempt to marshal unknown interface type", 1146056967, CompletionStatus.COMPLETED_MAYBE));
        }
    }

    private String getURLCodeBase(java.lang.Object object) {
        java.lang.Object object2;
        if (this.m_system_urls == null) {
            object2 = ((ORB)this.m_orb).getLoader();
            this.m_system_urls = object2.getStringProperty("openorb.URLCodeBase", "");
        }
        if (this.m_system_urls.length() != 0) {
            return this.m_system_urls;
        }
        object2 = object.getClass().getClassLoader();
        if (!(object2 instanceof URLClassLoader)) {
            return null;
        }
        URL[] uRLArray = ((URLClassLoader)object2).getURLs();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < uRLArray.length) {
            if (!uRLArray[n].getProtocol().equals("file")) {
                stringBuffer.append(uRLArray[n].toString()).append(' ');
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }
}

