/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.CORBA.dynany;

import java.io.Serializable;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.openorb.CORBA.Any;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.dynany.DynBasicImpl;
import org.openorb.CORBA.dynany.DynEnumImpl;
import org.openorb.CORBA.dynany.DynFixedImpl;
import org.openorb.CORBA.typecode.TypeCodeBase;

abstract class DynAnyImpl
extends LocalObject
implements DynAny {
    protected static long s_dany_count = 0L;
    protected ORB m_orb;
    protected DynAnyFactory m_factory;
    protected TypeCode m_type;
    protected TypeCode m_tc;
    protected Any m_any;
    protected long m_count;
    private Logger m_logger;

    public DynAnyImpl(DynAnyFactory dynAnyFactory, ORB oRB) {
        this.m_orb = oRB;
        this.m_factory = dynAnyFactory;
        this.m_count = s_dany_count++;
    }

    public TypeCode type() {
        return this.m_type;
    }

    public abstract void assign(DynAny var1) throws TypeMismatch;

    public abstract void from_any(org.omg.CORBA.Any var1) throws InvalidValue, TypeMismatch;

    public abstract org.omg.CORBA.Any to_any();

    public abstract void destroy();

    public abstract DynAny copy();

    public boolean equal(DynAny dynAny) {
        org.omg.CORBA.Any any;
        if (!dynAny.type().equivalent(this.m_type)) {
            return false;
        }
        org.omg.CORBA.Any any2 = this.to_any();
        return any2.equal(any = dynAny.to_any());
    }

    public void insert_boolean(boolean bl) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_boolean);
        this.verifyInsertionTypes();
        this.m_any.insert_boolean(bl);
    }

    public void insert_octet(byte by) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_octet);
        this.verifyInsertionTypes();
        this.m_any.insert_octet(by);
    }

    public void insert_char(char c) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_char);
        this.verifyInsertionTypes();
        this.m_any.insert_char(c);
    }

    public void insert_short(short s) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_short);
        this.verifyInsertionTypes();
        this.m_any.insert_short(s);
    }

    public void insert_ushort(short s) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_ushort);
        this.verifyInsertionTypes();
        this.m_any.insert_ushort(s);
    }

    public void insert_long(int n) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_long);
        this.verifyInsertionTypes();
        this.m_any.insert_long(n);
    }

    public void insert_ulong(int n) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_ulong);
        this.verifyInsertionTypes();
        this.m_any.insert_ulong(n);
    }

    public void insert_float(float f) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_float);
        this.verifyInsertionTypes();
        this.m_any.insert_float(f);
    }

    public void insert_double(double d) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_double);
        this.verifyInsertionTypes();
        this.m_any.insert_double(d);
    }

    public void insert_string(String string) throws InvalidValue, TypeMismatch {
        int n;
        if (this.m_any == null) {
            throw new InvalidValue();
        }
        TypeCodeBase typeCodeBase = ((TypeCodeBase)this.m_any.type())._base_type();
        if (typeCodeBase.kind() != TCKind.tk_string) {
            throw new TypeMismatch();
        }
        try {
            n = typeCodeBase.length();
        }
        catch (BadKind badKind) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("BadKind", badKind);
            }
            throw new INTERNAL(1330446336, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n > 0 && n < string.length()) {
            throw new InvalidValue();
        }
        TypeCode typeCode = this.m_any.type();
        this.m_any.insert_string(string);
        this.m_any.type(typeCode);
    }

    public void insert_reference(Object object) throws InvalidValue, TypeMismatch {
        if (((TypeCodeBase)this.m_any.type())._base_type().kind() != TCKind.tk_objref) {
            throw new TypeMismatch();
        }
        this.m_any.insert_Object(object);
    }

    public void insert_typecode(TypeCode typeCode) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_TypeCode);
        this.verifyInsertionTypes();
        this.m_any.insert_TypeCode(typeCode);
    }

    public void insert_longlong(long l) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_longlong);
        this.verifyInsertionTypes();
        this.m_any.insert_longlong(l);
    }

    public void insert_ulonglong(long l) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_ulonglong);
        this.verifyInsertionTypes();
        this.m_any.insert_ulonglong(l);
    }

    public void insert_wchar(char c) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_wchar);
        this.verifyInsertionTypes();
        this.m_any.insert_wchar(c);
    }

    public void insert_wstring(String string) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_wstring);
        try {
            this.verifyInsertionTypes();
        }
        catch (TypeMismatch typeMismatch) {
            this.m_tc = this.m_orb.create_wstring_tc(string.length());
            this.verifyInsertionTypes();
        }
        this.m_any.insert_wstring(string);
        this.m_any.type(this.m_tc);
    }

    public void insert_any(org.omg.CORBA.Any any) throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_any);
        this.verifyInsertionTypes();
        this.m_any.insert_any(any);
    }

    public void insert_dyn_any(DynAny dynAny) throws InvalidValue, TypeMismatch {
        org.omg.CORBA.Any any = dynAny.to_any();
        this.m_tc = any.type();
        this.verifyInsertionTypes();
        this.m_any = (Any)any;
    }

    public void insert_val(Serializable serializable) throws InvalidValue, TypeMismatch {
        this.m_tc = serializable instanceof StreamableValue ? this.m_orb.get_primitive_tc(TCKind.tk_value) : this.m_orb.get_primitive_tc(TCKind.tk_value_box);
        this.verifyInsertionTypes();
        this.m_any.insert_Value(serializable);
    }

    public void insert_abstract(java.lang.Object object) throws TypeMismatch, InvalidValue {
        if (this.m_type.kind().value() != 32) {
            throw new TypeMismatch();
        }
        if (!(object instanceof Serializable)) {
            throw new InvalidValue();
        }
        this.m_any.insert_Value((Serializable)object, this.m_type);
    }

    public boolean get_boolean() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_boolean);
        this.verifyExtractionTypes();
        boolean bl = this.m_any.extract_boolean();
        return bl;
    }

    public byte get_octet() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_octet);
        this.verifyExtractionTypes();
        byte by = this.m_any.extract_octet();
        return by;
    }

    public char get_char() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_char);
        this.verifyExtractionTypes();
        char c = this.m_any.extract_char();
        return c;
    }

    public short get_short() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_short);
        this.verifyExtractionTypes();
        short s = this.m_any.extract_short();
        return s;
    }

    public short get_ushort() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_ushort);
        this.verifyExtractionTypes();
        short s = this.m_any.extract_ushort();
        return s;
    }

    public int get_long() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_long);
        this.verifyExtractionTypes();
        int n = this.m_any.extract_long();
        return n;
    }

    public int get_ulong() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_ulong);
        this.verifyExtractionTypes();
        int n = this.m_any.extract_ulong();
        return n;
    }

    public float get_float() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_float);
        this.verifyExtractionTypes();
        float f = this.m_any.extract_float();
        return f;
    }

    public double get_double() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_double);
        this.verifyExtractionTypes();
        double d = this.m_any.extract_double();
        return d;
    }

    public String get_string() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_string);
        this.verifyExtractionTypes();
        String string = this.m_any.extract_string();
        return string;
    }

    public Object get_reference() throws InvalidValue, TypeMismatch {
        if (((TypeCodeBase)this.m_any.type())._base_type().kind() != TCKind.tk_objref) {
            throw new TypeMismatch();
        }
        Object object = this.m_any.extract_Object();
        return object;
    }

    public TypeCode get_typecode() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_TypeCode);
        this.verifyExtractionTypes();
        TypeCode typeCode = this.m_any.extract_TypeCode();
        return typeCode;
    }

    public long get_longlong() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_longlong);
        this.verifyExtractionTypes();
        long l = this.m_any.extract_longlong();
        return l;
    }

    public long get_ulonglong() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_ulonglong);
        this.verifyExtractionTypes();
        long l = this.m_any.extract_ulonglong();
        return l;
    }

    public char get_wchar() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_wchar);
        this.verifyExtractionTypes();
        char c = this.m_any.extract_wchar();
        return c;
    }

    public String get_wstring() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_wstring);
        this.verifyExtractionTypes();
        String string = this.m_any.extract_wstring();
        return string;
    }

    public org.omg.CORBA.Any get_any() throws InvalidValue, TypeMismatch {
        this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_any);
        this.verifyExtractionTypes();
        org.omg.CORBA.Any any = this.m_any.extract_any();
        return any;
    }

    public DynAny get_dyn_any() throws InvalidValue, TypeMismatch {
        Object object;
        DynAnyFactory dynAnyFactory = null;
        try {
            object = this.m_orb.resolve_initial_references("DynAnyFactory");
            dynAnyFactory = DynAnyFactoryHelper.narrow(object);
        }
        catch (InvalidName invalidName) {
            // empty catch block
        }
        object = null;
        try {
            object = dynAnyFactory.create_dyn_any(this.m_any);
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            // empty catch block
        }
        return object;
    }

    public Serializable get_val() throws InvalidValue, TypeMismatch {
        try {
            this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_value);
            this.verifyExtractionTypes();
        }
        catch (TypeMismatch typeMismatch) {
            this.m_tc = this.m_orb.get_primitive_tc(TCKind.tk_value_box);
            this.verifyExtractionTypes();
        }
        Serializable serializable = this.m_any.extract_Value();
        return serializable;
    }

    public java.lang.Object get_abstract() throws TypeMismatch, InvalidValue {
        if (this.m_any.type().kind().value() != 32) {
            throw new TypeMismatch();
        }
        return this.m_any.extract_Object();
    }

    public abstract DynAny current_component() throws TypeMismatch;

    public abstract int component_count();

    public abstract boolean next();

    public abstract boolean seek(int var1);

    public abstract void rewind();

    protected void verifyInsertionTypes() throws TypeMismatch, InvalidValue {
        if (this.m_any == null) {
            throw new InvalidValue();
        }
        if (!((TypeCodeBase)this.m_tc)._base_type().equivalent(((TypeCodeBase)this.m_any.type())._base_type())) {
            throw new TypeMismatch();
        }
    }

    protected void verifyExtractionTypes() throws TypeMismatch, InvalidValue {
        if (this.m_any == null) {
            throw new InvalidValue();
        }
        if (!((TypeCodeBase)this.m_tc)._base_type().equal(((TypeCodeBase)this.m_any.type())._base_type())) {
            throw new TypeMismatch();
        }
    }

    protected DynAny create_dyn_any(TypeCode typeCode) {
        try {
            return this.m_factory.create_dyn_any_from_type_code(typeCode);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected DynAny[] create_dyn_any_graph(TypeCode typeCode) {
        DynAny[] dynAnyArray = null;
        switch (((TypeCodeBase)typeCode)._base_type().kind().value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                dynAnyArray = new DynAny[]{new DynBasicImpl(this.m_factory, this.m_orb, typeCode, this.m_orb.create_any())};
                break;
            }
            case 16: {
                try {
                    dynAnyArray = new DynAny[]{this.create_dyn_any(((TypeCodeBase)typeCode)._base_type().discriminator_type()), null};
                }
                catch (BadKind badKind) {}
                break;
            }
            case 15: 
            case 22: {
                try {
                    dynAnyArray = new DynAny[((TypeCodeBase)typeCode)._base_type().member_count()];
                    int n = 0;
                    while (n < dynAnyArray.length) {
                        dynAnyArray[n] = this.create_dyn_any(((TypeCodeBase)typeCode)._base_type().member_type(n));
                        ++n;
                    }
                }
                catch (BadKind badKind) {
                }
                catch (Bounds bounds) {}
                break;
            }
            case 17: {
                dynAnyArray = new DynAny[]{new DynEnumImpl(this.m_factory, this.m_orb, typeCode, 0)};
                break;
            }
            case 20: {
                try {
                    dynAnyArray = new DynAny[((TypeCodeBase)typeCode)._base_type().length()];
                    int n = 0;
                    while (n < dynAnyArray.length) {
                        dynAnyArray[n] = this.create_dyn_any(((TypeCodeBase)typeCode)._base_type().content_type());
                        ++n;
                    }
                }
                catch (BadKind badKind) {}
                break;
            }
            case 19: {
                dynAnyArray = new DynAny[]{};
                break;
            }
            case 28: {
                dynAnyArray = new DynAny[]{new DynFixedImpl(this.m_factory, this.m_orb, typeCode)};
                break;
            }
            case 29: {
                TypeCode[] typeCodeArray = this.getValueMember(typeCode);
                dynAnyArray = new DynAny[typeCodeArray.length];
                int n = 0;
                while (n < dynAnyArray.length) {
                    dynAnyArray[n] = this.create_dyn_any(typeCodeArray[n]);
                    ++n;
                }
                break;
            }
            case 30: {
                dynAnyArray = new DynAny[1];
                try {
                    dynAnyArray[0] = this.create_dyn_any(((TypeCodeBase)typeCode)._base_type().content_type());
                    break;
                }
                catch (BadKind badKind) {
                    // empty catch block
                }
            }
        }
        return dynAnyArray;
    }

    protected DynAny[] copy_dyn_any_graph(DynAny[] dynAnyArray) {
        DynAny[] dynAnyArray2 = new DynAny[dynAnyArray.length];
        int n = 0;
        while (n < dynAnyArray.length) {
            dynAnyArray2[n] = dynAnyArray[n].copy();
            ++n;
        }
        return dynAnyArray2;
    }

    protected void dyn_any_to_stream(TypeCode typeCode, OutputStream outputStream) {
        switch (((TypeCodeBase)typeCode)._base_type().kind().value()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_short(this.m_any.extract_short());
                    break;
                }
                outputStream.write_short((short)0);
                break;
            }
            case 3: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_long(this.m_any.extract_long());
                    break;
                }
                outputStream.write_long(0);
                break;
            }
            case 23: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_longlong(this.m_any.extract_longlong());
                    break;
                }
                outputStream.write_longlong(0L);
                break;
            }
            case 4: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_ushort(this.m_any.extract_ushort());
                    break;
                }
                outputStream.write_ushort((short)0);
                break;
            }
            case 5: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_ulong(this.m_any.extract_ulong());
                    break;
                }
                outputStream.write_ulong(0);
                break;
            }
            case 24: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_ulonglong(this.m_any.extract_ulonglong());
                    break;
                }
                outputStream.write_ulonglong(0L);
                break;
            }
            case 6: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_float(this.m_any.extract_float());
                    break;
                }
                outputStream.write_float(0.0f);
                break;
            }
            case 7: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_double(this.m_any.extract_double());
                    break;
                }
                outputStream.write_double(0.0);
                break;
            }
            case 8: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_boolean(this.m_any.extract_boolean());
                    break;
                }
                outputStream.write_boolean(false);
                break;
            }
            case 9: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_char(this.m_any.extract_char());
                    break;
                }
                outputStream.write_char('\u0000');
                break;
            }
            case 26: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_wchar(this.m_any.extract_wchar());
                    break;
                }
                outputStream.write_wchar('\u0000');
                break;
            }
            case 10: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_octet(this.m_any.extract_octet());
                    break;
                }
                outputStream.write_octet((byte)0);
                break;
            }
            case 11: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_any(this.m_any.extract_any());
                    break;
                }
                outputStream.write_any(this.m_orb.create_any());
                break;
            }
            case 12: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_TypeCode(this.m_any.extract_TypeCode());
                    break;
                }
                outputStream.write_TypeCode(this.m_orb.get_primitive_tc(TCKind.tk_null));
                break;
            }
            case 14: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_Object(this.m_any.extract_Object());
                    break;
                }
                outputStream.write_Object(null);
                break;
            }
            case 18: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_string(this.m_any.extract_string());
                    break;
                }
                outputStream.write_string("");
                break;
            }
            case 27: {
                if (this.m_any.type().kind() != TCKind.tk_void) {
                    outputStream.write_wstring(this.m_any.extract_wstring());
                    break;
                }
                outputStream.write_wstring("");
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 29: 
            case 30: {
                org.omg.CORBA.Any any = this.to_any();
                any.write_value(outputStream);
            }
        }
    }

    protected void dyn_any_graph_to_stream(DynAny[] dynAnyArray, OutputStream outputStream) {
        try {
            switch (((TypeCodeBase)this.m_type)._base_type().kind().value()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 18: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    ((DynBasicImpl)dynAnyArray[0]).dyn_any_to_stream(this.m_type, outputStream);
                    break;
                }
                case 16: {
                    ((DynAnyImpl)dynAnyArray[0]).dyn_any_to_stream(dynAnyArray[0].type(), outputStream);
                    ((DynAnyImpl)dynAnyArray[1]).dyn_any_to_stream(dynAnyArray[1].type(), outputStream);
                    break;
                }
                case 22: {
                    try {
                        outputStream.write_string(((TypeCodeBase)this.m_type)._base_type().id());
                    }
                    catch (BadKind badKind) {
                        // empty catch block
                    }
                    int n = 0;
                    while (n < dynAnyArray.length) {
                        ((DynAnyImpl)dynAnyArray[n]).dyn_any_to_stream(dynAnyArray[n].type(), outputStream);
                        ++n;
                    }
                    break;
                }
                case 15: {
                    int n = 0;
                    while (n < dynAnyArray.length) {
                        ((DynAnyImpl)dynAnyArray[n]).dyn_any_to_stream(dynAnyArray[n].type(), outputStream);
                        ++n;
                    }
                    break;
                }
                case 17: {
                    ((DynEnumImpl)dynAnyArray[0]).dyn_any_to_stream(this.m_type, outputStream);
                    break;
                }
                case 28: {
                    ((DynFixedImpl)dynAnyArray[0]).dyn_any_to_stream(this.m_type, outputStream);
                    break;
                }
                case 20: {
                    int n = 0;
                    while (n < dynAnyArray.length) {
                        ((DynAnyImpl)dynAnyArray[n]).dyn_any_to_stream(dynAnyArray[n].type(), outputStream);
                        ++n;
                    }
                    break;
                }
                case 19: {
                    outputStream.write_ulong(dynAnyArray.length);
                    int n = 0;
                    while (n < dynAnyArray.length) {
                        ((DynAnyImpl)dynAnyArray[n]).dyn_any_to_stream(dynAnyArray[n].type(), outputStream);
                        ++n;
                    }
                    break;
                }
                case 29: {
                    int n = 0;
                    while (n < dynAnyArray.length) {
                        ((DynAnyImpl)dynAnyArray[n]).dyn_any_to_stream(dynAnyArray[n].type(), outputStream);
                        ++n;
                    }
                    break;
                }
                case 30: {
                    ((DynAnyImpl)dynAnyArray[0]).dyn_any_to_stream(dynAnyArray[0].type(), outputStream);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void stream_to_dyn_any(TypeCode typeCode, InputStream inputStream) {
        switch (((TypeCodeBase)typeCode)._base_type().kind().value()) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.m_any.insert_short(inputStream.read_short());
                break;
            }
            case 3: {
                this.m_any.insert_long(inputStream.read_long());
                break;
            }
            case 23: {
                this.m_any.insert_longlong(inputStream.read_longlong());
                break;
            }
            case 4: {
                this.m_any.insert_ushort(inputStream.read_ushort());
                break;
            }
            case 5: {
                this.m_any.insert_ulong(inputStream.read_ulong());
                break;
            }
            case 24: {
                this.m_any.insert_ulonglong(inputStream.read_ulonglong());
                break;
            }
            case 6: {
                this.m_any.insert_float(inputStream.read_float());
                break;
            }
            case 7: {
                this.m_any.insert_double(inputStream.read_double());
                break;
            }
            case 8: {
                this.m_any.insert_boolean(inputStream.read_boolean());
                break;
            }
            case 9: {
                this.m_any.insert_char(inputStream.read_char());
                break;
            }
            case 26: {
                this.m_any.insert_wchar(inputStream.read_wchar());
                break;
            }
            case 10: {
                this.m_any.insert_octet(inputStream.read_octet());
                break;
            }
            case 11: {
                this.m_any.insert_any(inputStream.read_any());
                break;
            }
            case 12: {
                this.m_any.insert_TypeCode(inputStream.read_TypeCode());
                break;
            }
            case 14: {
                this.m_any.insert_Object(inputStream.read_Object());
                break;
            }
            case 18: {
                this.m_any.insert_string(inputStream.read_string());
                break;
            }
            case 27: {
                this.m_any.insert_wstring(inputStream.read_wstring());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 29: 
            case 30: {
                try {
                    this.m_any = (Any)this.m_orb.create_any();
                    this.m_any.read_value(inputStream, ((TypeCodeBase)typeCode)._base_type());
                    this.from_any(this.m_any);
                    break;
                }
                catch (InvalidValue invalidValue) {
                    this.getLogger().warn("read value from stream", invalidValue);
                    break;
                }
                catch (TypeMismatch typeMismatch) {
                    this.getLogger().warn("read value from stream", typeMismatch);
                }
            }
        }
        this.m_any.type(typeCode);
    }

    protected void stream_to_dyn_any_graph(DynAny[] dynAnyArray, InputStream inputStream) {
        switch (((TypeCodeBase)this.m_type)._base_type().kind().value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                ((DynBasicImpl)dynAnyArray[0]).stream_to_dyn_any(this.m_type, inputStream);
                break;
            }
            case 16: {
                ((DynAnyImpl)dynAnyArray[0]).stream_to_dyn_any(dynAnyArray[0].type(), inputStream);
                org.omg.CORBA.Any any = ((DynAnyImpl)dynAnyArray[0]).to_any();
                TypeCodeBase typeCodeBase = ((TypeCodeBase)this.m_type)._base_type();
                boolean bl = false;
                try {
                    int n = 0;
                    while (n < typeCodeBase.member_count()) {
                        if (any.equal(typeCodeBase.member_label(n))) {
                            bl = true;
                            if (dynAnyArray[1] != null && dynAnyArray[1].type().equals(typeCodeBase.member_type(n))) break;
                            dynAnyArray[1] = this.create_dyn_any(typeCodeBase.member_type(n));
                        }
                        ++n;
                    }
                    if (!bl) {
                        if (typeCodeBase.default_index() == -1) {
                            throw new MARSHAL();
                        }
                        dynAnyArray[1] = this.create_dyn_any(typeCodeBase.member_type(typeCodeBase.default_index()));
                    }
                }
                catch (BadKind badKind) {
                }
                catch (Bounds bounds) {
                    // empty catch block
                }
                ((DynAnyImpl)dynAnyArray[1]).stream_to_dyn_any(dynAnyArray[1].type(), inputStream);
                break;
            }
            case 22: {
                inputStream.read_string();
                int n = 0;
                while (n < dynAnyArray.length) {
                    ((DynAnyImpl)dynAnyArray[n]).stream_to_dyn_any(dynAnyArray[n].type(), inputStream);
                    ++n;
                }
                break;
            }
            case 15: {
                int n = 0;
                while (n < dynAnyArray.length) {
                    ((DynAnyImpl)dynAnyArray[n]).stream_to_dyn_any(dynAnyArray[n].type(), inputStream);
                    ++n;
                }
                break;
            }
            case 28: {
                ((DynAnyImpl)dynAnyArray[0]).stream_to_dyn_any(this.m_type, inputStream);
                break;
            }
            case 17: {
                ((DynAnyImpl)dynAnyArray[0]).stream_to_dyn_any(this.m_type, inputStream);
                break;
            }
            case 20: {
                try {
                    this.read_array_from_stream(dynAnyArray, inputStream, dynAnyArray.length);
                }
                catch (InvalidValue invalidValue) {
                    this.getLogger().warn("read_array_from_stream", invalidValue);
                }
                catch (TypeMismatch typeMismatch) {
                    this.getLogger().warn("read_array_from_stream", typeMismatch);
                }
                break;
            }
            case 19: {
                int n = inputStream.read_ulong();
                try {
                    this.read_array_from_stream(dynAnyArray, inputStream, n);
                }
                catch (InvalidValue invalidValue) {
                    this.getLogger().warn("read_array_from_stream", invalidValue);
                }
                catch (TypeMismatch typeMismatch) {
                    this.getLogger().warn("read_array_from_stream", typeMismatch);
                }
                break;
            }
            case 29: {
                int n = 0;
                while (n < dynAnyArray.length) {
                    ((DynAnyImpl)dynAnyArray[n]).stream_to_dyn_any(dynAnyArray[n].type(), inputStream);
                    ++n;
                }
                break;
            }
            case 30: {
                ((DynAnyImpl)dynAnyArray[0]).stream_to_dyn_any(dynAnyArray[0].type(), inputStream);
            }
        }
    }

    public TypeCode[] getValueMember(TypeCode typeCode) {
        TypeCode[] typeCodeArray = null;
        TypeCode[] typeCodeArray2 = null;
        try {
            if (typeCode.kind() == TCKind.tk_value) {
                if (typeCode.concrete_base_type().kind() != TCKind.tk_null) {
                    typeCodeArray2 = this.getValueMember(typeCode.concrete_base_type());
                    typeCodeArray = new TypeCode[typeCodeArray2.length + typeCode.member_count()];
                    int n = 0;
                    while (n < typeCodeArray2.length) {
                        typeCodeArray[n] = typeCodeArray2[n];
                        ++n;
                    }
                    int n2 = 0;
                    while (n2 < typeCode.member_count()) {
                        typeCodeArray[n2 + typeCodeArray2.length] = typeCode.member_type(n2);
                        ++n2;
                    }
                } else {
                    typeCodeArray = new TypeCode[typeCode.member_count()];
                    int n = 0;
                    while (n < typeCode.member_count()) {
                        typeCodeArray[n] = typeCode.member_type(n);
                        ++n;
                    }
                }
            } else {
                typeCodeArray = new TypeCode[]{typeCode.content_type()};
            }
        }
        catch (BadKind badKind) {
        }
        catch (Bounds bounds) {
            // empty catch block
        }
        return typeCodeArray;
    }

    protected Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }

    private void read_array_from_stream(DynAny[] dynAnyArray, InputStream inputStream, int n) throws TypeMismatch, InvalidValue {
        if (n == 0) {
            return;
        }
        TypeCode typeCode = dynAnyArray[0].type();
        switch (((TypeCodeBase)typeCode)._base_type().kind().value()) {
            case 8: {
                boolean[] blArray = new boolean[n];
                inputStream.read_boolean_array(blArray, 0, n);
                int n2 = 0;
                while (n2 < n) {
                    dynAnyArray[n2].insert_boolean(blArray[n2]);
                    ++n2;
                }
                break;
            }
            case 10: {
                byte[] byArray = new byte[n];
                inputStream.read_octet_array(byArray, 0, n);
                int n3 = 0;
                while (n3 < n) {
                    dynAnyArray[n3].insert_octet(byArray[n3]);
                    ++n3;
                }
                break;
            }
            case 9: {
                char[] cArray = new char[n];
                inputStream.read_char_array(cArray, 0, n);
                int n4 = 0;
                while (n4 < n) {
                    dynAnyArray[n4].insert_char(cArray[n4]);
                    ++n4;
                }
                break;
            }
            case 26: {
                char[] cArray = new char[n];
                inputStream.read_wchar_array(cArray, 0, n);
                int n5 = 0;
                while (n5 < n) {
                    dynAnyArray[n5].insert_wchar(cArray[n5]);
                    ++n5;
                }
                break;
            }
            case 2: {
                short[] sArray = new short[n];
                inputStream.read_short_array(sArray, 0, n);
                int n6 = 0;
                while (n6 < n) {
                    dynAnyArray[n6].insert_short(sArray[n6]);
                    ++n6;
                }
                break;
            }
            case 4: {
                short[] sArray = new short[n];
                inputStream.read_ushort_array(sArray, 0, n);
                int n7 = 0;
                while (n7 < n) {
                    dynAnyArray[n7].insert_ushort(sArray[n7]);
                    ++n7;
                }
                break;
            }
            case 6: {
                float[] fArray = new float[n];
                inputStream.read_float_array(fArray, 0, n);
                int n8 = 0;
                while (n8 < n) {
                    dynAnyArray[n8].insert_float(fArray[n8]);
                    ++n8;
                }
                break;
            }
            case 7: {
                double[] dArray = new double[n];
                inputStream.read_double_array(dArray, 0, n);
                int n9 = 0;
                while (n9 < n) {
                    dynAnyArray[n9].insert_double(dArray[n9]);
                    ++n9;
                }
                break;
            }
            case 3: {
                int[] nArray = new int[n];
                inputStream.read_long_array(nArray, 0, n);
                int n10 = 0;
                while (n10 < n) {
                    dynAnyArray[n10].insert_long(nArray[n10]);
                    ++n10;
                }
                break;
            }
            case 5: {
                int[] nArray = new int[n];
                inputStream.read_ulong_array(nArray, 0, n);
                int n11 = 0;
                while (n11 < n) {
                    dynAnyArray[n11].insert_ulong(nArray[n11]);
                    ++n11;
                }
                break;
            }
            case 23: {
                long[] lArray = new long[n];
                inputStream.read_longlong_array(lArray, 0, n);
                int n12 = 0;
                while (n12 < n) {
                    dynAnyArray[n12].insert_longlong(lArray[n12]);
                    ++n12;
                }
                break;
            }
            case 24: {
                long[] lArray = new long[n];
                inputStream.read_ulonglong_array(lArray, 0, n);
                int n13 = 0;
                while (n13 < n) {
                    dynAnyArray[n13].insert_ulonglong(lArray[n13]);
                    ++n13;
                }
                break;
            }
            default: {
                int n14 = 0;
                while (n14 < n) {
                    ((DynAnyImpl)dynAnyArray[n14]).stream_to_dyn_any(dynAnyArray[n14].type(), inputStream);
                    ++n14;
                }
                break block0;
            }
        }
    }
}

