/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.test.iiop.state;

import java.util.Properties;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.POA;
import org.openorb.test.iiop.state.StateTarget;
import org.openorb.test.iiop.state.StateTargetHelper;
import org.openorb.test.iiop.state.StateTargetPOA;

public class StateTest
extends TestCase {
    private static final int REPEATS = 5;
    private Policy m_biDirPolicy = null;
    private ORB m_orb;
    private ORB m_orb2;
    private StateTarget m_ref;
    private StateTarget m_ref2;
    static /* synthetic */ Class class$org$openorb$test$iiop$state$StateTest;

    public StateTest(String string) {
        super(string);
    }

    private void setUp(Properties properties, boolean bl) throws UserException {
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty("openorb.useStaticThreadGroup", "true");
        if (bl) {
            properties.setProperty("iiop.allowBidir", "true");
            this.m_orb2 = ORB.init((String[])null, properties);
            Any any = this.m_orb2.create_any();
            any.insert_ushort((short)1);
            this.m_biDirPolicy = this.m_orb2.create_policy(37, any);
            Thread.currentThread().interrupt();
            this.m_orb2.run();
            Thread.currentThread();
            Thread.interrupted();
        }
        this.m_orb = ORB.init((String[])null, properties);
        Thread.currentThread().interrupt();
        this.m_orb.run();
        Thread.currentThread();
        Thread.interrupted();
        this.m_ref = this.initRef(this.m_orb);
        if (bl) {
            this.m_ref2 = StateTargetHelper.narrow(this.m_orb.string_to_object(this.m_orb2.object_to_string(this.initRef(this.m_orb2))));
        }
    }

    public void tearDown() {
        if (this.m_orb != null) {
            this.m_orb.shutdown(true);
        }
        if (this.m_orb2 != null) {
            this.m_orb2.shutdown(true);
        }
    }

    private StateTarget initRef(ORB oRB) throws UserException {
        POA pOA = (POA)oRB.resolve_initial_references("RootPOA");
        Policy[] policyArray = new Policy[this.m_biDirPolicy == null ? 2 : 3];
        policyArray[0] = oRB.create_policy(1146057218, oRB.create_any());
        policyArray[1] = pOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION);
        if (this.m_biDirPolicy != null) {
            policyArray[2] = this.m_biDirPolicy;
        }
        PolicyManager policyManager = (PolicyManager)oRB.resolve_initial_references("ORBPolicyManager");
        policyManager.set_policy_overrides(policyArray, SetOverrideType.ADD_OVERRIDE);
        POA pOA2 = pOA.create_POA("BidirAdapter", pOA.the_POAManager(), policyArray);
        pOA.the_POAManager().activate();
        return new StateTargetImpl(pOA2)._this(oRB);
    }

    public void testClientPause() throws UserException, InterruptedException {
        Properties properties = new Properties();
        properties.setProperty("openorb.client.reapPauseDelay", "200");
        this.setUp(properties, false);
        int n = 0;
        while (n < 5) {
            this.m_ref.ping();
            Thread.sleep(500L);
            ++n;
        }
    }

    public void testServerPause() throws UserException, InterruptedException {
        Properties properties = new Properties();
        properties.setProperty("openorb.server.reapCloseDelay", "500");
        this.setUp(properties, false);
        int n = 0;
        while (n < 5) {
            this.m_ref.ping();
            Thread.sleep(700L);
            ++n;
        }
    }

    public void testBiDirClientPause() throws UserException, InterruptedException {
        Properties properties = new Properties();
        properties.setProperty("openorb.client.reapPauseDelay", "200");
        this.setUp(properties, true);
        int n = 0;
        while (n < 5) {
            this.m_ref2.call_ping(this.m_ref);
            Thread.sleep(500L);
            ++n;
        }
        this.m_ref2.call_ping(null);
    }

    public void testBiDirServerPause() throws UserException, InterruptedException {
        Properties properties = new Properties();
        properties.setProperty("openorb.server.reapCloseDelay", "700");
        this.setUp(properties, true);
        int n = 0;
        while (n < 5) {
            this.m_ref2.call_ping(this.m_ref);
            Thread.sleep(1000L);
            ++n;
        }
        this.m_ref2.call_ping(null);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(new TestSuite(class$org$openorb$test$iiop$state$StateTest == null ? (class$org$openorb$test$iiop$state$StateTest = StateTest.class$("org.openorb.test.iiop.state.StateTest")) : class$org$openorb$test$iiop$state$StateTest));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class StateTargetImpl
    extends StateTargetPOA {
        private POA m_poa;
        private StateTarget m_lastTest;

        StateTargetImpl(POA pOA) {
            this.m_poa = pOA;
        }

        public POA _default_POA() {
            return this.m_poa;
        }

        public void ping() {
            boolean bl = true;
        }

        public boolean sleep(long l) {
            try {
                Thread.sleep(l);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
        }

        public boolean call_sleep(StateTarget stateTarget, long l) {
            if (stateTarget != null) {
                this.m_lastTest = stateTarget;
            }
            this.m_lastTest.ping();
            return stateTarget.sleep(l);
        }

        public void call_ping(StateTarget stateTarget) {
            if (stateTarget != null) {
                this.m_lastTest = stateTarget;
            }
            this.m_lastTest.ping();
        }
    }
}

