/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class URLLoader
extends ClassLoader {
    private URL[] m_urls;

    public URLLoader(URL[] uRLArray) {
        this.m_urls = uRLArray;
    }

    public URL[] getURLs() {
        return this.m_urls;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = this.findClass(string);
        }
        if (clazz == null) {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        if (bl && clazz != null) {
            this.resolveClass(clazz);
        }
        if (clazz == null) {
            throw new ClassNotFoundException();
        }
        return clazz;
    }

    protected Class findClass(String string) {
        String string2 = string.replace('.', '/').concat(".class");
        byte[] byArray = null;
        int n = 0;
        while (n < this.m_urls.length) {
            try {
                byArray = this.extractClassFromURL(new URL(this.m_urls[n], string));
                if (byArray != null) {
                    break;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            ++n;
        }
        if (byArray == null) {
            return null;
        }
        return this.defineClass(string, byArray, 0, byArray.length);
    }

    private byte[] extractClassFromURL(URL uRL) {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            byte[] byArray = new byte[uRLConnection.getContentLength()];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            int n = 0;
            while (n < byArray.length) {
                n += bufferedInputStream.read(byArray, n, byArray.length - 1);
            }
            bufferedInputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

