/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.log.Hierarchy;
import org.apache.log.Priority;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.output.io.StreamTarget;
import org.openorb.io.HexPrintStream;
import org.openorb.io.StorageBuffer;

public class Trace {
    private static final Object LOGGER_SYNC = new byte[0];
    private static final String DEFAULT_FORMAT = "[%{thread}] [%5.5{priority}] (%{category}): %{message}\\n%{throwable}";
    private static final String DEFAULT_ASSERTION_LOGGER_NAME = "default-assertion-logger";
    public static final int OFF = 0;
    public static final int LOW = 1;
    public static final int MEDIUM = 2;
    public static final int HIGH = 3;
    private static final String[] LEVEL_NAMES = new String[]{"OFF", "LOW", "MEDIUM", "HIGH"};
    private static volatile int s_level = 0;
    private static OutputStream s_os = System.out;
    private static Hierarchy s_hierarchy;
    private static StreamTarget s_target;
    private static Logger s_logger;

    public static Logger getLogger() {
        return Trace.getLogger(null);
    }

    public static Logger getLogger(Properties properties) {
        Object object = LOGGER_SYNC;
        synchronized (object) {
            Object object2;
            if (null == s_logger) {
                object2 = null;
                if (properties != null) {
                    object2 = (String)((Hashtable)properties).get("openorb.debug.trace");
                }
                if (object2 == null) {
                    object2 = System.getProperty("openorb.debug.trace");
                }
                Priority priority = Trace.getPriorityFromName((String)(object2 == null ? "ERROR" : object2));
                s_logger = Trace.createLogger(priority);
            }
            object2 = s_logger;
            return object2;
        }
    }

    private static Logger createLogger(Priority priority) {
        s_hierarchy = Hierarchy.getDefaultHierarchy();
        s_target = new StreamTarget(s_os, new ExtendedPatternFormatter(DEFAULT_FORMAT));
        s_hierarchy.setDefaultPriority(priority);
        s_hierarchy.setDefaultLogTarget(s_target);
        return new LogKitLogger(s_hierarchy.getLoggerFor("orb"));
    }

    public static Logger getNewLogger(Priority priority) {
        s_logger = Trace.createLogger(priority);
        return s_logger;
    }

    public static void setLogger(Logger logger) {
        Object object = LOGGER_SYNC;
        synchronized (object) {
            s_logger = logger;
        }
    }

    public static Priority getPriorityFromName(String string) {
        if (string == null) {
            return Priority.FATAL_ERROR;
        }
        if (string.compareToIgnoreCase("FATAL") == 0 || string.equals("0")) {
            return Priority.FATAL_ERROR;
        }
        if (string.compareToIgnoreCase("ERROR") == 0 || string.equals("1")) {
            return Priority.ERROR;
        }
        if (string.compareToIgnoreCase("WARN") == 0 || string.equals("2")) {
            return Priority.WARN;
        }
        if (string.compareToIgnoreCase("INFO") == 0 || string.equals("3")) {
            return Priority.INFO;
        }
        if (string.compareToIgnoreCase("DEBUG") == 0 || string.equals("4")) {
            return Priority.DEBUG;
        }
        return Priority.FATAL_ERROR;
    }

    public static int getDebugLevelFromName(String string) {
        if (string == null) {
            return 0;
        }
        if (string.compareToIgnoreCase("OFF") == 0 || string.equals("0")) {
            return 0;
        }
        if (string.compareToIgnoreCase("LOW") == 0 || string.equals("1")) {
            return 1;
        }
        if (string.compareToIgnoreCase("MEDIUM") == 0 || string.equals("2")) {
            return 2;
        }
        if (string.compareToIgnoreCase("HIGH") == 0 || string.equals("3")) {
            return 3;
        }
        return 0;
    }

    public static void setDebugLevel(int n) {
        s_level = n;
    }

    public static int getDebugLevel() {
        return s_level;
    }

    public static String getNameOfDebugLevel(int n) {
        if (n < 0 || LEVEL_NAMES.length <= n) {
            return "UNKNOWN";
        }
        return LEVEL_NAMES[n];
    }

    public static boolean isEnabled(int n) {
        return s_level <= n;
    }

    public static boolean isLow() {
        return s_level >= 1;
    }

    public static boolean isMedium() {
        return s_level >= 2;
    }

    public static boolean isHigh() {
        return s_level >= 3;
    }

    public static String bufferToString(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null && byArray.length > 0) {
            int n = byArray.length;
            stringBuffer.append("\n------------------------------------------------------\n");
            stringBuffer.append("( " + string + " ) Displaying a buffer, size = " + byArray.length + "\n");
            stringBuffer.append("------------------------------------------------------\n");
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n2;
                while (n4 < n2 + 16 && n4 < n) {
                    if (Character.isISOControl((char)(byArray[n4] & 0x7F))) {
                        stringBuffer.append('.');
                    } else {
                        stringBuffer.append((char)byArray[n4]);
                    }
                    if (n4 == n2 + 7) {
                        stringBuffer.append(' ');
                    }
                    ++n4;
                }
                if (n2 + 16 > n) {
                    n3 = 16 - n % 16;
                    int n5 = 0;
                    while (n5 < n3) {
                        stringBuffer.append(' ');
                        ++n5;
                    }
                    if (n3 >= 8) {
                        stringBuffer.append(' ');
                    }
                }
                stringBuffer.append(' ');
                stringBuffer.append(' ');
                n3 = n2;
                while (n3 < n2 + 16 && n3 < n) {
                    stringBuffer.append(HexPrintStream.toHex(byArray[n3]));
                    if (n3 == n2 + 3 || n3 == n2 + 7 || n3 == n2 + 11) {
                        stringBuffer.append(' ');
                    }
                    ++n3;
                }
                stringBuffer.append("\n");
                n2 += 16;
            }
            stringBuffer.append("------------------------------------------------------\n");
        }
        return stringBuffer.toString();
    }

    public static String bufferToString(String string, StorageBuffer storageBuffer) {
        return Trace.bufferToString(string, storageBuffer.linearize());
    }

    public static Error signalIllegalCondition(Logger logger, String string) {
        Logger logger2 = null == logger ? logger : Trace.getAssertionLogger();
        IllegalConditionError illegalConditionError = new IllegalConditionError(string);
        logger2.fatalError("IllegalCondition [" + string + "]", illegalConditionError);
        throw illegalConditionError;
    }

    private static Logger getAssertionLogger() {
        return Trace.getLogger().getChildLogger(DEFAULT_ASSERTION_LOGGER_NAME);
    }

    public static class StackSnapshot
    extends Throwable {
        public StackSnapshot() {
            super("## Debug information - not error ##");
        }
    }

    public static class IllegalConditionError
    extends Error {
        public IllegalConditionError(String string) {
            super(string);
        }
    }
}

