/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.lang.reflect.Constructor;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.PI.FeatureInitInfo;
import org.openorb.iiop.IIOPAddress;
import org.openorb.net.Address;
import org.openorb.net.TransportClientInitializer;
import org.openorb.util.NumberCache;

public class IIOPTransportClientInitializer
extends AbstractLogEnabled
implements TransportClientInitializer {
    private static final Constructor IIOP_CTOR;
    private final boolean m_socketNoDelay;
    private final boolean m_boostRecvPriority;
    private final int m_sendBufferSize;
    private final int m_receiveBufferSize;
    private final int m_bufferedOutputStreamSize;
    static /* synthetic */ Class class$java$net$InetAddress;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$Logger;
    static /* synthetic */ Class class$org$openorb$iiop$IIOPTransport;

    public IIOPTransportClientInitializer(ORBInitInfo oRBInitInfo, FeatureInitInfo featureInitInfo) {
        ORBLoader oRBLoader = featureInitInfo.getLoader();
        this.m_socketNoDelay = oRBLoader.getBooleanProperty("iiop.clientNoDelay", true);
        this.m_boostRecvPriority = oRBLoader.getBooleanProperty("iiop.boostReceivePriority", true);
        this.m_sendBufferSize = oRBLoader.getIntProperty("iiop.sendBufferSize", 0);
        this.m_receiveBufferSize = oRBLoader.getIntProperty("iiop.receiveBufferSize", 0);
        this.m_bufferedOutputStreamSize = oRBLoader.getIntProperty("iiop.bufferedOutputStreamSize", 50);
    }

    public Address[] establishTransports(Address[] addressArray) {
        int n = 0;
        while (n < addressArray.length) {
            IIOPAddress iIOPAddress = (IIOPAddress)addressArray[n];
            Object[] objectArray = new Object[]{iIOPAddress.get_host(), NumberCache.getInteger(iIOPAddress.get_port()), this.getLogger(), this.m_socketNoDelay ? Boolean.TRUE : Boolean.FALSE, this.m_boostRecvPriority ? Boolean.TRUE : Boolean.FALSE, NumberCache.getInteger(this.m_sendBufferSize), NumberCache.getInteger(this.m_receiveBufferSize), NumberCache.getInteger(this.m_bufferedOutputStreamSize)};
            addressArray[n].setTransportConstructor(IIOP_CTOR, objectArray);
            ++n;
        }
        return addressArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            IIOP_CTOR = (class$org$openorb$iiop$IIOPTransport == null ? (class$org$openorb$iiop$IIOPTransport = IIOPTransportClientInitializer.class$("org.openorb.iiop.IIOPTransport")) : class$org$openorb$iiop$IIOPTransport).getConstructor(class$java$net$InetAddress == null ? (class$java$net$InetAddress = IIOPTransportClientInitializer.class$("java.net.InetAddress")) : class$java$net$InetAddress, Integer.TYPE, class$org$apache$avalon$framework$logger$Logger == null ? (class$org$apache$avalon$framework$logger$Logger = IIOPTransportClientInitializer.class$("org.apache.avalon.framework.logger.Logger")) : class$org$apache$avalon$framework$logger$Logger, Boolean.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            throw new CascadingRuntimeException("Exception during the construction of class IIOPTransport.", exception);
        }
    }
}

