/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.BiDirPolicy.BidirectionalPolicyHelper;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.GIOP.TargetAddressHelper;
import org.omg.GIOP.Version;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextListHelper;
import org.openorb.CORBA.ORB;
import org.openorb.iiop.CDRInputStream;
import org.openorb.iiop.CDROutputStream;
import org.openorb.iiop.HeaderBlock;
import org.openorb.iiop.IIOPAddress;
import org.openorb.iiop.IIOPClientProtocol;
import org.openorb.iiop.IIOPClientRequest;
import org.openorb.iiop.IIOPServerChannel;
import org.openorb.iiop.IIOPServerProtocol;
import org.openorb.iiop.SocketQueue;
import org.openorb.io.BufferSource;
import org.openorb.io.MarshalBuffer;
import org.openorb.io.StorageBuffer;
import org.openorb.net.Address;
import org.openorb.net.ClientChannel;
import org.openorb.net.ClientManager;
import org.openorb.net.ClientRequest;
import org.openorb.net.RebindChannelException;
import org.openorb.net.RequestIDAllocator;
import org.openorb.net.ServerRequest;
import org.openorb.net.Transport;
import org.openorb.util.ExceptionTool;
import org.openorb.util.NumberCache;
import org.openorb.util.Trace;

public class IIOPClientChannel
implements ClientChannel {
    private static final int CONN_SC_TOTAL = 2;
    private static final int CONN_SC_CODESETS = 0;
    private static final int CONN_SC_BIDIR = 1;
    private static final int CONN_SC_STATUS_UNSENT = 0;
    private static final int CONN_SC_STATUS_PEND = 1;
    private static final int CONN_SC_STATUS_SENT = 2;
    private static final byte[] RESERVED = new byte[]{0, 0, 0};
    private org.omg.CORBA.ORB m_orb;
    private IIOPClientProtocol m_client_protocol;
    private ClientManager m_client_manager;
    private java.lang.Object m_sync_state;
    private int m_state = 0x12000000;
    private boolean m_first_connect = true;
    private boolean m_paused = false;
    private boolean m_pending_close = false;
    private boolean m_pending_service_ctxt = false;
    private SocketQueue m_socket_queue;
    private org.omg.IIOP.Version m_version = new org.omg.IIOP.Version(1, 0);
    private SystemException m_close_exception = null;
    private short m_disposition = 0;
    private Logger m_logger = null;
    private Map m_active_requests = new HashMap();
    private int m_channel_age = 0;
    private int m_tcsc;
    private int m_tcsw;
    private int[] m_service_ctxts_sent = null;
    private boolean m_delegated = false;
    private IIOPServerProtocol m_server_protocol;
    private IIOPServerChannel m_server_peer;
    private Constructor m_os_ctor;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$org$omg$GIOP$Version;
    static /* synthetic */ Class class$org$openorb$io$MarshalBuffer;

    IIOPClientChannel(IIOPClientProtocol iIOPClientProtocol, Transport transport, IIOPServerProtocol iIOPServerProtocol, int n, int n2) {
        this.m_client_protocol = iIOPClientProtocol;
        this.m_orb = this.m_client_protocol.orb();
        this.m_logger = ((ORB)this.orb()).getLogger();
        this.m_client_manager = this.m_client_protocol.getClientManager();
        this.m_socket_queue = new SocketQueue(transport);
        this.m_socket_queue.setClientChannel(this);
        this.m_sync_state = new java.lang.Object();
        this.m_server_protocol = iIOPServerProtocol;
        this.m_tcsc = n;
        this.m_tcsw = n2;
        try {
            Class[] classArray = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = IIOPClientChannel.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = IIOPClientChannel.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$io$MarshalBuffer == null ? (class$org$openorb$io$MarshalBuffer = IIOPClientChannel.class$("org.openorb.io.MarshalBuffer")) : class$org$openorb$io$MarshalBuffer};
            this.m_os_ctor = ((ORB)this.m_orb).getLoader().classConstructor("iiop.CDROutputStreamClass", "org.openorb.iiop.CDROutputStream", classArray);
        }
        catch (Exception exception) {
            this.getLogger().error("Unable to initialize output stream constructor.", exception);
            throw ExceptionTool.initCause(new INITIALIZE("Unable to initialize output stream constructor (" + exception + ")"), (Throwable)exception);
        }
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " created");
        }
    }

    IIOPClientChannel(IIOPClientProtocol iIOPClientProtocol, IIOPServerChannel iIOPServerChannel) {
        this.m_client_protocol = iIOPClientProtocol;
        this.m_orb = this.m_client_protocol.orb();
        this.m_logger = ((ORB)this.orb()).getLogger();
        this.m_client_manager = this.m_client_protocol.getClientManager();
        this.m_server_peer = iIOPServerChannel;
        this.m_socket_queue = this.m_server_peer.getSocketQueue();
        this.m_socket_queue.setClientChannel(this);
        this.m_sync_state = this.m_server_peer.getSyncState();
        this.m_state = 0x11000000;
        this.m_delegated = true;
        this.m_tcsc = this.m_server_peer.getTCSC();
        this.m_tcsw = this.m_server_peer.getTCSW();
        try {
            Class[] classArray = new Class[]{class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = IIOPClientChannel.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB, class$org$omg$GIOP$Version == null ? (class$org$omg$GIOP$Version = IIOPClientChannel.class$("org.omg.GIOP.Version")) : class$org$omg$GIOP$Version, class$org$openorb$io$MarshalBuffer == null ? (class$org$openorb$io$MarshalBuffer = IIOPClientChannel.class$("org.openorb.io.MarshalBuffer")) : class$org$openorb$io$MarshalBuffer};
            this.m_os_ctor = ((ORB)this.m_orb).getLoader().classConstructor("iiop.CDROutputStreamClass", "org.openorb.iiop.CDROutputStream", classArray);
        }
        catch (Exception exception) {
            this.getLogger().error("Unable to initialize output stream constructor.", exception);
            throw ExceptionTool.initCause(new INITIALIZE("Unable to initialize output stream constructor (" + exception + ")"), (Throwable)exception);
        }
    }

    public Map getActiveRequestMap() {
        return this.m_active_requests;
    }

    public SocketQueue getSocketQueue() {
        return this.m_socket_queue;
    }

    public java.lang.Object getSyncState() {
        return this.m_sync_state;
    }

    public int getChannelAge() {
        return this.m_channel_age;
    }

    public void setServerPeer(IIOPServerChannel iIOPServerChannel) {
        this.m_server_peer = iIOPServerChannel;
    }

    public void setCloseException(SystemException systemException) {
        this.m_close_exception = systemException;
    }

    public int getTCSC() {
        return this.m_tcsc;
    }

    public void setTCSC(int n) {
        this.m_tcsc = n;
    }

    public int getTCSW() {
        return this.m_tcsw;
    }

    public void setTCSW(int n) {
        this.m_tcsw = n;
    }

    public void setPendingClose() {
        this.m_pending_close = true;
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public int state() {
        if (this.m_delegated) {
            java.lang.Object object = this.m_sync_state;
            synchronized (object) {
                if (this.m_server_peer != null) {
                    int n = 0x11000000;
                    return n;
                }
                int n = 0x12000000;
                return n;
            }
        }
        return this.m_state;
    }

    public void setState(int n) {
        this.m_state = n;
    }

    boolean isDelegated() {
        return this.m_delegated;
    }

    public String toString() {
        return "ClientChannel: " + this.m_socket_queue.toString();
    }

    public org.omg.IIOP.Version version() {
        return this.m_version;
    }

    public int active_requests() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            int n = this.m_active_requests.size() + (this.m_server_peer != null ? this.m_server_peer.getActiveRequestMap().size() : 0);
            return n;
        }
    }

    public int channel_age() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (!this.m_active_requests.isEmpty() || this.m_server_peer != null && !this.m_server_peer.getActiveRequestMap().isEmpty()) {
                int n = RequestIDAllocator.peek_request_id();
                return n;
            }
            if (this.m_server_peer != null && this.m_channel_age < this.m_server_peer.getChannelAge()) {
                int n = this.m_server_peer.getChannelAge();
                return n;
            }
            int n = this.m_channel_age;
            return n;
        }
    }

    private void request_open(Object object, Address address) {
        switch (this.m_state) {
            case 0x11000000: {
                return;
            }
            case 0x13000000: {
                throw this.m_close_exception;
            }
        }
        if (this.m_delegated && this.m_server_peer == null) {
            throw new TRANSIENT(0, CompletionStatus.COMPLETED_NO);
        }
        this.m_socket_queue.open();
        this.m_state = 0x11000000;
        this.m_first_connect = false;
        this.m_pending_close = false;
        this.m_close_exception = null;
        this.connectionSCReset();
        this.m_server_peer = null;
        this.m_client_manager.register_channel(this);
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " opened");
        }
    }

    public void pause() {
        if (this.m_delegated) {
            this.m_server_peer.soft_close(false);
            return;
        }
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.active_requests() > 0) {
                return;
            }
            if (this.m_state != 0x11000000) {
                return;
            }
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug(this + " paused");
            }
            this.m_state = 0x12000000;
            if (this.m_server_peer != null) {
                this.m_server_peer.setState(1);
                this.m_server_peer.setClientPeer(null);
                this.m_server_peer = null;
            }
            this.m_paused = true;
        }
        this.m_client_manager.unregister_channel(this);
        this.m_socket_queue.close();
        java.lang.Object object2 = this.m_sync_state;
        synchronized (object2) {
            this.m_paused = false;
            this.m_sync_state.notifyAll();
        }
    }

    void server_pause(SystemException systemException) {
        java.lang.Object object;
        this.getLogger().debug("server_pause invocation caused by", systemException);
        IIOPServerChannel iIOPServerChannel = null;
        ServerRequest[] serverRequestArray = null;
        java.lang.Object object2 = this.m_sync_state;
        synchronized (object2) {
            if (this.m_state != 0x11000000) {
                if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                    this.getLogger().debug(this + " already closed");
                }
                return;
            }
            this.m_state = 0x12000000;
            if (this.m_server_peer != null) {
                object = this.m_server_peer.getActiveRequestMap();
                if (!object.isEmpty()) {
                    serverRequestArray = new ServerRequest[object.size()];
                    object.values().toArray(serverRequestArray);
                    object.clear();
                }
                iIOPServerChannel = this.m_server_peer;
                this.m_server_peer.setState(1);
                this.m_server_peer.setClientPeer(null);
                this.m_server_peer = null;
            }
            this.m_paused = true;
        }
        if (this.m_delegated) {
            object = iIOPServerChannel;
            iIOPServerChannel.getServerManager().unregister_channel(iIOPServerChannel);
        } else {
            object = this;
            this.m_client_manager.unregister_channel(this);
        }
        this.m_socket_queue.close();
        IIOPClientRequest[] iIOPClientRequestArray = null;
        java.lang.Object object3 = this.m_sync_state;
        synchronized (object3) {
            this.m_paused = false;
            this.m_sync_state.notifyAll();
            if (!this.m_active_requests.isEmpty()) {
                iIOPClientRequestArray = new IIOPClientRequest[this.m_active_requests.size()];
                this.m_active_requests.values().toArray(iIOPClientRequestArray);
                this.m_active_requests.clear();
            }
            if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                this.getLogger().debug(object.toString() + (this.m_delegated ? "paused by client" : "paused by server"));
            }
        }
        if (iIOPClientRequestArray != null) {
            int n = 0;
            while (n < iIOPClientRequestArray.length) {
                iIOPClientRequestArray[n].cancel(systemException);
                ++n;
            }
        }
        if (serverRequestArray != null) {
            int n = 0;
            while (n < serverRequestArray.length) {
                serverRequestArray[n].client_cancel();
                ++n;
            }
        }
    }

    public void close(boolean bl, SystemException systemException) {
        if (this.m_delegated) {
            if (bl) {
                this.m_server_peer.close();
            } else {
                this.m_server_peer.soft_close(this.m_pending_close);
            }
            return;
        }
        IIOPClientRequest[] iIOPClientRequestArray = null;
        ServerRequest[] serverRequestArray = null;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 0x12000000) {
                boolean bl2 = false;
                while (this.m_paused) {
                    try {
                        this.m_sync_state.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl2 = true;
                    }
                }
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
                this.m_close_exception = systemException;
                this.m_state = 0x13000000;
                return;
            }
            if (this.m_state == 0x13000000) {
                return;
            }
            this.m_state = 0x13000000;
            this.m_close_exception = systemException;
            if (!bl && this.active_requests() > 0) {
                this.m_pending_close = true;
                if (this.m_server_peer != null) {
                    this.m_server_peer.setPendingClose();
                }
                return;
            }
            iIOPClientRequestArray = new IIOPClientRequest[this.m_active_requests.size()];
            this.m_active_requests.values().toArray(iIOPClientRequestArray);
            this.m_active_requests.clear();
            if (this.m_server_peer != null) {
                Map map = this.m_server_peer.getActiveRequestMap();
                serverRequestArray = new ServerRequest[map.size()];
                map.values().toArray(serverRequestArray);
                map.clear();
                this.m_server_peer.setState(1);
                this.m_server_peer.setClientPeer(null);
                this.m_server_peer = null;
            }
        }
        this.m_client_manager.unregister_channel(this);
        this.m_socket_queue.close();
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug(this + " closed");
        }
        if (iIOPClientRequestArray != null) {
            int n = 0;
            while (n < iIOPClientRequestArray.length) {
                iIOPClientRequestArray[n].cancel(systemException);
                ++n;
            }
        }
        if (serverRequestArray != null) {
            int n = 0;
            while (n < serverRequestArray.length) {
                serverRequestArray[n].client_cancel();
                ++n;
            }
        }
    }

    public ClientRequest create_request(Object object, Address address, java.lang.Object object2, String string, boolean bl) throws RebindChannelException {
        int n = RequestIDAllocator.get_request_id() << 1;
        if (this.m_delegated) {
            --n;
        }
        IIOPClientRequest iIOPClientRequest = new IIOPClientRequest(n, object, address, object2, this, string, bl);
        java.lang.Object object3 = this.m_sync_state;
        synchronized (object3) {
            this.check_rebind(address);
            this.m_active_requests.put(NumberCache.getInteger(n), iIOPClientRequest);
        }
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug(this + " request #" + n + " created");
        }
        return iIOPClientRequest;
    }

    public ClientRequest create_locate_request(Object object, Address address, java.lang.Object object2) throws RebindChannelException {
        int n = RequestIDAllocator.get_request_id() << 1;
        if (this.m_delegated) {
            --n;
        }
        IIOPClientRequest iIOPClientRequest = new IIOPClientRequest(n, object, address, object2, this);
        java.lang.Object object3 = this.m_sync_state;
        synchronized (object3) {
            this.check_rebind(address);
            this.m_active_requests.put(NumberCache.getInteger(n), iIOPClientRequest);
        }
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug(this + " locate request #" + n + " created");
        }
        return iIOPClientRequest;
    }

    private void check_rebind(Address address) throws RebindChannelException {
        if (this.m_delegated && this.m_server_peer == null) {
            this.m_client_protocol.rebindBidirDelegate(this, (IIOPAddress)address);
            return;
        }
    }

    boolean cancel_request(IIOPClientRequest iIOPClientRequest, boolean bl) {
        int n = iIOPClientRequest.request_id();
        boolean bl2 = false;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.m_state == 0x13000000) {
                boolean bl3 = false;
                return bl3;
            }
            if (this.m_pending_service_ctxt && !iIOPClientRequest.is_locate()) {
                this.connectionSCCanceled();
                this.m_pending_service_ctxt = false;
                this.m_sync_state.notifyAll();
            }
            if (this.m_active_requests.isEmpty() || this.m_active_requests.remove(NumberCache.getInteger(n)) == null) {
                boolean bl4 = false;
                return bl4;
            }
            if (this.m_active_requests.isEmpty()) {
                this.m_channel_age = RequestIDAllocator.peek_request_id();
                bl2 = this.m_pending_close && (this.m_server_peer == null || this.m_server_peer.getActiveRequestMap().isEmpty());
            }
        }
        if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
            this.getLogger().debug(this + " request #" + n + " canceled");
        }
        if (bl2) {
            if (this.m_delegated) {
                this.m_server_peer.soft_close(false);
            } else {
                this.close(false, this.m_close_exception);
            }
            return true;
        }
        if (bl) {
            long l = 4L;
            byte[] byArray = new byte[]{71, 73, 79, 80, this.m_version.major, this.m_version.minor, 0, 2, (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l, (byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
            StorageBuffer storageBuffer = new StorageBuffer(byArray, 0, byArray.length);
            this.m_socket_queue.send(storageBuffer, iIOPClientRequest.get_transport_association());
        }
        return true;
    }

    OutputStream begin_marshal(IIOPClientRequest iIOPClientRequest) {
        CDROutputStream cDROutputStream;
        short s;
        org.omg.IIOP.Version version = ((IIOPAddress)iIOPClientRequest.address()).get_version();
        Version version2 = new Version(1, 0);
        boolean bl = false;
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            boolean bl2;
            if (this.m_version.minor < version.minor) {
                this.m_version.minor = version.minor;
            }
            version2.minor = this.m_version.minor;
            boolean bl3 = bl2 = !iIOPClientRequest.is_locate();
            if (bl2) {
                while (this.m_paused || this.m_pending_service_ctxt) {
                    try {
                        this.m_sync_state.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.request_open(iIOPClientRequest.target(), iIOPClientRequest.address());
            if (bl2) {
                this.m_pending_service_ctxt = this.connectionSCAdd(iIOPClientRequest);
            }
            s = this.m_disposition;
        }
        MarshalBuffer marshalBuffer = new MarshalBuffer(new MarshalListener(), iIOPClientRequest);
        try {
            cDROutputStream = (CDROutputStream)this.m_os_ctor.newInstance(iIOPClientRequest.orb(), version2, marshalBuffer);
        }
        catch (Exception exception) {
            this.getLogger().error("Unable to create CDROutputStream class.", exception);
            throw ExceptionTool.initCause(new INITIALIZE("Unable to create CDROutputStream class (" + exception + ")"), (Throwable)exception);
        }
        cDROutputStream.setCodesets(this.m_tcsc, this.m_tcsw);
        int n = iIOPClientRequest.request_id();
        if (iIOPClientRequest.is_request()) {
            new HeaderBlock(0, n, cDROutputStream);
            switch (version2.minor) {
                case 0: 
                case 1: {
                    ServiceContextListHelper.write(cDROutputStream, iIOPClientRequest.get_request_service_contexts());
                    cDROutputStream.write_long(n);
                    cDROutputStream.write_boolean(iIOPClientRequest.response_expected());
                    OctetSeqHelper.write(cDROutputStream, iIOPClientRequest.address().getTargetAddress((short)0).object_key());
                    cDROutputStream.write_string(iIOPClientRequest.operation());
                    cDROutputStream.write_long(0);
                    break;
                }
                case 2: {
                    cDROutputStream.write_long(n);
                    cDROutputStream.allowFragment();
                    switch (iIOPClientRequest.sync_scope()) {
                        case 0: 
                        case 1: {
                            cDROutputStream.write_octet((byte)0);
                            break;
                        }
                        case 2: {
                            cDROutputStream.write_octet((byte)1);
                            break;
                        }
                        case 3: {
                            cDROutputStream.write_octet((byte)3);
                        }
                    }
                    cDROutputStream.write_octet_array(RESERVED, 0, 3);
                    TargetAddressHelper.write(cDROutputStream, iIOPClientRequest.address().getTargetAddress(s));
                    cDROutputStream.write_string(iIOPClientRequest.operation());
                    ServiceContextListHelper.write(cDROutputStream, iIOPClientRequest.get_request_service_contexts());
                    cDROutputStream.pending_alignment(8);
                }
            }
        } else {
            new HeaderBlock(3, n, cDROutputStream);
            cDROutputStream.write_long(n);
            switch (version2.minor) {
                case 0: 
                case 1: {
                    byte[] byArray = iIOPClientRequest.address().getTargetAddress((short)0).object_key();
                    OctetSeqHelper.write(cDROutputStream, byArray);
                    break;
                }
                case 2: {
                    cDROutputStream.allowFragment();
                    TargetAddressHelper.write(cDROutputStream, iIOPClientRequest.address().getTargetAddress(s));
                }
            }
        }
        return cDROutputStream;
    }

    protected boolean connectionSCAdd(IIOPClientRequest iIOPClientRequest) {
        IDLEntity iDLEntity;
        java.lang.Object object;
        if (this.m_service_ctxts_sent == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_service_ctxts_sent[0] == 0 && this.m_version.minor > 0) {
            if (this.m_tcsc != 0 || this.m_tcsw != 0) {
                object = new byte[]{0, 0, 0, 0, (byte)(this.m_tcsc >>> 24), (byte)(this.m_tcsc >>> 16), (byte)(this.m_tcsc >>> 8), (byte)this.m_tcsc, (byte)(this.m_tcsw >>> 24), (byte)(this.m_tcsw >>> 16), (byte)(this.m_tcsw >>> 8), (byte)this.m_tcsw};
                iDLEntity = new ServiceContext(1, (byte[])object);
                iIOPClientRequest.add_request_service_context((ServiceContext)iDLEntity, true);
                this.m_service_ctxts_sent[0] = 1;
                bl2 = true;
            } else {
                this.m_service_ctxts_sent[0] = 2;
                bl = true;
            }
        }
        if (this.m_service_ctxts_sent[1] == 0) {
            object = this.m_client_protocol.getBiDirSC();
            if (object != null) {
                iDLEntity = null;
                try {
                    iDLEntity = BidirectionalPolicyHelper.narrow(iIOPClientRequest.get_request_policy(37));
                }
                catch (INV_POLICY iNV_POLICY) {
                    // empty catch block
                }
                if (iDLEntity != null && iDLEntity.value() == 1) {
                    this.m_server_peer = new IIOPServerChannel(this.m_server_protocol.getServerManager(), this, this.m_client_protocol.getCodec());
                    if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
                        this.getLogger().debug(this + " became bidirectional with peer " + this.m_server_peer.toString());
                    }
                    iIOPClientRequest.add_request_service_context((ServiceContext)object, true);
                    this.m_service_ctxts_sent[1] = 1;
                    bl2 = true;
                }
            } else {
                this.m_service_ctxts_sent[1] = 2;
                bl = true;
            }
        }
        if (bl2) {
            return true;
        }
        if (bl) {
            boolean bl3 = true;
            int n = 0;
            while (n < this.m_service_ctxts_sent.length) {
                bl3 = this.m_service_ctxts_sent[n] == 2;
                if (!bl3) break;
                ++n;
            }
            if (bl3) {
                this.m_service_ctxts_sent = null;
            }
        }
        return false;
    }

    protected void connectionSCSent() {
        if (this.m_service_ctxts_sent != null) {
            boolean bl = true;
            int n = 0;
            while (n < this.m_service_ctxts_sent.length) {
                if (this.m_service_ctxts_sent[n] != 0) {
                    this.m_service_ctxts_sent[n] = 2;
                } else {
                    bl = false;
                }
                ++n;
            }
            if (bl) {
                this.m_service_ctxts_sent = null;
            }
        }
    }

    protected void connectionSCCanceled() {
        if (this.m_service_ctxts_sent != null) {
            int n = 0;
            while (n < this.m_service_ctxts_sent.length) {
                if (this.m_service_ctxts_sent[n] == 1) {
                    this.m_service_ctxts_sent[n] = 0;
                }
                ++n;
            }
        }
    }

    protected void connectionSCReset() {
        this.m_service_ctxts_sent = new int[2];
    }

    public boolean recv(int n) {
        if (this.m_delegated) {
            return false;
        }
        return this.m_socket_queue.receive(n);
    }

    public void run_recv() {
        if (this.m_delegated) {
            return;
        }
        while (!Thread.interrupted() && this.m_socket_queue.receive(1000)) {
        }
    }

    int process_reply(byte by, CDRInputStream cDRInputStream, byte by2, boolean bl, BufferSource bufferSource, java.lang.Object object) {
        int n = -1;
        ServiceContext[] serviceContextArray = null;
        cDRInputStream.setCodesets(this.m_tcsc, this.m_tcsw);
        int n2 = 0;
        IIOPClientRequest iIOPClientRequest = null;
        boolean bl2 = false;
        try {
            try {
                if (by < 2 && by2 == 1) {
                    serviceContextArray = ServiceContextListHelper.read(cDRInputStream);
                }
                n2 = cDRInputStream.read_long();
                java.lang.Object object2 = this.m_sync_state;
                synchronized (object2) {
                    if (bl) {
                        iIOPClientRequest = (IIOPClientRequest)this.m_active_requests.get(NumberCache.getInteger(n2));
                    } else {
                        iIOPClientRequest = (IIOPClientRequest)this.m_active_requests.remove(NumberCache.getInteger(n2));
                        if (this.m_active_requests.isEmpty()) {
                            this.m_channel_age = RequestIDAllocator.peek_request_id();
                            bl2 = this.m_pending_close && (this.m_server_peer == null || this.m_server_peer.getActiveRequestMap().isEmpty());
                        }
                    }
                }
                if (iIOPClientRequest == null) {
                    if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                        this.getLogger().debug(this + "request #" + n2 + (bl ? "" : " last") + " reply fragment discarded, no corresponding request.");
                    }
                } else if (!iIOPClientRequest.checkReplyTransportAssoc(object)) {
                    iIOPClientRequest = null;
                    if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                        this.getLogger().debug(this + "request #" + n2 + (bl ? "" : " last") + " reply fragment discarded, sender not authorized.");
                    }
                } else {
                    if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                        this.getLogger().debug(this + "request #" + n2 + (bl ? "" : " last") + " reply fragment received");
                    }
                    iIOPClientRequest.setReplySource(bufferSource);
                    n = cDRInputStream.read_long();
                    if (by >= 2) {
                        if (by2 == 1) {
                            serviceContextArray = ServiceContextListHelper.read(cDRInputStream);
                        }
                        try {
                            cDRInputStream.alignment(8);
                        }
                        catch (MARSHAL mARSHAL) {
                        }
                    }
                }
                java.lang.Object var15_17 = null;
            }
            catch (SystemException systemException) {
                if (iIOPClientRequest == null) {
                    this.close(true, this.m_close_exception);
                } else {
                    iIOPClientRequest.cancel(systemException);
                }
                int n3 = n2;
                java.lang.Object var15_18 = null;
                bufferSource.removeWaitingForBufferListener(null);
                return n3;
            }
            bufferSource.removeWaitingForBufferListener(null);
        }
        catch (Throwable throwable) {
            java.lang.Object var15_19 = null;
            bufferSource.removeWaitingForBufferListener(null);
            throw throwable;
        }
        if (iIOPClientRequest != null) {
            iIOPClientRequest.handle_reply(n, serviceContextArray, cDRInputStream);
        }
        if (bl2) {
            if (this.m_delegated) {
                this.m_server_peer.soft_close(false);
            } else {
                this.close(false, this.m_close_exception);
            }
        }
        return n2;
    }

    void process_fragment(int n, StorageBuffer storageBuffer, boolean bl, java.lang.Object object) {
        IIOPClientRequest iIOPClientRequest;
        boolean bl2 = false;
        java.lang.Object object2 = this.m_sync_state;
        synchronized (object2) {
            if (bl) {
                iIOPClientRequest = (IIOPClientRequest)this.m_active_requests.get(NumberCache.getInteger(n));
            } else {
                iIOPClientRequest = (IIOPClientRequest)this.m_active_requests.remove(NumberCache.getInteger(n));
                if (this.m_active_requests.isEmpty()) {
                    this.m_channel_age = RequestIDAllocator.peek_request_id();
                    bl2 = this.m_pending_close && (this.m_server_peer == null || this.m_server_peer.getActiveRequestMap().isEmpty());
                }
            }
        }
        if (iIOPClientRequest == null) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug(this + "request #" + n + (bl ? "" : " last") + " reply fragment discarded, no corresponding request.");
            }
        } else if (!iIOPClientRequest.checkReplyTransportAssoc(object)) {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug(this + "request #" + n + (bl ? "" : " last") + " reply fragment discarded, sender not authorized.");
            }
        } else {
            if (this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug(this + " request #" + n + (bl ? "" : " last") + " reply fragment.");
            }
            iIOPClientRequest.getReplySource().addLast(storageBuffer, !bl);
        }
        if (bl2) {
            if (this.m_delegated) {
                this.m_server_peer.soft_close(false);
            } else {
                this.close(false, this.m_close_exception);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close(false, new BAD_INV_ORDER(1330446340, CompletionStatus.COMPLETED_NO));
    }

    private Logger getLogger() {
        return this.m_logger;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MarshalListener
    implements MarshalBuffer.Listener {
        private boolean m_fragment_sent = false;

        private MarshalListener() {
        }

        public void availIncreaced(MarshalBuffer marshalBuffer, int n, java.lang.Object object) {
            while (n > 120000) {
                this.m_fragment_sent = true;
                IIOPClientRequest iIOPClientRequest = (IIOPClientRequest)object;
                if (iIOPClientRequest.state() != 1) {
                    return;
                }
                StorageBuffer storageBuffer = marshalBuffer.fragment(120000);
                if (IIOPClientChannel.this.m_socket_queue.send(storageBuffer, iIOPClientRequest.get_transport_association()) && IIOPClientChannel.this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    IIOPClientChannel.this.getLogger().info(IIOPClientChannel.this + "request #" + iIOPClientRequest.request_id() + " fragment sent");
                }
                n -= 120000;
            }
        }

        public void bufferClosed(MarshalBuffer marshalBuffer, int n, java.lang.Object object) {
            IIOPClientRequest iIOPClientRequest = (IIOPClientRequest)object;
            if (iIOPClientRequest.state() != 1) {
                return;
            }
            StorageBuffer storageBuffer = marshalBuffer.lastFragment();
            if (IIOPClientChannel.this.m_socket_queue.send(storageBuffer, iIOPClientRequest.get_transport_association()) && IIOPClientChannel.this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                IIOPClientChannel.this.getLogger().debug(IIOPClientChannel.this + " request #" + iIOPClientRequest.request_id() + " last fragment sent");
            }
            if (IIOPClientChannel.this.m_pending_service_ctxt && !iIOPClientRequest.is_locate()) {
                java.lang.Object object2 = IIOPClientChannel.this.m_sync_state;
                synchronized (object2) {
                    IIOPClientChannel.this.connectionSCSent();
                    IIOPClientChannel.this.m_pending_service_ctxt = false;
                    IIOPClientChannel.this.m_sync_state.notifyAll();
                }
            }
        }

        public void bufferCanceled(MarshalBuffer marshalBuffer, SystemException systemException, java.lang.Object object) {
            IIOPClientRequest iIOPClientRequest = (IIOPClientRequest)object;
            IIOPClientChannel.this.cancel_request(iIOPClientRequest, this.m_fragment_sent);
            if (iIOPClientRequest.state() != 1) {
                return;
            }
            systemException.completed = CompletionStatus.COMPLETED_NO;
            iIOPClientRequest.cancel(systemException);
            throw systemException;
        }
    }
}

