/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.IIOP.ListenPoint;
import org.omg.IIOP.ListenPointHelper;
import org.omg.IIOP.ProfileBody_1_0Helper;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHelper;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.iiop.CodeSetDatabase;
import org.openorb.net.AbstractAddress;
import org.openorb.net.Address;
import org.openorb.util.ExceptionTool;
import org.openorb.util.Trace;

public class IIOPAddress
extends AbstractAddress
implements Cloneable {
    private InetAddress m_host;
    private String m_host_name;
    private int m_port;
    private Version m_version;
    private int m_orb_type = 0;
    private int m_hash = -1;
    private String m_protocol = "iiop";
    private CodeSetComponentInfo m_codeset_component_info = null;
    private IIOPAddress[] m_alternates = null;
    public static final short MASK_PRI_VERSION = 15;
    public static final short[] PRI_VERSION = new short[]{15, 14, 13};
    public static final short PRI_FLAG_ALTERNATE = 2048;
    public static final short PRI_FLAG_NONPRIMARY = 1024;
    public static final short MASK_PRI_SECURE = 240;
    public static final short PRI_UNSECURE = 240;

    private IIOPAddress() {
    }

    public void setHost(InetAddress inetAddress) {
        if (inetAddress != null) {
            this.m_host = inetAddress;
            this.m_host_name = inetAddress.getHostName();
            this.m_hash = -1;
        }
    }

    public void setPort(int n) {
        if (n != 0) {
            this.m_port = n;
            this.m_hash = -1;
        }
    }

    public void setProtocol(String string) {
        this.m_protocol = string;
        this.m_hash = -1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trace.signalIllegalCondition(null, "Clone operation not supported (" + cloneNotSupportedException + ").");
            return null;
        }
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    public String get_hostname() {
        return this.m_host_name;
    }

    public InetAddress get_host() {
        return this.m_host;
    }

    public int get_port() {
        return this.m_port;
    }

    public Version get_version() {
        return this.m_version;
    }

    public int get_orb_type() {
        return this.m_orb_type;
    }

    public CodeSetComponentInfo getCodesetComponentInfo() {
        return this.m_codeset_component_info;
    }

    public Address[] get_alternates() {
        return this.m_alternates;
    }

    public String getEndpointString() {
        return this.m_protocol + ":" + this.m_version.major + "." + this.m_version.minor + "@" + this.m_host_name + ":" + this.m_port;
    }

    public String getEndpointDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getEndpointString());
        if (this.m_host == null) {
            stringBuffer.append(" host unknown");
        } else {
            boolean bl = false;
            if (this.getPriority((short)240) != 240) {
                stringBuffer.append(" flags: secure(");
                stringBuffer.append(this.getPriority((short)240) >> 8);
                stringBuffer.append(")");
                bl = true;
            }
            if (this.getPriority((short)1024) == 0) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    stringBuffer.append(" flags: ");
                }
                stringBuffer.append("primary");
                bl = true;
            }
            if (this.getPriority((short)2048) != 0) {
                if (bl) {
                    stringBuffer.append(", ");
                } else {
                    stringBuffer.append(" flags: ");
                }
                stringBuffer.append("alternate");
            }
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        if (this.m_hash == -1) {
            this.m_hash = super.hashCode() ^ this.m_host.hashCode() ^ this.m_port ^ this.m_protocol.hashCode();
        }
        return this.m_hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IIOPAddress)) {
            return false;
        }
        IIOPAddress iIOPAddress = (IIOPAddress)object;
        if (this.m_port != iIOPAddress.m_port || !this.m_host_name.equals(iIOPAddress.m_host_name) || !this.m_protocol.equals(iIOPAddress.m_protocol) || this.m_version.major != iIOPAddress.m_version.major || this.m_version.minor != iIOPAddress.m_version.minor) {
            return false;
        }
        return super.equals(object);
    }

    static IIOPAddress[] get_addresses(Codec codec, IOR iOR, int n, Logger logger) {
        if (iOR.profiles[n].tag != 0) {
            throw new INV_OBJREF("Invalid tag for object reference", 1146056972, CompletionStatus.COMPLETED_NO);
        }
        IIOPAddress iIOPAddress = new IIOPAddress();
        iIOPAddress.set_ior(iOR, n);
        byte[] byArray = iOR.profiles[n].profile_data;
        if (byArray[1] != 1) {
            return new IIOPAddress[0];
        }
        TaggedComponent[] taggedComponentArray = null;
        try {
            int n2;
            int n3;
            short s;
            Object object;
            TaggedComponent[] taggedComponentArray2;
            switch (byArray[2]) {
                case 0: {
                    IDLEntity iDLEntity = ProfileBody_1_0Helper.extract(codec.decode_value(byArray, ProfileBody_1_0Helper.type()));
                    iIOPAddress.m_version = iDLEntity.iiop_version;
                    iIOPAddress.m_host_name = iDLEntity.host;
                    iIOPAddress.m_port = iDLEntity.port & 0xFFFF;
                    iIOPAddress.set_oid(iDLEntity.object_key);
                    taggedComponentArray = new TaggedComponent[]{};
                    break;
                }
                default: {
                    IDLEntity iDLEntity = ProfileBody_1_1Helper.extract(codec.decode_value(byArray, ProfileBody_1_1Helper.type()));
                    iIOPAddress.m_version = ((ProfileBody_1_1)iDLEntity).iiop_version;
                    iIOPAddress.m_host_name = ((ProfileBody_1_1)iDLEntity).host;
                    iIOPAddress.m_port = ((ProfileBody_1_1)iDLEntity).port & 0xFFFF;
                    iIOPAddress.set_oid(((ProfileBody_1_1)iDLEntity).object_key);
                    taggedComponentArray = ((ProfileBody_1_1)iDLEntity).components;
                    if (iIOPAddress.m_version.minor <= 2) break;
                    iIOPAddress.m_version.minor = (byte)2;
                }
            }
            try {
                iIOPAddress.m_host = InetAddress.getByName(iIOPAddress.m_host_name);
            }
            catch (UnknownHostException unknownHostException) {
                iIOPAddress.m_host = null;
                iIOPAddress.m_hash = iIOPAddress.m_host_name.hashCode() ^ iIOPAddress.m_port;
            }
            int n4 = 0;
            int n5 = 0;
            while (n5 < iOR.profiles.length) {
                if (iOR.profiles[n5].tag == 1) {
                    ++n4;
                }
                ++n5;
            }
            if (n4 == 0) {
                taggedComponentArray2 = taggedComponentArray;
            } else {
                if (taggedComponentArray != null) {
                    object = new TaggedComponent[n4 + 1][];
                    object[n4] = taggedComponentArray;
                } else {
                    object = new TaggedComponent[n4][];
                }
                s = 0;
                while (s < iOR.profiles.length && n4 > 0) {
                    if (iOR.profiles[s].tag == 1) {
                        object[--n4] = TaggedComponentSeqHelper.extract(codec.decode_value(iOR.profiles[s].profile_data, TaggedComponentSeqHelper.type()));
                    }
                    ++s;
                }
                n4 = 0;
                int n6 = 0;
                while (n6 < ((TaggedComponent[][])object).length) {
                    n4 += object[n6].length;
                    ++n6;
                }
                taggedComponentArray2 = new TaggedComponent[n4];
                n4 = 0;
                n3 = 0;
                while (n3 < ((TaggedComponent[][])object).length) {
                    System.arraycopy(object[n3], 0, taggedComponentArray2, n4, object[n3].length);
                    n4 += ((Object)object[n3]).length;
                    ++n3;
                }
            }
            iIOPAddress.set_components(taggedComponentArray2, taggedComponentArray.length);
            object = new ORBSingleton();
            s = (short)(0x4F0 | PRI_VERSION[byArray[2]]);
            ArrayList<ListenPoint> arrayList = new ArrayList<ListenPoint>();
            n3 = 0;
            while (n3 < taggedComponentArray2.length) {
                switch (taggedComponentArray2[n3].tag) {
                    case 3: {
                        ListenPoint listenPoint = ListenPointHelper.extract(codec.decode_value(taggedComponentArray2[n3].component_data, ListenPointHelper.type()));
                        arrayList.add(listenPoint);
                        iIOPAddress.set_component_data(n3, new TagAlternateIIOPAddressData(taggedComponentArray2[n3].tag, listenPoint.host, listenPoint.port));
                        break;
                    }
                    case 0: {
                        iIOPAddress.m_orb_type = codec.decode_value(taggedComponentArray2[n3].component_data, ((ORBSingleton)object).get_primitive_tc(TCKind.tk_long)).extract_long();
                        iIOPAddress.set_component_data(n3, new TagOrbTypeData(taggedComponentArray2[n3].tag, iIOPAddress.m_orb_type));
                        break;
                    }
                    case 1: {
                        iIOPAddress.m_codeset_component_info = CodeSetComponentInfoHelper.extract(codec.decode_value(taggedComponentArray2[n3].component_data, CodeSetComponentInfoHelper.type()));
                        iIOPAddress.set_component_data(n3, new TagCodeSetsData(taggedComponentArray2[n3].tag, iIOPAddress.m_codeset_component_info));
                        break;
                    }
                    case 20: {
                        byte[] byArray2 = taggedComponentArray2[n3].component_data;
                        n2 = byArray2[2] << 8 & 0xFF00 | byArray2[3] & 0xFF;
                        int n7 = byArray2[4] << 8 & 0xFF00 | byArray2[5] & 0xFF;
                        int n8 = byArray2[6] << 8 & 0xFF00 | byArray2[7] & 0xFF;
                        iIOPAddress.set_component_data(n3, new TagSSLSecTransData(taggedComponentArray2[n3].tag, n8, n2, n7));
                        break;
                    }
                    case 28: {
                        boolean bl;
                        boolean bl2 = bl = taggedComponentArray2[n3].component_data[1] != 0;
                        if (bl) {
                            s = (short)(s & 0xFFFFFBFF);
                        }
                        iIOPAddress.set_component_data(n3, new TagFTPrimaryData(taggedComponentArray2[n3].tag, bl));
                        break;
                    }
                    case 29: {
                        boolean bl = taggedComponentArray2[n3].component_data[1] != 0;
                        iIOPAddress.set_component_data(n3, new TagFTHeartbeatEnabledData(taggedComponentArray2[n3].tag, bl));
                        break;
                    }
                    case 2: {
                        throw new NO_IMPLEMENT();
                    }
                }
                ++n3;
            }
            iIOPAddress.setPriority(s);
            IIOPAddress[] iIOPAddressArray = new IIOPAddress[1 + arrayList.size()];
            iIOPAddressArray[0] = iIOPAddress;
            n2 = 0;
            while (n2 < arrayList.size()) {
                ListenPoint listenPoint = (ListenPoint)arrayList.get(n2);
                iIOPAddressArray[n2 + 1] = (IIOPAddress)iIOPAddress.clone();
                iIOPAddressArray[n2 + 1].m_host_name = listenPoint.host;
                try {
                    iIOPAddressArray[n2 + 1].m_host = InetAddress.getByName(listenPoint.host);
                }
                catch (UnknownHostException unknownHostException) {
                    iIOPAddressArray[n2 + 1].m_host = null;
                    iIOPAddressArray[n2 + 1].m_hash = iIOPAddressArray[n2 + 1].m_host_name.hashCode() ^ iIOPAddressArray[n2 + 1].m_port;
                }
                iIOPAddressArray[n2 + 1].m_port = listenPoint.port & 0xFFFF;
                iIOPAddressArray[n2 + 1].setPriority((short)2048, (short)2048);
                ++n2;
            }
            return iIOPAddressArray;
        }
        catch (FormatMismatch formatMismatch) {
            logger.error("Profile data cannot be parsed.", formatMismatch);
            throw ExceptionTool.initCause(new INV_OBJREF("Profile data cannot be parsed (" + formatMismatch + ")", 1146056973, CompletionStatus.COMPLETED_NO), (Throwable)formatMismatch);
        }
        catch (TypeMismatch typeMismatch) {
            logger.error("Profile data cannot be parsed.", typeMismatch);
            throw ExceptionTool.initCause(new INV_OBJREF("Profile data cannot be parsed (" + typeMismatch + ")", 1146056973, CompletionStatus.COMPLETED_NO), (Throwable)typeMismatch);
        }
    }

    private static final class TagSSLSecTransData
    extends AbstractTagData {
        private final int m_port;
        private final int m_serverSupports;
        private final int m_serverRequires;

        private TagSSLSecTransData(int n, int n2, int n3, int n4) {
            super(n);
            this.m_port = n2;
            this.m_serverSupports = n3;
            this.m_serverRequires = n4;
        }

        protected StringBuffer createMessage() {
            StringBuffer stringBuffer = super.createMessage();
            stringBuffer.append(" TAG_SSL_SEC_TRANS");
            stringBuffer.append("\n    SSL Port: ");
            stringBuffer.append(this.m_port & 0xFFFF);
            stringBuffer.append(" (");
            this.appendIntAsHex(stringBuffer, this.m_port);
            stringBuffer.append(") ");
            stringBuffer.append("\n\tServer Requires: ");
            this.appendIntAsHex(stringBuffer, this.m_serverRequires);
            stringBuffer.append(" : ");
            this.appendDescription(stringBuffer, this.m_serverRequires);
            stringBuffer.append("\n\tServer Supports: ");
            this.appendIntAsHex(stringBuffer, this.m_serverSupports);
            stringBuffer.append(" : ");
            this.appendDescription(stringBuffer, this.m_serverSupports);
            return stringBuffer;
        }

        private StringBuffer appendDescription(StringBuffer stringBuffer, int n) {
            boolean bl = false;
            if ((n & 1) != 0) {
                stringBuffer.append(" Unprotected Invocation");
                bl = true;
            }
            if ((n & 2) != 0) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(" Integrity");
                bl = true;
            }
            if ((n & 4) != 0) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(" Confidentiality");
                bl = true;
            }
            if ((n & 8) != 0) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(" Detect Replay");
                bl = true;
            }
            if ((n & 0x10) != 0) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(" Detect Misordering");
                bl = true;
            }
            switch (n & 0x60) {
                case 96: {
                    if (bl) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(" Client and Server Authentication");
                    bl = true;
                    break;
                }
                case 64: {
                    if (bl) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(" Client Authentication");
                    bl = true;
                    break;
                }
                case 32: {
                    if (bl) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(" Server Authentication");
                    bl = true;
                }
            }
            if ((n & 0x80) != 0) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(" No Delegation");
                bl = true;
            }
            if ((n & 0x100) != 0) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(" Simple Delegation");
                bl = true;
            }
            if ((n & 0x200) != 0) {
                if (bl) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(" No Delegation");
            }
            return stringBuffer;
        }
    }

    private static final class TagAlternateIIOPAddressData
    extends AbstractTagData {
        private final String m_host;
        private final short m_port;

        private TagAlternateIIOPAddressData(int n, String string, short s) {
            super(n);
            this.m_host = string;
            this.m_port = s;
        }

        protected StringBuffer createMessage() {
            StringBuffer stringBuffer = super.createMessage();
            stringBuffer.append(" TAG_ALTERNATE_IIOP_ADDRESS\n");
            stringBuffer.append("\tHost: " + this.m_host);
            stringBuffer.append("\n\tPort: " + (this.m_port & 0xFFFF));
            return stringBuffer;
        }
    }

    private static final class TagOrbTypeData
    extends AbstractTagData {
        private final int m_orbType;

        private TagOrbTypeData(int n, int n2) {
            super(n);
            this.m_orbType = n2;
        }

        protected StringBuffer createMessage() {
            StringBuffer stringBuffer = super.createMessage();
            stringBuffer.append(" TAG_ORB_TYPE\n\tORB Type: ");
            this.appendIntAsHex(stringBuffer, this.m_orbType);
            return stringBuffer;
        }
    }

    private static final class TagCodeSetsData
    extends AbstractTagData {
        private final CodeSetComponentInfo m_info;

        private TagCodeSetsData(int n, CodeSetComponentInfo codeSetComponentInfo) {
            super(n);
            this.m_info = codeSetComponentInfo;
        }

        protected StringBuffer createMessage() {
            StringBuffer stringBuffer = super.createMessage();
            stringBuffer.append(" TAG_CODE_SETS\n    For char data: ");
            int n = this.m_info.ForCharData.native_code_set;
            int n2 = 0;
            while (n2 <= this.m_info.ForCharData.conversion_code_sets.length) {
                stringBuffer.append("\n        ");
                stringBuffer.append(n == this.m_info.ForCharData.native_code_set ? "SNCS" : "SCCS");
                stringBuffer.append(":");
                this.appendIntAsHex(stringBuffer, n);
                stringBuffer.append(" '");
                stringBuffer.append(CodeSetDatabase.getNameFromId(n));
                stringBuffer.append("' '");
                stringBuffer.append(CodeSetDatabase.getDescriptionFromId(n));
                stringBuffer.append("'");
                if (n2 < this.m_info.ForCharData.conversion_code_sets.length) {
                    n = this.m_info.ForCharData.conversion_code_sets[n2];
                }
                ++n2;
            }
            stringBuffer.append("\n    For wchar data: ");
            n = this.m_info.ForWcharData.native_code_set;
            int n3 = 0;
            while (n3 <= this.m_info.ForWcharData.conversion_code_sets.length) {
                stringBuffer.append("\n        ");
                stringBuffer.append(n == this.m_info.ForWcharData.native_code_set ? "SNCS" : "SCCS");
                stringBuffer.append(":");
                this.appendIntAsHex(stringBuffer, n);
                stringBuffer.append(" '");
                stringBuffer.append(CodeSetDatabase.getNameFromId(n));
                stringBuffer.append("' '");
                stringBuffer.append(CodeSetDatabase.getDescriptionFromId(n));
                stringBuffer.append("'");
                if (n3 < this.m_info.ForWcharData.conversion_code_sets.length) {
                    n = this.m_info.ForWcharData.conversion_code_sets[n3];
                }
                ++n3;
            }
            return stringBuffer;
        }
    }

    private static final class TagFTPrimaryData
    extends AbstractTagData {
        private final boolean m_primaryProfile;

        private TagFTPrimaryData(int n, boolean bl) {
            super(n);
            this.m_primaryProfile = bl;
        }

        protected StringBuffer createMessage() {
            StringBuffer stringBuffer = super.createMessage();
            stringBuffer.append(" FT.TAG_FT_PRIMARY\n\t" + (this.m_primaryProfile ? " Primary " : " NonPrimary "));
            stringBuffer.append("profile");
            return stringBuffer;
        }
    }

    private static final class TagFTHeartbeatEnabledData
    extends AbstractTagData {
        private final boolean m_heartbeatEnabled;

        private TagFTHeartbeatEnabledData(int n, boolean bl) {
            super(n);
            this.m_heartbeatEnabled = bl;
        }

        protected StringBuffer createMessage() {
            StringBuffer stringBuffer = super.createMessage();
            stringBuffer.append(" TAG_FT_HEARTBEAT_ENABLED\n\tHeartbeat ");
            stringBuffer.append(this.m_heartbeatEnabled ? "enabled" : "disabled");
            return stringBuffer;
        }
    }

    private static abstract class AbstractTagData {
        private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private static final int DIGIT_MASK = 15;
        private final int m_componentId;
        private String m_msg;

        protected AbstractTagData(int n) {
            this.m_componentId = n;
        }

        protected StringBuffer createMessage() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ComponentID = ");
            stringBuffer.append(this.m_componentId);
            return stringBuffer;
        }

        protected final void appendIntAsHex(StringBuffer stringBuffer, int n) {
            stringBuffer.ensureCapacity(stringBuffer.length() + 10);
            stringBuffer.append("0x");
            int n2 = 28;
            while (n2 >= 0) {
                stringBuffer.append(HEX_DIGITS[n >> n2 & 0xF]);
                n2 -= 4;
            }
        }

        public synchronized String toString() {
            if (null == this.m_msg) {
                this.m_msg = this.createMessage().toString();
            }
            return this.m_msg;
        }
    }
}

