/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import org.omg.GIOP.Version;
import org.openorb.iiop.CDROutputStream;
import org.openorb.io.MarshalBuffer;

final class HeaderBlock
implements MarshalBuffer.HeaderGenerator {
    private static final byte[][] GIOP_HEADERS = new byte[][]{{71, 73, 79, 80, 1, 0}, {71, 73, 79, 80, 1, 1}, {71, 73, 79, 80, 1, 2}};
    private byte m_msgType;
    private int m_reqID;
    private byte[] m_reqIDBytes;
    private Version m_version;

    HeaderBlock(byte by, int n, CDROutputStream cDROutputStream) {
        this.m_msgType = by;
        this.m_reqID = n;
        this.m_version = cDROutputStream.version();
        cDROutputStream.write_octet_array(GIOP_HEADERS[this.m_version.minor], 0, 6);
        cDROutputStream.addHeader(this, 6, this.m_version.minor >= 2, null);
    }

    public void endMessage(byte[] byArray, int n, int n2, boolean bl, int n3, Object object) {
        byArray[n] = bl ? 2 : 0;
        byArray[n + 1] = this.m_msgType;
        byArray[n + 2] = (byte)((n3 -= 6) >>> 24);
        byArray[n + 3] = (byte)(n3 >>> 16);
        byArray[n + 4] = (byte)(n3 >>> 8);
        byArray[n + 5] = (byte)n3;
        this.m_msgType = (byte)7;
    }

    public void beginMessage(MarshalBuffer marshalBuffer, Object object) {
        marshalBuffer.append(GIOP_HEADERS[this.m_version.minor], 0, 6);
        marshalBuffer.addHeader(this, 6, this.m_version.minor >= 2, null);
        if (this.m_version.minor >= 2) {
            if (this.m_reqIDBytes == null) {
                this.m_reqIDBytes = new byte[]{(byte)(this.m_reqID >>> 24), (byte)(this.m_reqID >>> 16), (byte)(this.m_reqID >>> 8), (byte)this.m_reqID};
            }
            marshalBuffer.append(this.m_reqIDBytes, 0, 4);
        }
    }
}

