/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter.poa;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Contained;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.portable.Delegate;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.adapter.poa.CurrentImpl;
import org.openorb.adapter.poa.DispatchState;
import org.openorb.util.ExceptionTool;
import org.openorb.util.JREVersion;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

class DelegateImpl
implements Delegate {
    private ORB m_orb;
    private CurrentImpl m_curr;
    private POA m_rootPOA;
    private Logger m_logger;

    public DelegateImpl(ORB oRB) {
        this.m_orb = oRB;
    }

    public void init() {
        try {
            this.m_curr = (CurrentImpl)this.m_orb.resolve_initial_references("POACurrent");
            this.m_rootPOA = (POA)this.m_orb.resolve_initial_references("RootPOA");
        }
        catch (InvalidName invalidName) {
            if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Unable to initialize POA delegate.", invalidName);
            }
            throw ExceptionTool.initCause(new INITIALIZE("Unable to initialize POA delegate (" + invalidName + ")"), (Throwable)invalidName);
        }
        catch (ClassCastException classCastException) {
            if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Unable to initialize POA delegate.", classCastException);
            }
            throw ExceptionTool.initCause(new INITIALIZE("Unable to initialize POA delegate (" + classCastException + ")"), (Throwable)classCastException);
        }
    }

    public ORB orb(Servant servant) {
        return this.m_orb;
    }

    public Object this_object(Servant servant) {
        String[] stringArray;
        byte[] byArray;
        POA pOA;
        block10: {
            pOA = null;
            byArray = null;
            try {
                stringArray = this.m_curr.peek();
                if (stringArray.getServant() == servant) {
                    pOA = stringArray.getPoa();
                    byArray = stringArray.getObjectID();
                }
            }
            catch (NoContext noContext) {
                if (JREVersion.V1_4 || !this.getLogger().isDebugEnabled() || !Trace.isMedium()) break block10;
                this.getLogger().debug("No context available.", noContext);
            }
        }
        if (pOA == null) {
            pOA = servant._default_POA();
            if (pOA == null) {
                throw new OBJ_ADAPTER();
            }
            try {
                byArray = pOA.servant_to_id(servant);
            }
            catch (ServantNotActive servantNotActive) {
                if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug("The servant is not active yet.", servantNotActive);
                }
                throw ExceptionTool.initCause(new OBJ_ADAPTER(), (Throwable)servantNotActive);
            }
            catch (WrongPolicy wrongPolicy) {
                if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                    this.getLogger().debug("The servant has a wrong policy.", wrongPolicy);
                }
                throw ExceptionTool.initCause(new OBJ_ADAPTER(), (Throwable)wrongPolicy);
            }
        }
        stringArray = servant._all_interfaces(pOA, byArray);
        return pOA.create_reference_with_id(byArray, stringArray[0]);
    }

    public POA poa(Servant servant) {
        block3: {
            try {
                DispatchState dispatchState = this.m_curr.peek();
                if (dispatchState.getServant() == servant) {
                    return dispatchState.getPoa();
                }
                Trace.signalIllegalCondition(this.getLogger(), "No Context, i.e. state.getServant() != self");
            }
            catch (NoContext noContext) {
                if (JREVersion.V1_4 || !this.getLogger().isDebugEnabled() || !Trace.isMedium()) break block3;
                this.getLogger().debug("No context available for servant " + servant, noContext);
            }
        }
        throw new OBJ_ADAPTER("No Context");
    }

    public byte[] object_id(Servant servant) {
        block3: {
            try {
                DispatchState dispatchState = this.m_curr.peek();
                if (dispatchState.getServant() == servant) {
                    return dispatchState.getObjectID();
                }
                Trace.signalIllegalCondition(this.getLogger(), "No Context, i.e. state.getServant() != self");
            }
            catch (NoContext noContext) {
                if (JREVersion.V1_4 || !this.getLogger().isDebugEnabled() || !Trace.isMedium()) break block3;
                this.getLogger().debug("No context available.", noContext);
            }
        }
        throw new OBJ_ADAPTER("No Context");
    }

    public POA default_POA(Servant servant) {
        return this.m_rootPOA;
    }

    public boolean is_a(Servant servant, String string) {
        java.lang.Object object = RepoIDHelper.createIsATest(string);
        if (object.equals("IDL:omg.org/CORBA/Object:1.0")) {
            return true;
        }
        String[] stringArray = servant._all_interfaces(this.poa(servant), this.object_id(servant));
        int n = 0;
        while (n < stringArray.length) {
            if (object.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean non_existent(Servant servant) {
        return false;
    }

    public InterfaceDef get_interface(Servant servant) {
        try {
            return InterfaceDefHelper.narrow(this.get_interface_def(servant));
        }
        catch (BAD_PARAM bAD_PARAM) {
            if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Could not narrow obj to type InterfaceDef.", bAD_PARAM);
            }
            throw ExceptionTool.initCause(new INTF_REPOS(1146056721, CompletionStatus.COMPLETED_NO), (Throwable)bAD_PARAM);
        }
    }

    public Object get_interface_def(Servant servant) {
        Repository repository;
        Object object;
        String string = servant._all_interfaces(this.poa(servant), this.object_id(servant))[0];
        try {
            object = this.m_orb.resolve_initial_references("InterfaceRepository");
        }
        catch (InvalidName invalidName) {
            if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Could not resolve InterfaceRepository.", invalidName);
            }
            throw ExceptionTool.initCause(new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO), (Throwable)invalidName);
        }
        if (object._non_existent()) {
            throw new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO);
        }
        try {
            repository = RepositoryHelper.narrow(object);
        }
        catch (BAD_PARAM bAD_PARAM) {
            if (!JREVersion.V1_4 && this.getLogger().isDebugEnabled() && Trace.isMedium()) {
                this.getLogger().debug("Could not narrow obj to type Repository.", bAD_PARAM);
            }
            throw ExceptionTool.initCause(new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO), (Throwable)bAD_PARAM);
        }
        Contained contained = repository.lookup_id(string);
        if (contained == null) {
            throw new INTF_REPOS(1146056720, CompletionStatus.COMPLETED_NO);
        }
        return contained;
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }
}

